from time import sleep
from hytest import *
import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/账号管理/用户管理模块/用户状态设置.csv')

class User_Status_000x:
    tags = ['用户管理功能' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 用户状态设置测试报告 --test 用户状态设置_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以用户状态设置功能。
            本函数根据参数选择用户进行【启用】与【停用】操作，并检查停用、启用后登录系统的提示信息是否与预期相符。
        """
        sleep(5)
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        username, status_type, check_text = self.para

        # 根据status_type执行相应的功能测试
        INFO(f'{status_type}功能')
        STEP(1, f'选择用户：{username}，点击{status_type}按钮')
        INFO(f'输入用户名：{username}进行搜索')
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), username, wd)
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
        sleep(2)
        INFO(f'点击{status_type}按钮')
        safe_click((By.XPATH, "//i[contains(@class,'el-icon-minus')]"), wd)
        sleep(1)

        STEP(2, '检查二次确认弹窗UI')
        if status_type == '停用':
            notify_text = elment_get_text((By.XPATH, f"//p[contains(text(),'是否要{status_type}此账号?')]"), wd)
            INFO(f'校验二次确认弹窗UI：{notify_text}')
            CHECK_POINT('校验二次确认弹窗UI', f'是否要{status_type}此账号?' in notify_text)
        elif status_type == '启用':
            notify_text = elment_get_text((By.XPATH, f"//p[contains(text(),'是否{status_type}该账户?')]"), wd)
            INFO(f'校验二次确认弹窗UI：{notify_text}')
            CHECK_POINT('校验二次确认弹窗UI', f'是否{status_type}' in notify_text)

        STEP(3, '点击确定按钮')
        INFO('点击确定按钮')
        safe_click((By.XPATH,
                    "//button[contains(@class,'el-button el-button--default el-button--small el-button--primary')]//span[contains(text(),'确定')]"),
                   wd)
        sleep(2)

        STEP(4, '检查提示信息')
        notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"), 'User_Manage', 'User_Status',
                                      f'{name}检查提示信息')
        INFO(f'校验停用用户提示信息：{notify_text}')
        CHECK_POINT(f'校验{status_type}用户提示信息', notify_text == check_text)

        # 当check_text为'设置成功'时，进一步检查状态回显及登录功能
        if check_text == '设置成功':
            STEP(5, '检查状态回显')
            status_text = elment_get_text((By.XPATH, f"//span[contains(text(),'已{status_type}')]"), wd)
            INFO(f'校验用户状态回显：{status_text}')
            if status_text == '已停用':
                CHECK_POINT('校验停用用户状态回显', status_text == '已停用')
                STEP(6, '退出登录页使用停用账号登录')
                safe_click((By.XPATH, "//img[@title='返回预定首页']"), wd)
                safe_click((By.XPATH, "//img[@title='退出登录']"), wd)
                safe_send_keys((By.XPATH, "//input[@placeholder='请输入账号或手机号或邮箱号']"), username, wd)
                safe_send_keys((By.XPATH, "//input[@placeholder='请输入密码']"), 'Ubains@4321', wd)
                safe_send_keys((By.XPATH, "//input[@placeholder='请输入图形验证码']"), 'csba', wd)
                safe_click((By.XPATH, "//input[@value='登 录']"), wd)
                sleep(2)
                notify_text = get_notify_text(wd, (By.XPATH,"//div[@role='alert']"), 'User_Manage', 'User_Status',
                                              f'{name}检查登录提示信息')
                INFO(f'校验登录提示信息：{notify_text}')
                CHECK_POINT('校验登录提示信息', notify_text == '用户被停用')

                STEP(7, '重新登录管理员账号，回到用户管理界面')
                user_login("admin@ZDH", "Ubains@4321")
                enter_the_backend()
                INFO("打开账号管理下拉菜单")
                safe_click((By.XPATH, "//span[@class='aside_menu menu_account']"), wd)

                INFO("进入用户管理模块")
                safe_click((By.XPATH, "//li[contains(text(),'用户管理')]"), wd)

            elif status_text == '已启用':
                CHECK_POINT('校验用户状态回显', status_text == '已启用')
                STEP(6, '退出登录页使用启用账号登录')
                safe_click((By.XPATH, "//img[@title='返回预定首页']"), wd)
                safe_click((By.XPATH, "//img[@title='退出登录']"), wd)
                safe_send_keys((By.XPATH, "//input[@placeholder='请输入账号或手机号或邮箱号']"), username, wd)
                safe_send_keys((By.XPATH, "//input[@placeholder='请输入密码']"), 'Ubains@4321', wd)
                safe_send_keys((By.XPATH, "//input[@placeholder='请输入图形验证码']"), 'csba', wd)
                safe_click((By.XPATH, "//input[@value='登 录']"), wd)
                sleep(4)
                notify_text = elment_get_text((By.XPATH, f"//span[normalize-space()='{username}']"), wd)
                INFO(f'校验登录提示信息：{notify_text}')
                CHECK_POINT('校验登录提示信息', username in notify_text)
                sleep(2)

        if name == '用户状态设置_004':
            login_url = get_login_url_from_config("标准版预定系统")
            # 清除浏览器，再重新打开浏览器
            wd.get(login_url)
            # 最大化浏览器窗口
            wd.maximize_window()
            user_login("admin@ZDH", "Ubains@4321")
            enter_the_backend()
            wd.refresh()

            INFO("打开账号管理下拉菜单")
            safe_click((By.XPATH, "//span[@class='aside_menu menu_account']"), wd)

            INFO("进入用户管理模块")
            safe_click((By.XPATH, "//li[contains(text(),'用户管理')]"), wd)