from time import sleep
from hytest import *
import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/账号管理/用户管理模块/用户新增.csv')

class Add_User_000x:
    tags = ['用户管理功能' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 用户新增测试报告 --test 用户新增_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以用户新增功能。
            本函数根据参数输入账号、用户名、密码、确认密码、部门、性别、手机号和邮箱，并检查新增后的提示信息是否与预期相符。
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        account, username, password, check_password, department, gender, phone, email, check_text = self.para

        STEP(1, "点击【新增】按钮")
        if name == '用户新增_001':
            safe_click((By.XPATH, "//span[contains(text(),'添 加')]"), wd)
            sleep(1)

        STEP(2,
             f"输入账号：{account}，用户名：{username}，密码：{password}，确认密码: {check_password}，手机号：{phone}，邮箱：{email}")

        #输入确认账号
        safe_send_keys((By.XPATH, "//input[@id='accountChange']"), account, wd)

        #输入确认用户名
        safe_send_keys((By.XPATH, "//input[@placeholder='用户名']"), username, wd)

        #输入密码
        safe_send_keys((By.XPATH, "//input[@placeholder='11位及以上的大小写字母和数字且连续3位及以上不重复和不连续组合']"), password, wd)

        #输入确认密码
        safe_send_keys((By.XPATH, "//input[@placeholder='确认密码']"), check_password, wd)

        #清除下拉框数据
        if name != '用户新增_001':
            safe_click((By.XPATH, "//i[@class='el-tag__close el-icon-close']"),wd)

        #点击部门下拉框
        safe_click((By.XPATH, "//div[@class='el-input el-input--suffix']//input[@placeholder='请选择']"), wd)
        #选择部门
        safe_click((By.XPATH, "/html[1]/body[1]/div[4]/div[1]/div[1]/div[1]/ul[1]/li[1]/label[1]/span[1]/span[1]"), wd)
        #点击性别单选框
        safe_click((By.XPATH, "//span[contains(text(),'男')]"), wd)
        #输入手机号和邮箱
        safe_send_keys((By.XPATH, "//input[@placeholder='手机']"), phone, wd)
        safe_send_keys((By.XPATH, "//input[@placeholder='邮箱']"), email, wd)

        sleep(2)
        #屏幕截图
        SELENIUM_LOG_SCREEN(wd,"50%","User_Manage","User_Add",f"{name}_用户信息填入")
        STEP(3, "点击【确定】按钮")
        #点击确定按钮
        safe_click((By.XPATH, "//div[@aria-label='添加用户']//span[contains(text(),'确定')]"), wd)

        sleep(2)
        notify_text = get_notify_text(wd,(By.XPATH,"//p[@class='el-message__content']"),"User_Manage","User_Add",f"{name}_检查提示信息")
        #输出提示信息
        INFO(f"Alert text: {notify_text}")

        STEP(4, f"校验提示信息: {check_text}")
        # 检查点：验证提示信息是否与预期相符
        CHECK_POINT('弹出提示', notify_text == check_text)

        if check_text == '添加成功':
            safe_click((By.XPATH, "//span[contains(text(),'添 加')]"), wd)
            sleep(1)

        if name == '用户新增_048':
            login_url = get_login_url_from_config("标准版预定系统")
            # 清除浏览器，再重新打开浏览器
            wd.get(login_url)
            # 最大化浏览器窗口
            wd.maximize_window()
            user_login("admin@ZDH", "Ubains@4321")
            enter_the_backend()

            INFO("打开账号管理下拉菜单")
            safe_click((By.XPATH, "//span[@class='aside_menu menu_account']"), wd)

            INFO("进入用户管理模块")
            safe_click((By.XPATH, "//li[contains(text(),'用户管理')]"), wd)