import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建XLSX文件的绝对路径
xlsx_file_path = os.path.join(current_dir, '..', '..', '测试数据', '会议预定快速测试用例.xlsx')

class MeetingManageQuickTest:
    tags = ['预定系统快速测试']
    """
        执行指令是：
            1.cd 预定系统
            2.hytest --report_title 预定系统快速测试测试报告 --report_url_prefix http://nat.ubainsyun.com:31133 --tag 预定系统快速测试
    """
    ddt_cases = read_xlsx_data(xlsx_file_path, case_type="标准版")

    def teststeps(self):
        """
        执行测试步骤函数，主要用于执行读取的测试用例并进行信息统计模块功能测试操作
        """
        # 从全局存储中获取webdriver对象
        wd = GSTORE['wd']
        name = self.name

        for step in self.para:
            # 赋值页面类型page
            page_type = step.get('page')
            # 赋值元素定位类型，并将字符串转为Enum类型
            locator_type = get_by_enum(step.get('locator_type'))
            # 赋值元素值
            locator_value = step.get('locator_value')
            # 赋值元素类型，例如：click点击、input输入框等
            element_type = step.get('element_type')
            # 赋值元素值，例如输入框的输入值
            element_value = step.get('element_value')
            # 赋值预期结果
            expected_result = step.get('expected_result')
            # 赋值等待时间
            # sleep_time = step.get('sleep_time')
            INFO(
                f"页面: {page_type}、元素定位类型: {locator_type}、元素定位值: {locator_value}、元素类型: {element_type}、元素值: {element_value}、预期结果: {expected_result}")

            if element_type == "click":
                safe_click((locator_type, locator_value), wd)
                sleep(2)
                # SELENIUM_LOG_SCREEN(wd, "75")

            elif element_type == "input":
                safe_send_keys((locator_type, locator_value), element_value, wd)
                sleep(2)
                # SELENIUM_LOG_SCREEN(wd, "75")

            elif element_type == "SwitchWindow":
                # 将字符转换为int类型
                element_value = int(element_value)
                wd.switch_to.window(wd.window_handles[element_value])
                sleep(2)
                # SELENIUM_LOG_SCREEN(wd, "75")

            elif element_type == "login":
                # 退出系统登录
                safe_click((By.XPATH, "//div[@class='quit']"), wd)
                sleep(2)
                INFO(f"开始登录，账号为：{element_value[0]}，密码为：{element_value[1]}")
                user_login(element_value[0], element_value[1])
                sleep(2)

            elif element_type == "getTips":
                notify_text = get_notify_text(wd, (locator_type, locator_value))
                INFO(f"获取到的提示信息为：{notify_text}")
                sleep(2)
                CHECK_POINT(f"获取到的提示信息为：{notify_text}", expected_result in notify_text)
                SELENIUM_LOG_SCREEN(wd, "75")

            elif element_type == "getText":
                text = elment_get_text((locator_type, locator_value), wd)
                INFO(f"获取到的文本信息为：{text}")
                CHECK_POINT(f"获取到的文本信息为：{text}", expected_result in text)
                SELENIUM_LOG_SCREEN(wd, "75")