import sys
import os
from appium.webdriver.common.appiumby import AppiumBy

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..')))
from 预定系统.Base.app_base import *
from 预定系统.Base.base import *

class UnifiedPlatformTerminal:
    tags = ['统一平台终端入会']

    def teststeps(self):
        wd = GSTORE['wd']
        app_drive = None
        try:
            # 初始化应用驱动，连接到指定的设备和应用
            app_drive = app_setup_driver("Android", "7.1.2", "127.0.0.1:62001", "com.tencent.wemeet.app",
                                         ".StartupActivity", "127.0.0.1:62001")
            app_drive.implicitly_wait(20)  # 设置缺省等待时间

            # 使用显式等待来等待元素出现
            logging.info("等待登录页加载...")

            # 定位第一场会议按钮元素，并点击按钮
            logging.info("尝试定位【会议名称】按钮元素，并点击按钮")
            meeting_button = app_drive.find_element(AppiumBy.XPATH,
                                                    "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.LinearLayout/androidx.viewpager.widget.ViewPager/android.view.ViewGroup/android.widget.LinearLayout[1]/android.view.ViewGroup/android.widget.RelativeLayout/androidx.recyclerview.widget.RecyclerView/android.view.ViewGroup[2]/android.view.ViewGroup/androidx.appcompat.widget.LinearLayoutCompat/android.view.ViewGroup/android.widget.TextView")
            logging.info("定位会议成功")
            # 点击【加入会议】按钮
            meeting_button.click()
            logging.info("点击【会议】按钮成功")
            sleep(2)

            # 点击【加入会议】按钮
            logging.info("尝试定位【加入会议】按钮元素，并点击按钮")
            join_meeting_button = app_drive.find_element(AppiumBy.XPATH,
                                                         "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.view.ViewGroup/androidx.appcompat.widget.LinearLayoutCompat/androidx.appcompat.widget.LinearLayoutCompat/android.widget.TextView")
            logging.info("定位【加入会议】按钮成功")
            join_meeting_button.click()
            logging.info("点击【加入会议】按钮成功")
            sleep(8)
            INFO("软终端入会画面")
            SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "Unified_Platform", "软终端入会画面")
            # 会议开始后，截取会议画面
            app_drive.get_screenshot_as_file(
                r"D:\GithubData\自动化\ubains-module-test\预定系统\reports\imgs\Exhibit_Inspect\Unified_Platform\软终端入会画面.png")
            sleep(8)
            # 退出会议
            app_drive.back()
            sleep(3)
            meeting_quit_button = app_drive.find_element(AppiumBy.XPATH,
                                                         "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.ScrollView/android.widget.RelativeLayout/android.widget.RelativeLayout/android.widget.LinearLayout/android.widget.RelativeLayout[2]/android.widget.TextView")
            sleep(1)
            meeting_quit_button.click()
            sleep(4)

        except Exception as e:
            # 捕获并记录任何发生的错误
            logging.error(f"发生错误: {e}", exc_info=True)

        finally:
            # 确保驱动程序在测试结束后正确关闭
            if app_drive:
                app_drive.quit()
                logging.info("驱动程序已退出。")