import sys
import os

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..')))
from 预定系统.Base.app_base import *
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/展厅巡检/会议预约.csv')
# 定义时间格式
time_format = "%H:%M"

class IFlytekSpeechTranscription:
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 展厅讯飞语音转录测试测试报告 --report_url_prefix http://nat.ubainsyun.com:31133 --tag 展厅讯飞转录流程测试
    """
    tags = ['展厅讯飞转录流程测试']
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以会议室删除功能。
            本函数根据参数输入会议室名称进行搜索并删除会议室，并检查删除后的提示信息是否与预期相符。
            字段含义：
              name:用例名称
              conference_name:会议室名称
              message_name:会议名称
              message_type:会议类型
              book_type:预约类型
              book_start_time:会议开始时间
              book_end_time:会议结束时间
              message_notification:消息提醒时间
              check_text:检查提示文本
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        name = self.name
        conference_name,message_name,book_type,issue_name,book_start_time,book_end_time,message_notification,check_text = self.para

        # 在会议室列表搜索会议室
        STEP(1, f"在会议室列表搜索：{conference_name}")
        # 展开筛选下拉框
        safe_click((By.XPATH, "//i[@class='el-collapse-item__arrow el-icon-arrow-right']"),wd)
        sleep(1)
        # 输入会议室名称，并点击【查询】按钮
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议室名称']"),conference_name,wd)
        safe_click((By.XPATH, "//button[@type='button']//span[contains(text(),'查询')]"),wd)
        sleep(1)

        # 点击【会议预定】按钮，进入会议预定界面
        STEP(2, "点击【会议预定】按钮")
        safe_click((By.XPATH, "//span[@class='MeetingCityList_t_btn']"),wd)
        sleep(1)
#
        # 在会议预定第一步界面进行数据填入
        STEP(3,"会议第一步数据填写")
        INFO(f"输入会议名称：{message_name}，选择会议类型：视讯融合会议，选择预约类型：{book_type}，选择会议开始时间：{book_start_time}，选择会议结束时间：{book_end_time}")
        # 输入会议名称
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议名称']"),message_name,wd)

        # 判断会议类型
        safe_click((By.XPATH, f"//div[@class='reserve_input']//span[@class='el-checkbox__label'][normalize-space()='讯飞语音转录']"),wd)
        sleep(2)

        # 选择普通会议
        safe_click((By.XPATH, f"//span[contains(text(),'{book_type}')]"), wd)
        sleep(1)

        # 选择签到时间
        INFO("选择提前30分钟开始签到")
        safe_click((By.XPATH, "(//span[@class='el-switch__core'])[2]"),wd)
        safe_click((By.XPATH, "(//span[@class='el-switch__core'])[3]"),wd)
        sleep(1)
        safe_send_keys((By.XPATH, "//input[@id='input_checkin']"), "30", wd)

        # 选择会议开始时间
        current_time = get_current_time_formatted()
        INFO(f"获取当前的时间{current_time}")
        safe_click((By.XPATH, f"//div[normalize-space()='{current_time}']"), wd)
        sleep(1)

        # 在会议预定第二步界面进行数据填入
        STEP(4, "会议第二步数据填写")
        # 点击【下一步】进入会议预定第二步界面
        safe_click((By.XPATH, "//div[contains(text(),'下一步')]"),wd)
        sleep(1)
        safe_click((By.XPATH, "//th[contains(@class,'is-leaf el-table__cell')]//span[contains(@class,'el-checkbox__inner')]"),wd)
        sleep(1)

        # 点击【下一步】按钮
        safe_click((By.XPATH,"//div[contains(text(),'下一步')]"),wd)
        sleep(1)
        safe_click((By.XPATH,"//div[contains(text(),'下一步')]"),wd)

        # 进入会议预约第三步进行填写
        STEP(5, "会议第三步数据填写")

        # 选择消息提醒时间
        INFO(f"选择消息提醒时间：{message_notification}")
        # 判断消息提醒时间是否为全选
        if message_notification == "全选":
            # 点击【全选】按钮
            safe_click((By.XPATH,"//div[@class='Reminds']//span[@class='el-checkbox__label'][contains(text(),'全选')]"),wd)
            sleep(1)
        else:
            # 选择对应的消息提醒时间
            safe_click((By.XPATH, f"//span[contains(text(),'{message_notification}')]"), wd)
            sleep(1)

        # 点击【确定】按钮
        STEP(6, "点击【确定】按钮")
        safe_click((By.XPATH,"//div[contains(text(),'确定')]"),wd)

        # 点击最后【确定】按钮，预定成功后会跳转至已预定界面
        STEP(7, "点击【确定】按钮")
        safe_click((By.XPATH,"//div[contains(@aria-label,'会议信息')]//span[contains(text(),'确定')]"),wd)
        sleep(3)

        # 搜索会议名称
        safe_send_keys((By.XPATH,"//input[@placeholder='输入关键字搜索']"),message_name,wd)
        send_keyboard((By.XPATH,"//input[@placeholder='输入关键字搜索']"), wd)

        # 在已预定列表界面【提前开始】会议
        INFO("提前开始会议")
        safe_click((By.XPATH,"//span[contains(text(),'更多操作')]"),wd)
        safe_click((By.XPATH,"//li[contains(text(),'会议状态')]"),wd)
        sleep(2)
        safe_click((By.XPATH,"//div[@slot='footer']//span[contains(text(),'确定')]"),wd)
        sleep(10)