import sys
import os
from hytest import *

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/会议主流程/会议删除.csv')
# 定义时间格式
time_format = "%H:%M"

class Message_Update_000x:
    tags = ['会议删除','会议预约主流程','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 会议修改测试报告 --test 会议删除_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以删除会议功能。
            本函数根据参数输入会议室名称进行搜索会议，并检查删除后的提示信息是否与预期相符。
            字段含义：
                name:用例名称
                message_name:原会议名称
                check_text:检查提示文本
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        name = self.name
        message_name, book_type, check_text = self.para

        # 切换至已预定列表界面
        STEP(1, '切换至已预定列表界面')
        safe_click((By.XPATH, "//span[contains(text(),'已预订会议')]"),wd)
        sleep(1)

        # 在已预定列表搜索会议
        STEP(1,f"在已预定列表界面搜索会议：{message_name}")
        INFO(f"搜索会议：{message_name}")
        # 输入会议名称
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字搜索']"), message_name, wd)
        # 敲击回车进行搜索
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字搜索']"), wd)
        sleep(1)
        # 获取查询结果
        notify_text = elment_get_text((By.XPATH, f"//div[@class='cell el-tooltip'][contains(text(),'{message_name}')]"),wd)
        INFO(f"搜索结果为：{notify_text}")
        CHECK_POINT("搜索结果是否正确", message_name in notify_text)
        sleep(2)

        STEP(2, "点击【删除会议】按钮")
        if book_type == "普通会议":
            # 点击【会议删除】按钮
            safe_click((By.XPATH, "//span[contains(text(),'删除会议')]"), wd)
            # 点击【取消】按钮
            safe_click((By.XPATH,
                        "//button[contains(@class,'el-button el-button--default el-button--small btn-custom-cancel')]//span[contains(text(),'取消')]"),
                       wd)
            sleep(5)
            # 再次点击【会议删除】按钮
            safe_click((By.XPATH, "//span[contains(text(),'删除会议')]"), wd)
            safe_click((By.XPATH,
                        "//button[contains(@class,'el-button el-button--default el-button--small el-button--primary')]//span[contains(text(),'确定')]"),
                       wd)
            sleep(2)
        elif book_type == "周期会议":
            # 点击【会议删除】按钮
            safe_click((By.XPATH, "//span[contains(text(),'删除会议')]"), wd)
            # 点击【删除本次及后续的周期会议】
            safe_click((By.XPATH,"//span[contains(text(),'删除本次及后续的周期会议')]"), wd)
            sleep(1)
            # 点击【确定】按钮
            safe_click((By.XPATH,"//div[contains(@aria-label,'提示')]//span[contains(text(),'确定')]"), wd)
            sleep(1)

        STEP(4, f"检查删除提示信息是否正确：{check_text}")
        # 获取删除成功提示信息
        notify_text = get_notify_text(wd, (By.XPATH, "//p[@class='el-message__content']"), "Message_Manage","Message_Del",f"{name}删除会议提示信息")
        INFO(f"删除提示信息为：{notify_text}")
        CHECK_POINT("删除提示信息是否正确", check_text in notify_text)