# -*- coding: utf-8 -*-
# cython: language_level=3
import json
import paho.mqtt.client as mqtt

# 创建MQTT客户端
client = mqtt.Client(protocol=mqtt.MQTTv311)

# 连接服务器
broker_address = "192.168.5.215"
port = 1883
client.connect(broker_address, port)

# 发布消息
topic = "/maintain/room/master/client/"
cliet_udid = '79ac2430-6a98-5509-9e99-65b974eb70a1'
message = {
    "action": "_updatemaster",
    "client_udid": cliet_udid,
    "data": [
        {
            "item": "environmental",
            "pm25": 0,
            "co2": 0,
            "temp": 0,
            "tvoc": 0,
            "humi": 0,
            "hcho": 0
        },
        {
            "item": "conference",
            "power": 0,
            "exist": 1,
            "run": "hello world"
        }]
}
client.publish(topic, json.dumps(message), qos=0)

# 断开连接
client.disconnect()
