#!/bin/bash
#------------------------------检测模块------------------------------------------------------------------

#------------------------------服务器检测-start----------------------------------------------------------
LOGFILE="script.log"
exec &> >(tee -a "$LOGFILE")
function checkOS() {
echo -e "\033[36m
**************《请检查当前系统是否适配》**************
         \033[0m"

server_available_mem=`free -g |awk 'NR==2' | awk '{print$7}'`
server_max_mem=`free -g|awk 'NR==2' |awk '{print$2}'`

echo -e "\033[36m
当前系统最大内存为:${server_max_mem}GB 可用内存为:${server_available_mem}GB
\033[0m "

#判断服务器的内存值小于约定的内存大小min_memory_available=10，就返回。否则成功。

if [ $server_available_mem -lt $min_memory_available ];then
        echo -e "\033[33m
[warning]:当前系统可用内存为:${server_available_mem}G,建议将内存至少添加为： ${min_memory_available}G ！
\033[0m "
else
        echo -e "\033[32m
检查到当前系统内存为:${server_available_mem}G 可满足服务运行！
\033[00m "
fi

#判断服务的根分区的硬盘大小是否超过预设的硬盘资源。成功继续，否则退出。
server_disk_available=`df -B G /|awk '/\//{print$4}' | awk '{sub(/.{1}$/,"")}1'`

if [ $server_disk_available -lt $min_disk_available ];then
    echo -e "\033[31m 
[warning]:当前系统的硬盘空间为:${server_disk_available}G,建议将硬盘空间至少添加为: ${min_disk_available}G!
\033[0m "
else
    echo -e "\033[32m
检测到当前系统硬盘空间为:${server_disk_available}G 可满足服务运行!
\033[0m "
fi

 
echo -e "\033[36m 
*******************************************************
*                  可适配的操作系统(X86)              *
*                                                     *
*                     cento7.5                        *                  
*                     cento7.6                        *
*                     cento7.9                        *
*                     统信系统                        *
*                     鲲鹏系统                        *
*                     Ubuntu                          *
*                     redhat7                         *
*                     银河麒麟V10                     *
*                                                     *
*******************************************************
         \033[0m"

echo -e "\033[36m
检测到当前操作系统信息如下：
         \033[0m"
cat /etc/redhat-release

#检查服务器时间和时区
echo -e "\033[36m
**************《请检查当前时间，时区是否正确》**************
当前服务器时区、时间为:
\033[0m"
date=`date`
echo $date

# yn1=y
# read -p "确认无误请按 y ，不正确请按 n 修改时间:     " yn
# if [ "$yn"x = "$yn1"x ]
# then
#         echo -e "\033[36m
#         下面即将进入系统部署...
#         \033[0m"
#         sleep 3
# else
#         read -p "输入当前日期，格式如2021/02/06——" da
#         echo "="
#         date -s $da
#         read -p "输入当前时间，格式如18:00:00——" sa
#         echo "="
#         date -s $sa
#         timedatectl set-timezone Asia/Shanghai
#         clock -w
#         echo "==================================================="
#         echo "查看修改后的时间"
#         date
# fi
}

#------------------------------服务器检测-end--------------------------------------------------------------



#------------------------------部署文件检测-start----------------------------------------------------------
function File_detection_html()
{
echo -e "\033[36m
*正在检测运维系统部署文件是否完整....
\033[0m"

ds1=$auto_html"/emqx"
ds2=$auto_html"/html"
ds3=$auto_html"/monitor"
ds4=$auto_html"/redis"
ds5=$auto_html"/server_bag"
ds6=$auto_html"/redis/data"
ds7=$auto_html"/html/cmdb"
ds8=$auto_html"/html/UbainsDevOps"
ds9=$auto_html"/html/nginx-conf"
ds10=$auto_html"/html/media"
ds11=$auto_html"/html/certs"
ds11=$auto_html"/html/web-vue-rms"

fs1=$auto_html"/emqx/config/acl.conf"
fs2=$auto_html"/emqx/config/emqx.conf"
fs3=$auto_html"/emqx/config/auth-built-in-db-bootstrap.csv"
fs4=$auto_html"/redis/redis-6.0.3.conf"
fs5=$auto_html"/html/killdjango.sh"
fs6=$auto_html"/html/killuwsgi.sh"
fs7=$auto_html"/html/uuwsgi.ini"
fs8=$auto_html"/html/startserver.sh"
fs9=$auto_html"/html/manage.py"
fs10=$auto_html"/html/setting.conf"
fs11=$auto_html"/html/setup.py"
fs12=$auto_html"/html/start.sh"
fs13=$auto_html"/html/authFile.uas"
fs14=$auto_html"/html/ngrok.sh"
fs15=$auto_html"/html/server.crt"
fs16=$auto_html"/html/startdjango.sh"
fs17=$auto_html"/html/mule_mqtt.py"
fs18=$auto_html"/html/mule_mqtt3.py"
fs19=$auto_html"/html/mule_schd.py"
fs20=$auto_html"/auth.sh"
fs21=$auto_html"/mysql.sh"
fs22=$auto_html"/new_auto.sh"
fs23=$auto_html"/ScheduledMysql.sh"
fs24=$auto_html"/UbainsmysqlBakUp.sh"
fs25=$auto_html"/devops.sql"
fs26=$auto_html"/server_bag/docker.service"
fs27=$auto_html"/server_bag/docker-20.10.7.tgz"
fs28=$auto_html"/server_bag/mysql8.0.28.tar"
fs29=$auto_html"/server_bag/redis6.2.6.tar"
fs30=$auto_html"/server_bag/upython_x86_v15.tar.gz"

ds=($ds1 $ds2 $ds3 $ds4 $ds5 $ds6 $ds7 $ds8 $ds9 $ds10 $ds11)
fs=($fs1 $fs2 $fs3 $fs4 $fs5 $fs6 $fs7 $fs8 $fs9 $fs10 $fs11 $fs12 $fs13 $fs14 $fs15 $fs16 $fs17 $fs18 $fs19 $fs20 $fs21 $fs22 $fs23 $fs24 $fs25 $fs26 $fs27 $fs28 $fs29 $fs30)

for j in 0 1 2 3 4 5 6 7 8 9 10;
 do     
        if [ -d "${ds[j]}" ] ; then
        echo -e "\033[32m ${ds[j]} 文件校验成功！\033[0m"
        else
        echo -e "\033[31m ${ds[j]} 文件不存在,请重新上传文件再执行脚本 \033[0m "
        exit
        fi
done

for j in 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24;
 do     
        if [ -f "${fs[j]}" ] ; then
        echo -e "\033[32m ${fs[j]} 文件校验成功！\033[0m"
        else
        echo -e "\033[31m ${fs[j]} 文件不存在,请重新上传文件再执行脚本 \033[0m"
        exit
        fi
done
echo -e "\033[36m
*部署文件检查完毕！正在进入下一步....
\033[0m"
sleep 3
}
#------------------------------部署文件检测-end----------------------------------------------------------------------


#------------------------------开放防火墙端口-start-------------------------------------------------------------------

#--------开放运维端口---------------------
function firewalldhtml()
{
#ssh：22
#运维mqtt（对外）1883
#运维mqtts（对外）8883
#ngrok服务（对外） 4443
#运维网页https（对外）8443
#运维websocket（内部）8083
#运维后台接口（内部）8000
#数据库端口（内部）8306
#图片服务器（内部）8002
#emqx后台管理页面（内部） 18083
#tcp调用9009
echo -e "\033[36m
*正在检查firewalld状态.....
\033[0m"
firewall-cmd --state
if [ $? -eq  0 ]; then
        echo -e "\033[32m
*检查到firewalld已开启!正在开放服务所需端口...
		\033[0m"
	for j in 22 1883 8883 8443 4443
 	do
             #firewall-cmd --list-port |grep $j
             a=`firewall-cmd --list-port |grep $j|wc -l`
             if [ "$a" -gt "0" ]; then
			   echo -e $j'\033[36m 端口已开放 \033[0m';
             else
			   echo -e "\033[36m 开放端口 \033[0m"$j
               $sudoset firewall-cmd --zone=public --add-port=$j/tcp --permanent;
             fi
        done
	$sudoset firewall-cmd --reload

else
        echo -e $j"\033[36m firewalld已关闭无需开放端口，即将进入服务安装.... \033[0m"
fi
}
#------------------------------开放防火墙端口-end----------------------------------------------------------------


#------------------------------服务安装-start-------------------------------------------------------------------

#docker安装
function docker_x86()
{
	echo -e "\033[36m
*正在检查Docker服务是否安装......
	\033[0m"
	docker -v
    if [ $? -eq  0 ]; then
        sleep 2
        echo -e "\033[32m
*检查到docker服务已安装!即将进入容器部署....
		\033[0m"
    else
        echo -e "\033[33m
*检查到docker服务未安装，正在安装...
		\033[0m"
	$sudoset mkdir -p $PWD/soft
        $sudoset cp -rf $auto_html/server_bag/docker-20.10.7.tgz $PWD/soft
        sleep 3
        $sudoset tar -xvf $PWD/soft/docker-20.10.7.tgz -C $PWD/soft
        $sudoset cp $PWD/soft/docker/*  /usr/bin/
        $sudoset rm -rf /etc/systemd/system/docker.service
        sleep 3
        $sudoset cp -rf $auto_html/server_bag/docker.service /etc/systemd/system/docker.service
        sleep 1
        $sudoset chmod +x /etc/systemd/system/docker.service
        sleep 3
        $sudoset systemctl daemon-reload 
        sleep 3
        $sudoset systemctl start docker  
        sleep 3
        $sudoset systemctl enable docker.service  
       
        echo -e "\033[32m
*docker已安装完成，当前版本号为：
	   \033[0m"
$sudoset docker -v
    fi
}


function install_JDK()
{
echo -e "\033[33m 检查JDK...... \033[0m"
java -version
if [ $? -eq  0 ];then
    echo -e "\033[32m 检查到JDK已安装 \033[0m"
else
    echo -e "\033[31m JDK 未安装 \033[0m"
    echo -e "\033[33m JDK 安装中。。。\033[0m"
    mkdir /opt/deploy
    cp /home/offline_auto_html/server_bag/jdk-8u361-linux-x64.tar.gz /opt/deploy/
    cd /opt/deploy/
    mkdir java
    tar -xvf jdk-8u361-linux-x64.tar.gz -C /opt/deploy/java
    cd java
    sed -i '$a#set java environment' /etc/profile
    sed -i '$aJAVA_HOME=/opt/deploy/java/jdk1.8.0_361' /etc/profile
    sed -i '$aCLASSPATH=.:$JAVA_HOME/lib.tools.jar' /etc/profile
    sed -i '$aPATH=$JAVA_HOME/bin:$PATH'   /etc/profile
    sed -i '$aexport JAVA_HOME CLASSPATH PATH'  /etc/profile

    source /etc/profile
    java -version
    cd /home/offline_auto_html/
    sleep 1
fi
}
# install_JDK


#数据库配置

#x86架构mysql安装
function mysql_x86()
{
echo -e "\033[36m
*正在检查mysql服务是否安装......
	\033[0m"
$sudoset docker images |grep mysql
$sudoset docker ps |grep umysql
if [ $? -eq  0 ]; then
    echo -e "\033[32m
*检查到mysql服务已安装！即将安装下一个服务....
	\033[0m"
else
    echo -e "\033[33m
*检查到mysql服务未安装，正在安装...
		\033[0m"
    # $sudoset docker load -i $auto_html/server_bag/mysql8.0.28.tar
    # $sudoset docker tag 0e6576e35715 139.9.60.86:5000/umysql:v4
    $sudoset docker load -i $auto_html/server_bag/umysql.tar
    $sudoset docker tag 89b1ec864830 139.9.60.86:5000/umysql:v4
    $sudoset cp -rf $auto_html/server_bag/docker /usr/local/
    $sudoset chmod -R 755 /usr/local/docker/mysql/
    
    sleep 3
    $sudoset docker run -p 8306:3306 --name umysql --mac-address="02:42:ac:11:00:05" -v /usr/local/docker/mysql/conf:/etc/mysql/conf -v /usr/local/docker/mysql/my.cnf:/etc/mysql/my.cnf -v /usr/local/docker/mysql/conf.d:/etc/mysql/conf.d -v /usr/local/docker/mysql/logs:/var/log/mysql -v /usr/local/docker/mysql/data:/var/lib/mysql -v /usr/local/docker/mysql/mysql-files:/var/lib/mysql-files -v /etc/localtime:/etc/localtime:ro --restart=always -e MYSQL_ROOT_PASSWORD="dNrprU&2S" -itd 139.9.60.86:5000/umysql:v4
echo -e "\033[32m
*mysql服务已安装完毕！运行信息如下：
	\033[0m"
    $sudoset docker ps
    fi
sleep 10
echo -e "\033[33m
*正在配置数据库定时备份...
		\033[0m"
sleep 60
sed -i 's/#devopsbak/devopsbak/' UbainsmysqlBakUp.sh
$sudoset cp -rf $PWD/UbainsmysqlBakUp.sh /usr/local/docker/
#定时备份数据库
sudo chmod +x /usr/local/docker/UbainsmysqlBakUp.sh
/usr/local/docker/UbainsmysqlBakUp.sh
userset="root"
sleep 5
# 每天下午一点执行脚本
if cat /var/spool/cron/$userset |grep "UbainsmysqlBakUp.sh">/dev/null
then
echo -e "\033[32m
*已配置数据库定时备份
 \033[0m"
sudo service crond restart
else
#每天13点备份
sudo cat >> /var/spool/cron/$userset<<EOF
0 13 * * * bash /usr/local/docker/UbainsmysqlBakUp.sh
00 01 * * * sh /var/www/html/log/touchuwlog.sh
00 02 * * * sh /var/www/html/log/deluwlog.sh
*/5 * * * * /var/www/html/ngrok_monitor.sh
EOF
sleep 3
sudo service crond restart
echo -e "\033[32m
*已配置数据库定时备份
 \033[0m"
fi
}

#x86架构安装emqx(运维)
function emqx_x86()
{
echo -e "\033[36m
*正在检查emqx是否安装...
	\033[0m"
$sudoset docker images |grep emqx
$sudoset docker ps |grep uemqx
if [ $? -eq  0 ]; then
    echo -e "\033[32m
*检查到eqmx已安装！正在进入下一步...
	\033[0m"
else
echo -e "\033[33m
*检查到eqmx未安装！正在安装...
	\033[0m"
$sudoset docker load -i $auto_html/server_bag/uemqx5.8.7.tar.gz
$sudoset docker run -d \
    --name uemqx \
    --privileged \
    --restart always \
    --mac-address="02:42:ac:12:00:06" \
    -p 1883:1883 \
    -p 8883:8883 \
    -p 8083:8083 \
    -v /var/www/emqx/config/emqx.conf:/opt/emqx/etc/emqx.conf:ro \
    -v /var/www/emqx/config/auth-built-in-db-bootstrap.csv:/opt/emqx/etc/auth-built-in-db-bootstrap.csv:ro \
    -v /var/www/emqx/config/acl.conf:/opt/emqx/etc/acl.conf:ro \
    -v /var/www/emqx/data:/opt/emqx/data \
    -v /var/www/emqx/log:/opt/emqx/log \
    emqx/emqx:5.8.7
sleep 1
fi
}

#x86架构redis安装
function redis_x86()
{
echo -e "\033[36m
*正在检查redis服务是否安装...
	\033[0m"
$sudoset docker images |grep redis
$sudoset docker ps |grep uredis
if [ $? -eq  0 ]; then
    echo -e "\033[32m
*检查到redis服务已安装！
	\033[0m"
else
	echo -e "\033[33m
*检查到redis服务未安装，正在安装...
	\033[0m"
    $sudoset docker load -i $auto_html/server_bag/redis6.2.6.tar
    sleep 3
    $sudoset docker tag f1b6973564e9 139.9.60.86:5000/redis:v2
    $sudoset docker run -itd --restart=always --mac-address="02:42:ac:11:00:04" -p 6379:6379 --name uredis -v /var/www/redis/redis-6.0.3.conf:/etc/redis/redis.conf -v /var/www/redis/data:/data -v /etc/localtime:/etc/localtime:ro 139.9.60.86:5000/redis:v2 redis-server /etc/redis/redis.conf --appendonly yes
fi
}

#x86架构安装ngrok
function ngrok_x86()
{
echo -e "\033[36m
*正在检查ngrok是否安装...
	\033[0m"
$sudoset docker images |grep ngrok
$sudoset docker ps |grep ungrok
if [ $? -eq  0 ]; then
    echo -e "\033[32m
*检查到ngrok已安装！正在进入下一步...
	\033[0m"
else
echo -e "\033[33m
*检查到ngrok未安装！正在安装...
	\033[0m"
$sudoset docker load -i $auto_html/server_bag/ungrok2.tar
$sudoset docker tag 6a1d154f1ca5 ngrok:v1
$sudoset docker run -itd --restart=always --network=host --name ungrok -v /etc/localtime:/etc/localtime -v /var/www/html/ngrok.sh:/home/ngrok.sh ngrok:v1
sleep 1
fi
}


#x86架构python安装
function python_x86()
{
echo -e "\033[36m
*正在检查python服务是否安装......
	\033[0m"
$sudoset docker images |grep upython
$sudoset docker ps |grep python
if [ $? -eq  0 ]; then
    echo -e "\033[32m
*检查到python已安装！正在安装下一个服务....
	\033[0m"
else
    echo -e "\033[33m
*检查到python服务未安装，正在安装服务....
	\033[0m"
    $sudoset docker load -i $auto_html/server_bag/upython_x86_v15.tar.gz
    sleep 3
    $sudoset docker run -itd  -p 8002:8002 -p 8000:8000 -p 8443:8443 -p 9009:9009 -v /var/www/html:/var/www/html -v /etc/localtime:/etc/localtime:ro --restart=always --mac-address="02:42:ac:11:00:06" --privileged --name=upython 139.9.60.86:5000/upython:v15 /var/www/html/start.sh
    $sudoset docker restart upython
    sleep 1
fi
}
#------------------------------服务安装-end-----------------------------------------------------------------


#------------------------------文件上传&更改ip-start---------------------------------------------------------

#-----------------------------------运维系统--------------------------------------------
function html_files()
{
    echo -e "\033[36m
*正在检查配置文件是否上传...
    \033[0m"
    $sudoset ls $install_dir_html | grep html
    if [ $? -eq 0 ]; then
        sleep 1
        echo -e "\033[32m
*文件已上传，无需重复上传..
    \033[0m"
    else
        sleep 1
        echo -e "\033[33m
*检查到文件未上传，正在上传文件....
    \033[0m"
        $sudoset mkdir -p $install_dir_html
        $sudoset cp -rf $auto_html/html $install_dir_html
	    $sudoset cp -rf $auto_html/emqx $install_dir_html
	    $sudoset cp -rf $auto_html/redis $install_dir_html
        # 检查 /var/www/java 目录是否存在
        if [ ! -d "/var/www/java" ]; then
            $sudoset cp -rf $auto_html/java $install_dir_html
        else
            echo -e "\033[32m
*检测到 /var/www/java 目录已存在，跳过 Java 文件上传...
    \033[0m"
        fi
    fi

    echo -e "\033[36m
*文件上传完毕！正在校验需要修改配置的文件....
    \033[0m"
    
    file1=$install_dir_html'/html/web-vue-rms/static/config.js'
    file2=$install_dir_html'/html/nginx-conf/rms8443.conf'
    file3=$install_dir_html'/html/setting.conf'
    file4=$install_dir_html'/html/web-vue-h5/static/h5/config.js'
    file5=$install_dir_html'/java/external-meeting-api/config/application-prod.properties'
    file6=$install_dir_html'/java/external-meeting-api/config/application-mqtt.yml'
    file7=$install_dir_html'/java/api-java-meeting2.0/conf/fdfs_client.conf'

    file=($file1 $file2 $file3 $file4 $file5 $file6 $file7)
    for j in "${!file[@]}"; do
        if [ -f "${file[j]}" ]; then
            echo -e "\033[32m ${file[j]} 文件校验成功！\033[0m"
            sleep 1
        else
            echo -e "\033[31m ${file[j]} 文件不存在！\033[0m"
        fi
    done

    echo -e "\033[36m 服务器的ip为：\033[0m"$IP
    echo -e "\033[36m 正在修改配置文件IP...\033[0m"
    sleep 1
    for i in ${file[*]}; do
        if [ -f "$i" ]; then
            $sudoset sed -i "s/$ip/$IP/g"  $i
            echo $IP
            echo -e "\033[32m 配置文件已修改： $i \033[0m"
            sleep 1
        fi
    done

    sleep 3
    echo -e "\033[36m
*文件配置修改完毕，正在授予文件可执行权限...
    \033[0m"
    $sudoset chmod 755 $install_dir_html/html/startserver.sh
    $sudoset chmod 755 $install_dir_html/html/start.sh
    $sudoset chmod 755 $install_dir_html/html/ngrok.sh
    $sudoset chmod 755 $install_dir_html/html/mule_mqtt.py
    $sudoset chmod 755 $install_dir_html/html/mule_schd.py
    $sudoset chmod 755 $install_dir_html/html/mule_mqtt3.py
    $sudoset chmod 755 -R $install_dir_html/html/cmdb/
    $sudoset chmod 755 -R $install_dir_html/html/manage.py
    $sudoset chmod 755 -R $install_dir_html/html/UbainsDevOps/
    $sudoset chmod 755 -R $install_dir_html/java/external-meeting-api/
    $sudoset chmod 755 $install_dir_html/redis/redis-6.0.3.conf
    $sudoset chmod 755 -R $install_dir_html/emqx/config/*
    $sudoset chown -R 1000:1000 $install_dir_html/emqx/data
    $sudoset chown -R 1000:1000 $install_dir_html/emqx/log
    echo -e "\033[36m
*已授予文件可执行权限！准备进入服务安装...
    \033[0m"
    sleep 3
}

#------------------------------文件上传&更改ip-end-----------------------------------------------------------

#------------------------------全局配置-start----------------------------------------------------------------
###服务器检测配置项
#mem-check
#最小内存大小G
min_memory_value=8
#最小有效内存大小G
min_memory_available=8
#disk-check
#最小硬盘资源大小G
#min_disk_value=200
#最小有效硬盘大小G
min_disk_available=50

#默认为空，如果为非root用户执行，则需要配置为sudo
sudoset=""
#------------------------------全局配置-end------------------------------------------------------------------
#-------------------------------脚本执行-start---------------------------------------------------------------
sys1="ubains.txt"
sys2="devops.txt"
sys3="ubains_devops.txt"
checkOS
if [ -e "$PWD/$sys1" ]; then
  txt="检测该脚本为【预定系统 部署】"
  version="预定系统版本"
elif [ -e "$PWD/$sys2" ]; then
  txt="检测该脚本为【运维系统 部署】"
  version="运维系统版本"
elif [ -e "$PWD/$sys3" ]; then
  txt="检测该脚本为【预定系统+运维系统 部署】"
  version="预定系统+运维系统版本"
fi

#-------------------------------获取服务器ip-start-------------------------------------------------------------
#文件默认ip
ip='192.168.1.141'
IP=$(hostname -I | awk '{print $1}')
function server_ip()
{
	# 弹出弹框，并根据用户选择执行相应操作
	choice=$(whiptail --title "请选择操作" \
					  --menu "请确认服务器ip是否正确:$IP" 15 50 4 \
					  1 "是" \
					  2 "否" \
					  3 "退出" \
					  3>&1 1>&2 2>&3)

	# 根据用户选择执行相应操作
	case $choice in
		1)
			# 在这里编写操作1的代码逻辑
			;;
		2)
			# 设置对话框的标题和提示信息
			dialog_title="请输入服务器IP："
			dialog_prompt="请输入服务器IP："
			# 使用whiptail显示输入框，并将用户输入的值保存到变量input_value
			IP=$(whiptail --title "$dialog_title" --inputbox "$dialog_prompt" 10 50 3>&1 1>&2 2>&3)
			# 在这里编写操作2的代码逻辑
			;;
		3)
			exit
			# 在这里编写操作3的代码逻辑
			;;
		*)
			echo "无效的选择"
			;;
	esac
}
#-------------------------------获取服务器的ip-end-------------------------------------------------------------


#-------------------------------部署运维系统-------------------------------
    echo -e "\033[36m

---------------------------------------------开始部署运维系统---------------------------------------------------


    \033[0m"
        # server_ip
        #自动化脚本路径
        auto_html=$PWD
        #unzip $PWD/html.zip -d $PWD/
        #unzip $PWD/server_bag.zip -d $PWD/
        #检测文件
        File_detection_html
        rm -rf $PWD/html.zip
        rm -rf $PWD/server_bag.zip
        #开放防火墙
        firewalldhtml
        #传输文件更改ip
        install_dir_html="/var/www"  
        html_files
        #安装服务
        docker_x86
        install_JDK
        mysql_x86
        ngrok_x86
        emqx_x86
        python_x86
        redis_x86
#___________________________________________________________________________________


echo -e "\033[36m
*************************************************************
*查看服务是否启动成功——————docker ps
运维系统服务：umysql,upython,ungrok,uemqx,uredis
*************************************************************
\033[0m"

$sudoset docker ps
$sudoset echo 'su - root -c "cd /var/www/java/external-meeting-api && ./run.sh"' | sudo tee -a /etc/rc.local > /dev/null
$sudoset /var/www/java/external-meeting-api/run.sh
$sudoset mv /home/offline_auto_html/malan /home/ 
$sudoset chmod 755 /home/malan && cd /home/
$sudoset nohup ./malan &

sleep 3
$sudoset docker restart upython
sleep 3
#------------------------------脚本执行-end---------------------------------------------------
