# 权限管理页面新增开发

## 📋 概述

1. 权限管理页面地址: `src\views\Backend\Admin\PermissionManage\index.vue`
2. 相关API文档地址：`Docs\Api\API_权限组管理接口文档.md`
3. 新增/修改权限组弹窗地址:`src\views\Backend\Admin\PermissionManage\components\AddEditDialog\index.vue`
4. 权限绑定弹窗地址:`src\views\Backend\Admin\PermissionManage\components\BindDialog\index.vue`
5. 自定义权限控制指令v-permission地址：`src\utils\permission.js`

## 🎯 任务

1. ✅ 在权限管理页面遵循`Docs\PRD\_PRD_规范文档_新建页面.md`并标准化初始化页面，在`src\router.js`注册路由
2. ✅ 参考页面`src\views\Backend\Admin\Role\index.vue`的设计在初始化后的权限管理页新增功能
3. ✅ 将权限管理页面的新增/修改权限组弹窗和绑定弹窗分别抽离成组件放置在`src\views\Backend\Admin\PermissionManage\components`中，注意数据的传输，并优化一下样式
4. ✅ 实现权限组添加权限
5. ✅ 在新增/修改权限组弹窗继续实现任务4的要求
6. ✅ 帮我参考API接口文档，实现权限组的增删改查、禁用/启用功能，绑定功能先不实现
7. ✅ 进入权限管理页面时，帮我请求API接口文档的接口`/permissionGroup/getAllPermissions`获取所有配置项，然后将`src\views\Backend\Admin\PermissionManage\components\PermissionConfig\index.vue`的permissionList替换为接口请求到的真实数据
8. ✅ 重构权限绑定弹窗及补充功能实现
9. 数据结构调整

### 权限页面基础功能

1. 实现功能时提供了API接口，但先不进行对接，先在前端用虚拟数据实现并预留操作方法等，等我要接口对接时再进行接口对接
2. 支持模糊搜索，支持基础的增删改查
3. el-table的主要显示字段获取参考相关API文档的"分页查询权限组"接口，显示字段groupName、isEnable、createTime，支持多选，支持分页，操作有修改、删除、绑定

### 权限组添加权限要求

1. 实现功能时提供了API接口，但先不进行对接，先在前端用虚拟数据实现并预留操作方法等，等我要接口对接时再进行接口对接
2. 我在`src\constant\permissionList.js`模拟了权限数据，帮我使用el-checkbox进行显示
3. 文本显示逻辑：在国际化文件中新建permission子集，通过key值匹配显示文本：例如view=i18n文件中的`permission.view`
4. 页面显示：要同时显示名称和勾选框，比如
```json
    functionType_82: {
        view: 0,
        create: 0,
        update: 0,
        delete: 0,
    },
```
要显示为"办公室管理:查看 新增 编辑 删除"

### 重构权限绑定弹窗及补充功能实现要求

1. 弹窗页面重构，当前的设计不符合产品的功能要求，具体功能要求：权限组支持同时绑定多个用户、角色、部门，取消权限配置功能
2. 页面样式自由发挥，符合系统主题即可，优先使用UI/UX Pro Max
3. 参考`@src/views/Backend/Account/User/index.vue:930-984 `实现用户数据请求获取
4. 参考`@src/views/Backend/Account/User/index.vue:986-1010 `实现角色数据的请求获取
5. 参考`@src/views/Backend/Account/User/index.vue:263-273 `和`@src/views/Backend/Account/User/index.vue:1055-1068 `实现部门数据的请求获取
6. 根据权限api文档的`/permissionGroup/bindRelation`实现权限绑定

### 数据结构调整页面相关实现

1. 当前接口的数据结构

## 国际化
遵循`Docs\PRD\_PRD_规范文档_国际化.md`规范

## 接口请求
当涉及到接口请求时，需要严格遵循`Docs\PRD\_PRD_规范文档_接口请求.md`规范