# 常见问题处理说明文档

## 📋 概述

该脚本主要用于在Linux服务器上执行，解决常见的服务运行异常、权限不足、磁盘空间不足、版本更新、数据备份等问题。需要提供交互界面，允许用户选择不同的处理选项，如果涉及到输入参数，需要提示用户输入并验证输入的有效性。

### 背景

目前针对Linux服务器上和业务服务的常见问题处理，需要区分两种平台环境，二者只存其一：

- **新统一平台**：主要使用 `/data/` 目录
- **标准版平台**：主要使用 `/var/www/` 目录

## 🎯 功能清单及实现状态

| 功能分类 | 子功能 | 状态 | 说明 |
|---------|--------|------|------|
| 更新版本包 | 对内后端包 | ✅ 已实现 | 更新Java Jar包 |
| | 对外后端包 | ✅ 已实现 | 更新Java Jar包 |
| | 预定系统前台包 | ✅ 已实现 | 更新前端静态资源 |
| | 预定系统后台包 | ✅ 已实现 | 更新前端静态资源 |
| | 运维后端包 | ✅ 已实现 | 更新Python服务 |
| | 运维前端包 | ✅ 已实现 | 更新前端静态资源 |
| 修复文件权限 | 普通文件权限 | ✅ 已实现 | 修复启动脚本等权限 |
| | 数据库用户权限 | ✅ 已实现 | 创建用户并授予权限 |
| | Nginx用户权限 | ✅ 已实现 | 修改Nginx配置文件 |
| | Redis配置权限 | ✅ 已实现 | 修复Redis配置文件权限 |
| | rc.local权限 | ✅ 已实现 | 修复启动脚本权限 |
| 修复配置文件IP | IP地址修正 | ✅ 已实现 | 批量替换配置文件中的IP |
| 修复系统磁盘问题 | 清理已删文件 | ✅ 已实现 | 清理已删除但未释放的文件 |
| | 轮转日志文件 | ✅ 已实现 | 处理过大的日志文件 |
| | system_log表处理 | ✅ 已实现 | 数据库表清理功能 |
| 导出现场日志 | 日志导出压缩 | ✅ 已实现 | 导出并压缩日志文件 |
| 修复服务异常 | 对外服务掉线 | ✅ 已实现 | 修复对外后端服务异常 |
| | NTP服务配置 | ✅ 已实现 | 修复NTP服务配置 |
| 网络配置 | 端口开放 | ✅ 已实现 | 检查并开放必要端口 |
| | DNS异常修复 | ✅ 已实现 | 修复DNS配置问题 |
| 数据备份 | 环境数据备份 | ✅ 已实现 | 打包备份现场环境数据 |

## 🔧 详细功能说明

### 1. 更新版本包

更新预定系统的版本包，包括对内后端、对外后端、前台、后台、运维后端、运维前端等。

#### 示例流程：

示例1：更新预定系统对内后端包
1. 检查当前脚本所在目录是否存在新版本包的上一级目录名称api-java-meeting2.0
2. 如果存在，脚本会自动验证该目录下的文件ubains-meeting-inner-api-1.0-SNAPSHOT.jar是否存在，最后确认更新操作
3. 如果不存在，提示用户输入新版本包所在的目录名称如（/root/api-java-meeting2.0/）
4. 创建备份目录：mkdir -p /var/www/java/api-java-meeting2.0/包名_backup_时间戳
5. 确认更新操作后，脚本会自动备份当前版本包
6. 脚本会自动将新的版本包复制到指定路径

示例2：更新预定系统后台包
1. 检查当前脚本所在目录是否存在新版本包的上一级目录名称ubains-web-admin
2. 如果存在，脚本会自动验证该目录下的文件index.html static是否存在，最后确认更新操作
3. 如果不存在，提示用户输入新版本包所在的目录名称如（/root/ubains-web-admin）
4. 创建备份目录：mkdir -p /var/www/java/ubains-web-admin/目录名_backup_时间戳
5. 确认更新操作后，脚本会自动备份当前版本包
6. 脚本会自动将新的版本包复制到指定路径

#### 1.1 更新预定系统对内后端包

- 新统一平台程序路径&包名：`/data/services/api/java-meeting/java-meeting2.0/ubains-meeting-inner-api-1.0-SNAPSHOT.jar`
- 标准版平台程序路径&包名：`/var/www/java/api-java-meeting2.0/ubains-meeting-inner-api-1.0-SNAPSHOT.jar`

#### 1.2 更新预定系统对外后端包

- 新统一平台程序路径&包名：`/data/services/api/java-meeting/java-meeting-extapi/ubains-meeting-api-1.0-SNAPSHOT.jar`
- 标准版平台程序路径&包名：`/var/www/java/external-meeting-api/ubains-meeting-api-1.0-SNAPSHOT.jar`

#### 1.3 更新预定系统前台包

- 新统一平台程序路径&包名：`/data/services/web/pc/pc-vue2-meetngV2` ：`index.html` `static` `216bdc4c3fe8c2c18aff.worker.js` `WW_verify_BTch57iYZdNNTbVg.txt`
- 标准版平台程序路径&包名：`/var/www/java/ubains-web-2.0` ：`index.html` `static` `216bdc4c3fe8c2c18aff.worker.js`

#### 1.4 更新预定系统后台包

- 新统一平台程序路径&包名：`/data/services/web/pc/pc-vue2-backstage` ：`index.html` `static`
- 标准版平台程序路径&包名：`/var/www/java/ubains-web-admin` ： `index.html` `static`

#### 1.5 更新运维后端包

- 新统一平台程序路径&包名：`/data/services/api/python-cmdb` ： `cmdb` `UbainsDevOps`
- 标准版平台程序路径&包名：`/var/www/html` ：`cmdb` `UbainsDevOps`

#### 1.6 更新运维前端包

- 新统一平台程序路径&包名：`/data/services/web/pc/pc-vue2-moniter` ：`index.html` `static` `module`
- 标准版平台程序路径&包名：`/var/www/html/web-vue-rms` ： `index.html` `static` `module`

### 2. 修复文件权限问题

#### 2.1 数据库用户权限不足

常见用户权限不足的主要是：mysqluser、root@172.17.0.1对于数据库ubains、devops数据库的权限不足。
数据库的容器为umysql，数据库密码需要提供给用户进行输入。

执行过程:
1. 检查系统中是否存在docker环境
2. 检查umysql容器是否存在且正在运行
3. 提示用户输入数据库root密码
4. 在umysql容器中执行以下SQL操作:
   1) 创建mysqluser用户（如果不存在）:
      - create user mysqluser identified by '用户输入的密码';
   2) 授权mysqluser用户访问数据库的权限:
      - GRANT ALL ON ubains.* TO 'mysqluser'@'%';
      - GRANT ALL ON devops.* TO 'mysqluser'@'%';
      - GRANT ALL ON ubains.* TO 'root'@'172.17.0.1';
      - GRANT ALL ON devops.* TO 'root'@'172.17.0.1';
      - alter user 'mysqluser'@'%' identified with mysql_native_password by '用户输入的密码';
      - flush privileges;
      - update mysql.user set Grant_priv='Y',Super_priv='Y' where user = 'mysqluser' and host = '%';
      - flush privileges;

执行后会:
1. 自动检查docker环境和umysql容器状态
2. 提示用户输入数据库密码
3. 在umysql容器中执行数据库用户创建和权限分配流程
4. 显示操作后的用户权限信息

#### 2.2 nginx用户权限不足

常见问题是nginx配置文件中的user值不是root，这会导致权限不足问题。

##### ujava2容器
- 文件路径：`/usr/local/nginx/conf/nginx.conf`
- 问题：user值不是root
- 解决方案：
    1. 进入容器：`docker exec -it ujava2 bash`
    2. 修改文件：`/usr/local/nginx/conf/nginx.conf`，将user的值修改为root
    3. 重启nginx：`/usr/local/nginx/sbin/nginx -s reload`

##### upython容器
- 文件路径：`/usr/local/nginx/conf/nginx.conf`
- 问题：user值不是root
- 解决方案：
    1. 进入容器：`docker exec -it upython bash`
    2. 修改文件：`/usr/local/nginx/conf/nginx.conf`，将user的值修改为root
    3. 重启nginx：`/usr/local/nginx/sbin/nginx -s reload`

执行后会：
1. 自动检查docker环境和相关容器状态
2. 分别处理ujava2和upython容器中的nginx配置
3. 将配置文件中的user值修改为root
4. 重启nginx服务使配置生效

#### 2.3 启动文件权限不足

##### 新统一平台
以下文件需要755权限：
**预定服务**：
- `/data/services/api/start.sh`
- `/data/services/api/java-meeting/java-meeting2.0/run.sh`
- `/data/services/api/java-meeting/java-meeting-extapi/run.sh`

**运维服务**：
- `/data/services/api/python-cmdb/start.sh`
- `/data/services/api/python-cmdb/mule_mqtt.py`
- `/data/services/api/python-cmdb/mule_schd.py`
- `/data/services/api/python-cmdb/mule_mqtt3.py`

##### 标准版平台

**预定服务**：
- `/var/www/java/start.sh`
- `/var/www/java/api-java-meeting2.0/run.sh`
- `/var/www/java/external-meeting-api/run.sh`
- `/var/www/java/external-meeting-api/check.sh`
- `/var/www/java/external-meeting-api/startExternalProject.sh`
- `/var/www/malan/malan`
- `/var/www/malan/run.sh`

**运维服务**：
- `/var/www/html/start.sh`
- `/var/www/html/ngrok.sh`
- `/var/www/html/mule_mqtt.py`
- `/var/www/html/mule_schd.py`
- `/var/www/html/mule_mqtt3.py`

#### 2.4 redis配置文件权限不足

##### 新统一平台

- `/data/middleware/redis/config/redis.conf`权限不是644

##### 标准版平台

- `/var/www/redis/redis.conf`权限不是644

#### 2.5 rc.local权限不足

- `/etc/rc.local`

### 3. 修复配置文件IP不对问题

#### 3.1 检查各配置文件中的IP地址是否正确

##### 新统一平台

**预定服务**：
1. `/data/services/api/java-meeting/java-meeting2.0/conf/fdfs_client.conf`
2. `/data/services/api/java-meeting/java-meeting2.0/config/application.properties`
3. `/data/services/api/java-meeting/java-meeting2.0/config/application-mqtt.yml`
4. `/data/services/api/java-meeting/java-meeting2.0/config/application-thirdParty.properties`
5. `/data/services/api/java-meeting/java-meeting2.0/config/config.js`
6. `/data/services/api/java-meeting/java-meeting-extapi/config/application-prod.properties`
7. `/data/services/api/java-meeting/java-meeting-extapi/config/application-mqtt.yml`
8. `/data/services/api/java-meeting/java-meeting-extapi/config/application-dubbo.yml`

**运维服务**：
1. `/data/services/api/python-cmdb/setting.conf`
2. `/data/services/api/python-cmdb/nginx-conf/moblie8081.conf`
3. `/data/services/api/python-cmdb/nginx-conf/rms8443.conf`
4. `/data/services/api/python-cmdb/web-vue-rms/static/config.json`

##### 标准版平台

**预定服务**：
1. `/var/www/java/api-java-meeting2.0/conf/fdfs_client.conf`
2. `/var/www/java/api-java-meeting2.0/config/application.properties`
3. `/var/www/java/api-java-meeting2.0/config/application-mqtt.yml`
4. `/var/www/java/api-java-meeting2.0/config/application-thirdParty.properties`
5. `/var/www/java/api-java-meeting2.0/config/config.js`
6. `/var/www/java/external-meeting-api/conf/fdfs_client.conf`
7. `/var/www/java/external-meeting-api/config/application-prod.properties`
8. `/var/www/java/external-meeting-api/config/application-intAddress.properties`
9. `/var/www/java/external-meeting-api/config/application-mqtt.yml`
10. `/var/www/java/external-meeting-api/config/application-thirdParty.properties`
11. `/var/www/java/external-meeting-api/config/config.js`
12. `/var/www/java/external-meeting-api/config/h5-8086.conf`
13. `/var/www/java/external-meeting-api/config/video8083.conf`
14. `/var/www/java/external-meeting-api/config/meeting443.conf`

**运维服务**：
1. `/var/www/html/setting.conf`
2. `/var/www/html/web-vue-rms/static/config.json`
3. `/var/www/html/nginx-conf/moblie8081.conf`
4. `/var/www/html/nginx-conf/rms8443.conf`

### 4. 修复系统磁盘问题

#### 4.1 分区不合理导致磁盘爆满

如当/home的磁盘大于根目录的磁盘；--不使用脚本实现，风险较高。

#### 4.2 已删除文件没有释放导致系统爆满

系统中可能存在已删除但仍在被进程占用的文件，这些文件虽然已被删除但仍占用磁盘空间。

##### 解决方法：

1. 通过脚本交互界面选择清理已删除但未释放的文件功能
2. 脚本会列出所有已删除但仍在被进程占用的文件及其进程信息
3. 用户确认后，脚本会强制结束占用这些文件的进程，释放磁盘空间

##### 定时任务版本：

需要自动创建一个定时任务crond，每天凌晨3点执行一次，把已删除但没释放的进程强制结束。

可以通过以下方式实现：
1. 在系统中添加crontab任务，每天凌晨3点执行
2. 脚本会检查是否存在已删除但仍然被进程占用的文件
3. 对于这些文件，找出占用它们的进程并强制结束

具体的crontab条目如下：
```bash
# 每天凌晨3点执行清理已删除但未释放的文件
0 3 * * * /bin/bash {脚本所在目录}/issue_handler.sh --action clean_deleted_files_cron
```

##### 执行后会:

1. 自动检测系统中已删除但仍在被进程占用的文件
2. 显示这些文件及其占用进程的详细信息
3. 用户确认后强制结束占用这些文件的进程，释放磁盘空间
4. 显示操作结果统计（成功/失败的进程数）

#### 4.3 日志文件过大导致系统爆满

系统中的日志文件可能会不断增长，占用大量磁盘空间。

##### 涉及的日志文件：

###### 新统一平台

- `/data/services/api/java-meeting/java-meeting2.0/log.out`
- `/data/services/api/java-meeting/java-meeting-extapi/log.out`
- `/data/services/api/python-cmdb/uinfo.log`
- `/data/services/api/python-cmdb/uwsgi.log`

###### 标准版平台

- `/var/www/java/api-java-meeting2.0/log.out`
- `/var/www/java/external-meeting-api/log.out`

##### 解决方法：

1. 通过脚本交互界面选择轮转日志文件功能
2. 脚本会检查上述日志文件的大小
3. 对于超过100MB的日志文件，会提示用户确认是否进行轮转
4. 用户确认后，脚本会执行以下操作：
   - 备份当前日志文件
   - 创建新的空日志文件
   - 尝试通知相关服务重新打开日志文件
   - 压缩旧的日志文件以节省空间

##### 执行后会:

1. 检查所有相关日志文件的大小
2. 对超过100MB的日志文件进行轮转操作
3. 压缩旧日志文件以节省磁盘空间
4. 尝试通知相关服务使用新的日志文件
5. 显示操作结果统计（轮转/跳过/错误的文件数）

#### 4.4 数据库system_log表爆满

容器umysql的数据库ubains中有一个表system_log，容易产生爆满问题。

##### 解决方法：

1. 磁盘不够时，通过脚本交互界面选择清理system_log表中30天前的数据。
2. 脚本会验证数据库连接和表存在性后，提示用户确认删除操作。
3. 清理完成后，会执行表空间优化操作，回收释放的空间。

##### 执行过程:

1. 自动检查docker环境和umysql容器状态
2. 提示用户输入数据库root密码
3. 验证数据库连接和system_log表存在性
4. 显示当前system_log表记录数
5. 如果记录数超过100万条，提示用户确认删除30天前的数据
6. 执行数据删除操作
7. 执行表空间优化操作
8. 显示删除后的记录数

##### 注意事项:

- 此操作只会删除30天前的历史数据，保留近期数据用于问题排查
- 操作前请确保已备份重要数据
- 删除操作不可逆，请谨慎操作

#### 4.4 磁盘分区调整参考（手动处理）

由于磁盘分区调整属于高风险操作，可能导致数据丢失或系统无法启动，因此脚本不提供自动处理功能。但为了帮助用户手动处理此类问题，脚本提供了详细的操作指南和注意事项。

##### 操作步骤

当安装完 Linux 操作系统，发现磁盘分区大小错误，或者后期使用过程发现 /home 还剩余很多空间，/ 下空间不足，需要将 /home 下空间重新分配给 / 目录下，方法如下：

1. 查看分区空间和格式
   ```bash
   df -hT
   cat /etc/os-release
   ```

2. 备份数据
   ```bash
   cp -rp /home /run/
   # 或者备份到其他安全位置
   ```

3. 卸载 /home 分区
   ```bash
   # 卸载分区时，务必将该分区内容备份到其他分区，否则会丢失该分区的内容！！
   umount /home
   ```

4. 减小/home分区大小（以减少1.6T为例）
   ```bash
   lvreduce -L -1.6T /dev/mapper/uos-home
   mkfs.xfs /dev/mapper/uos-home -f
   ```

5. 重新挂载 /home 分区：
   ```bash
   mount /dev/mapper/uos-home /home/
   ```

6. 查看剩余空间：
   ```bash
   vgdisplay
   ```

7. 给/root目录扩容（以增加40G为例）
   ```bash
   lvextend -L +40G /dev/mapper/uos-root
   xfs_growfs /dev/mapper/uos-root
   ```

8. 验证是否成功
   ```bash
   df -h
   ```

##### 常见问题及解决方案

###### （一）卸载 /home 分区提示：
```bash
umount: /home: device is busy.
(In some cases useful info about processes that use
the device is found by lsof(8) or fuser(1))
```

提示无法卸载，则是有进程占用 /home，解决：
1. 有可能你在 /home 目录下，跳出 /home 再执行卸载。
2. 有进程使用 /home ，使用如下命令终止进程，再卸载。
   ```bash
   fuser -m -k /home
   ```

###### （二）挂载 /home 分区提示：
```bash
[root@rbtnode1 ~]# xfs_growfs /dev/mapper/centos-home
xfs_growfs: /dev/mapper/centos-home is not a mounted XFS filesystem
```

解决：需要格式化 /home ，再挂载。

###### （三）执行resize2fs报错
```bash
resize2fs: Bad magic number in super-block 当尝试打开 /dev/mapper/centos-root 时
找不到有效的文件系统超级块.
```

解决：查看类型，xfs 系统需要 xfs_growfs 执行。

###### （四）不同文件系统的指令

1. ext2/ext3/ext4文件系统，调整命令是resize2fs（增大和减小都支持）
   ```bash
   lvextend -L 120G /dev/mapper/centos-home //增大至120G
   lvextend -L +20G /dev/mapper/centos-home //增加20G
   lvreduce -L 50G /dev/mapper/centos-home //减小至50G
   lvreduce -L -8G /dev/mapper/centos-home //减小8G
   resize2fs /dev/mapper/centos-home //执行调整
   ```

2. xfs文件系统的调整命令是xfs_growfs（只支持增大）
   ```bash
   lvextend -L 120G /dev/mapper/centos-home //增大至120G
   lvextend -L +20G /dev/mapper/centos-home //增加20G
   xfs_growfs /dev/mapper/centos-home //执行调整
   ```

### 5. 导出现场日志文件并压缩

需求说明：需要压缩日志文件目录并存放到当前脚本所在目录，需要加上标识和时间。

#### 新统一平台

**预定服务**
- `/data/services/api/java-meeting/java-meeting2.0/logs`
- `/data/services/api/java-meeting/java-meeting-extapi/logs`

**运维服务**
- `/data/services/api/python-cmdb/log`

#### 标准版平台

**预定服务**
- `/var/www/java/api-java-meeting2.0/logs`
- `/var/www/java/external-meeting-api/logs`

**运维服务**
- `/var/www/html/log`

#### 执行过程

1. 自动检测当前平台类型（新统一平台或标准版平台）
2. 检查目标磁盘空间是否充足
3. 创建包含日期时间戳的临时备份目录
4. 备份上述指定的日志目录
5. 将所有备份数据打包为zip或tar.gz格式压缩文件
6. 清理临时备份目录，保留最终的压缩包
7. 显示操作结果（成功/失败状态和压缩包位置）

#### 注意事项

- 默认使用脚本所在目录作为工作目录，避免使用/tmp可能存在的空间限制
- 支持zip和tar.gz两种压缩格式，优先使用zip
- 操作前会检查磁盘空间，如果空间不足会提示用户确认

### 6. 修复对外后端服务异常掉线

需求说明：
标准版平台-对外后端服务启动，同时判断/etc/profile里面是否存在，不存在则添加。

```bash
cd /var/www/java/external-meeting-api/
./run.sh
```

新统一平台-对外后端服务启动，同时判断/etc/profile里面是否存在，不存在则添加。

```bash
cd /data/services/api/java-meeting/java-meeting-extapi/
./run.sh
```

### 7. 修复ntp服务配置或启动问题

需求说明：
1. 检测系统中使用的NTP服务类型（chronyd、ntpd等）
2. 配置`/etc/chrony.conf`或相应配置文件，添加允许所有地址进行同步：`allow all`
3. 重启相应的NTP服务

#### 执行过程

1. 检测系统中存在的NTP服务类型
2. 检查配置文件中是否已包含`allow all`配置项
3. 如果没有，提示用户确认是否添加
4. 检查NTP服务是否正在运行
5. 提示用户确认是否重启NTP服务
6. 尝试重启NTP服务，支持多种服务管理方式：
   - 优先尝试systemctl命令
   - 失败时尝试service命令
   - 支持多种服务名称（chronyd、ntpd、ntp、chrony）
7. 如果系统未安装NTP服务，会根据包管理器类型（yum/apt-get/dnf）提示安装合适的NTP服务

#### 注意事项

- 脚本不会假定系统一定使用特定的NTP服务，会自动检测
- 提供详细的日志信息，明确告知用户当前操作状态和可能的错误原因
- 当所有自动重启方法失败时，会提供具体的手动操作指导

### 8. 修复端口开放问题

需求说明：

#### 新统一平台

1. 检查服务器是否开放了443、1883、8883、123/udp端口，没开放需要开放

#### 标准版平台

1. 检查服务器是否开放了443、1883、8443、8081、123/udp、8883、4443端口，没开放需要开放。

#### 执行过程

1. 检测系统使用的防火墙类型（firewalld或iptables）
2. 检查防火墙服务是否正在运行
3. 如果防火墙服务未运行，提示用户是否启动服务
4. 检查所需端口是否已开放
5. 对于未开放的端口，提示用户确认是否开放
6. 添加端口规则到防火墙配置中
7. 保存防火墙规则，支持多种保存方式：
   - 使用service命令保存
   - 直接调用iptables-save命令
   - 使用发行版特定工具（iptables-persistent、netfilter-persistent）
   - 启用防火墙服务开机自启
8. 如果所有自动保存方法失败，会提供具体的手动保存命令建议

#### 注意事项

- 脚本会先检测防火墙服务是否存在并检查其运行状态，不能假定服务已启用
- 若防火墙服务未运行，会提示用户是否启动服务，并告知不启动可能带来的影响
- 提供清晰的状态反馈和后续操作指导，帮助用户理解当前状况
- 启用防火墙服务开机自启，防止系统重启后规则丢失

### 9. 打包备份现场环境数据

需求说明：

#### 新统一平台

需要备份以下关键数据：
1. 预定服务配置和日志：
   - `/data/services/api/java-meeting/java-meeting2.0/config`
   - `/data/services/api/java-meeting/java-meeting2.0/logs`
   - `/data/services/api/java-meeting/java-meeting-extapi/config`
   - `/data/services/api/java-meeting/java-meeting-extapi/logs`

2. 运维服务配置和日志：
   - `/data/services/api/python-cmdb/setting.conf`
   - `/data/services/api/python-cmdb/nginx.conf`
   - `/data/services/api/python-cmdb/log`

3. 中间件配置：
   - `/data/middleware/redis/config`

4. Nginx配置：
   - `/usr/local/nginx/conf`

5. 系统通用配置：
   - `/etc/hosts`
   - `/etc/resolv.conf`
   - `/etc/fstab`

6. 系统运行时信息：
   - CPU信息 (`/proc/cpuinfo`)
   - 内存信息 (`/proc/meminfo`)
   - 系统版本信息 (`/proc/version`)

#### 标准版平台

需要备份以下关键数据：
1. 预定服务配置和日志：
   - `/var/www/java/api-java-meeting2.0/config`
   - `/var/www/java/api-java-meeting2.0/logs`
   - `/var/www/java/external-meeting-api/config`
   - `/var/www/java/external-meeting-api/logs`

2. 运维服务配置和日志：
   - `/var/www/html/config`
   - `/var/www/html/log`

3. 中间件配置：
   - `/var/www/redis`

4. Nginx配置：
   - `/usr/local/nginx/conf`

5. 系统通用配置：
   - `/etc/hosts`
   - `/etc/resolv.conf`
   - `/etc/fstab`

6. 系统运行时信息：
   - CPU信息 (`/proc/cpuinfo`)
   - 内存信息 (`/proc/meminfo`)
   - 系统版本信息 (`/proc/version`)

执行后会:
1. 自动检测当前平台类型（新统一平台或标准版平台）
2. 创建包含日期时间戳的备份目录
3. 备份上述指定的配置文件、日志文件和系统信息
4. 收集系统运行时信息（进程、服务、网络、磁盘等）
5. 将所有备份数据打包为tar.gz格式压缩文件
6. 清理临时备份目录，保留最终的压缩包

### 10. 修复服务器DNS异常问题

需求说明：
检查网卡配置文件，是否配置了默认的DNS服务器地址：114.114.114.114或8.8.8.8。
没配置需要进行配置，再访问外部服务：华为云地址、腾讯云地址、阿里云地址。

#### 执行过程

1. 检测系统使用的网络管理器类型（NetworkManager、network、systemd-networkd等）
2. 检查`/etc/resolv.conf`文件中是否已配置推荐的DNS服务器
3. 如果没有配置，会提示用户确认是否添加
4. 添加前会备份原配置文件
5. 添加所有推荐的DNS服务器（114.114.114.114 和 8.8.8.8）
6. 验证配置是否成功写入
7. 提供网络服务重启策略，支持多种Linux发行版的服务管理命令（systemctl/service）
8. 用户确认后重启网络服务使配置生效
9. 重启网络服务后进行网络连接测试，验证配置有效性

#### 注意事项

- 修改DNS配置前会创建带时间戳的备份文件，确保可回滚
- 添加DNS服务器前会检查是否已存在，避免重复配置
- 当自动处理失败时，会提供具体的手动操作指导
- 会根据检测到的网络管理器类型选择相应的服务管理方式

### 11. 修复服务器redis文件损坏问题处理
函数名称：redis_container_exception
需求说明：
   修复redis容器启动异常问题
修复步骤：
   1、检测新旧平台
   2、重启redis查看是否正常重启成功，如果容器重启失败则往下执行第3步骤。
   3、删除redis容器的data下所有数据
      旧平台：
         路径：/var/www/redis/data，将此目录下数据删除后重启uredis容器
      新统一平台：
         路径：/data/middleware/redis/data，将此目录下数据删除后重启uredis容器

交互模式与非交互模式说明：
   - 默认执行（不带额外参数）时，脚本以交互模式运行：
       1）在删除 data 目录之前，提示用户“是否确认删除 redis data 下所有数据”，必须输入 yes 才会继续执行；
       2）适合现场运维人员手动执行，避免误删数据。
   - 当通过服务自检脚本自动调用时，使用非交互模式：
       1）调用示例：./issue_handler.sh --action redis_container_exception --non-interactive --yes
       2）非交互模式下，如果未同时指定 --yes，脚本应出于安全考虑直接退出，不删除任何数据；
       3）只有在同时传入 --non-interactive 和 --yes 时，才会自动执行删除 data 并重启 uredis 的操作。