# 程序更新脚本需求文档
## 需求描述
### 一、需求描述：
   能够通过脚本实现在window上远程更新任何系统的前后端包版本，以减少错误，提升效率。
### 二、脚本说明：
   脚本路径： 
    路径1：AuxiliaryTool/ScriptTool/Program_Update/remote_update.ps1
    路径2：AuxiliaryTool/ScriptTool/Program_Update/program_update.sh
   脚本用途：
    remote_update.ps1为Windows执行脚本，用以远程更新程序
    program_update.sh为Linux执行脚本，用于在远程服务器上执行更新操作
### 三、功能需求：
#### 3.1.支持远程连接到指定服务器。（remote_program_update.ps1）✅ 已完成
    - 输入服务器IP ✅
    - ssh端口号 ✅
    - 输入用户名密码 ✅
    - 输入文件存放路径（默认为/home/Update/） ✅
    - 判断平台类型（新统一平台/传统平台） ✅
    - 输入更新系统类型（会议预定系统、运维集控系统、讯飞转录系统） ✅
    - 输入更新类型（前端更新、后端更新、全量更新） ✅

#### 3.2.能够上传更新压缩文件以及更新脚本。（remote_program_update.ps1）✅ 已完成
    - 将当前脚本同级目录下的zip压缩包和program_update.sh脚本上传到指定服务器的指定路径下。✅
    - 解压缩压缩包，通过unzip命令解压到指定目录（/home/Update/）。✅

#### 3.3.备份原有数据. (program_update.sh) ✅ 已完成
    - 在执行更新操作前，先备份原有的前端或后端文件夹到备份目录（/home/Backup/）。
        -- 创建备份目录：
            执行mkdir -p /home/Backup/Bak时间戳
        -- 备份前端文件夹：
            cp -r 根据系统类型和更新类型选择对应的前端路径及文件 备份目录路径
        -- 备份后端文件夹：
            cp -r 根据系统类型和更新类型选择对应的后端路径及文件 备份目录路径
        -- 备份数据库操作如下：
            1.查询MySQL容器名称
            2.进入MySQL容器
            3.执行mysqldump -uroot -p 根据系统类型选择对应的数据库名称 > /备份目录路径/数据库名称_时间戳.sql（数据库密码为：dNrprU&2S）
    - 打压缩当前备份包，并导出至桌面
        -- 执行tar -czvf /home/Backup/Bak时间戳.tar.gz /home/Backup/Bak时间戳
        -- 将压缩包移动到桌面：mv /home/Backup/Bak时间戳.tar.gz remote_update.ps1所在路径

#### 3.4.更新服务（program_update.sh）
    - 根据系统类型和更新类型选择对应的更新脚本执行更新操作
    - 前端更新操作：
        -- 注意：只替换主服务文件，不要影响原有目录下其他文件！！！
        -- 传统平台
            1.会议预定系统：
                - 前台前端：✅ 已完成
                    cd /home/Update/ubains-web-2.0
                    mv * /var/www/java/ubains-web-2.0/（覆盖操作）
                - 后台前端：✅ 已完成
                    cd /home/Update/ubains-web-admin
                    mv * /var/www/java/ubains-web-admin/（覆盖操作）
                - 对内后端：✅ 已完成
                    cd /home/Update/api-java-meeting2.0
                    mv * /var/www/java/api-java-meeting2.0/（覆盖操作）
                - 对外后端：✅ 已完成
                    cd /home/Update/external-meeting-api
                    mv * /var/www/java/external-meeting-api/（覆盖操作）
            2.运维集控系统：✅ 已完成
                - 前端：
                    cd /home/Update/web-vue-rms
                    mv * /var/www/html/web-vue-rms/（覆盖操作）
                - 后端：
                    cd /home/Update/
                    mv * /var/www/html/（覆盖操作）
            3.讯飞转录系统：✅ 已完成
                - 前端：
                    cd /home/Update/web-vue-rms
                    mv * /var/www/html/uvoice/web-vue-uvoice/（覆盖操作）
                - 后端：
                    cd /home/Update/UbainsDevOps
                    mv * /var/www/html/（覆盖操作）

#### 3.5.重启服务并验证更新是否成功。
    - 如果更新类型为前端更新，则无需重启服务
    - 如果更新类型为后端更新，则需重启服务
        -- 通过系统名称类型重启对应服务
            1.会议预定系统：
                - cd /var/www/java/external-meeting-api
                - ./run.sh;tail -f logs/ubains-INFO-AND-ERROR.log
                - docker exec -it ujava2 bash
                - cd /var/www/java/api-java-meeting2.0
                - ./run.sh;tail -f logs/ubains-INFO-AND-ERROR.log
            2.运维集控系统：
                - cd /var/www/html
                - docker restart upython
                - tail -f log/uinfo.log
            3.讯飞转录系统：
                - cd /var/www/html
                - docker restart upython
                - tail -f log/uinfo.log

### 四、不同平台的路径映射：
#### 4.1.传统平台路径映射：
| 系统名称 | 前端路径及文件 | 后端路径及文件 | 数据库名称 |
|:会议预定系统: | :前台前端：/var/www/java/ubains-web-2.0 *.js static/ index.html 后台前端：/var/www/java/ubains-web-admin index.html static/: | :对内后端：/var/www/java/api-java-meeting2.0 *.jar 对外后端：/var/www/java/external-meeting-api *.jar: | :数据库：ubains: |
|:运维集控系统: | :前端：/var/www/html/web-vue-rms static/ index.html: | :后端：/var/www/html cmdb/ UbainsDevOps/: | :数据库：devops: |
|:讯飞转录系统: | :前端：/var/www/html/web-vue-voice static/ index.html: | :后端：/var/www/html UbainsDevOps/: | :数据库：devops: |