# 服务自检需求说明文档

## 📋 概述

本脚本主要用于服务自检，用于检测服务器上的服务是否正常启动，并返回结果。

### 背景

目前针对系统服务进行自检，需要区分两种平台环境：

- **新统一平台**：使用 `/data/` 目录结构
- **传统平台**：使用 `/var/www/` 目录结构

## 🎯 功能实现总览

### 服务自检 (`check_server_health.ps1`和`check_server_health.sh`)
    脚本路径：AuxiliaryTool\ScriptTool\ServiceSelfInspection\check_server_health.ps1
    脚本路径：AuxiliaryTool\ScriptTool\ServiceSelfInspection\check_server_health.sh

#### 检测需求

##### 1、SSH连接（✅ 已实现）：
    功能描述：
        负责与目标服务器建立 SSH 连接，支持多种连接方式，作为所有后续检测和修复操作的基础。（sh脚本不需要做连接！！！）

    具体要求：
        1）支持两种接入方式：
            - 预设服务器列表：从本地配置中读取服务器信息（IP / 端口 / 用户名 / 密码），供用户选择；
            - 手动输入模式：由用户在脚本运行时手动输入服务器 IP、端口、用户名、密码。
        2）连接前进行基本参数校验（IP 格式、端口范围等），避免明显的输入错误。
        3）连接失败时，需要在日志中记录详细原因（认证失败 / 超时 / 网络不可达等），并给出友好提示。

##### 2、平台识别（✅ 已实现）：
    功能描述：
        在成功连接目标服务器后，自动识别其所属平台类型，用于后续按平台选择不同的检测路径和目录结构。

    识别规则：
        - 新统一平台：
            - 特征：存在 `/data/services` 目录；
            - 目录结构主要以 `/data/` 为根路径。
        - 传统平台：
            - 特征：不存在 `/data/services` 目录；
            - 目录结构主要以 `/var/www/` 为根路径。

    具体要求：
        1）识别结果需要在日志中明确打印（例如：“平台类型：新统一平台”或“平台类型：传统平台”）。
        2）将平台类型保存到全局变量或上下文中，供后续检测函数统一使用（如文件路径、容器路径等）。
        3）若无法明确识别（目录缺失或权限不足），需给出清晰的错误提示，并中止依赖平台判断的后续检测。

##### 3、系统识别（✅ 已实现）：
    功能描述：
        在完成平台识别后，对目标服务器上的业务系统类型进行识别，
        主要通过容器信息判断当前服务器是否部署了会议预定系统、运维集控系统、转录系统等。

    识别规则（基于容器）：
        - ujava 容器存在：
            - 说明：部署了会议预定系统（Java 会议相关服务）；
        - upython 容器存在：
            - 说明：部署了运维集控系统（Python CMDB / 运维相关服务）；
        - upython_voice 容器存在：
            - 说明：部署了转录系统（语音转写 / 语音相关服务）。

    具体要求：
        1）通过 `docker ps` / `docker ps -a` 等命令获取容器列表，根据容器名称包含 `ujava`、`upython`、`upython_voice` 进行判断。
        2）在日志中打印当前服务器安装的系统类型组合，例如：
            - “检测到系统类型：会议预定系统 + 运维集控系统”；
            - “检测到系统类型：仅部署会议预定系统”。
        3）识别结果用于后续有条件的检测步骤：
            - 若无 ujava 容器，则跳过会议预定系统相关检测；
            - 若无 upython 容器，则跳过运维集控系统相关检测；
            - 若无 upython_voice 容器，则跳过转录系统相关检测。

##### 4、服务进程检测（✅ 已实现）：
    根据平台类型不同需要分别在不同的位置进行检测，具体如下：

###### 新统一平台（✅ 已实现）：
        ujava后端服务分为容器内和容器外
            需进入ujava2容器内检查，共有以下五个基础服务进程：
                ["auth"]="ubains-auth.jar"
                ["gateway"]="ubains-gateway.jar"
                ["system"]="ubains-modules-system.jar"
                ["meeting2.0"]="java-meeting2.0/ubains-meeting-inner-api-1.0-SNAPSHOT.jar"
                ["meeting3.0"]="java-meeting3.0/ubains-meeting-inner-api-1.0-SNAPSHOT.jar"
                ["mqtt"]="ubains-meeting-mqtt-1.0-SNAPSHOT.jar"
                ["quartz"]="ubains-meeting-quartz-1.0-SNAPSHOT.jar"
                ["message"]="ubains-meeting-message-scheduling-1.0-SNAPSHOT.jar"
            在宿主机上路径：
                /data/services/api/java-meeting/java-meeting-extapi目录下的ubains-meeting-api-1.0-SNAPSHOT.jar进程
            异常修复：
             如果是宿主机上ubains-meeting-api-1.0-SNAPSHOT.jar进程没有启动的话，也需要进行远程修复：
                对外服务修复函数名称：fix_external_service_disconnect

                功能描述：上传当前目录下的issue_handler.sh脚本，将脚本上传到目标服务器，并且通过传入的修复函数，调用issue_handler对应的函数来修复。修复完成后需进行复检。
            
        upython后端服务需进入upython容器内检查，共有以下4个端口：
                tcp        0      0 0.0.0.0:11211           0.0.0.0:*               LISTEN      14/memcached        
                tcp        0      0 127.0.0.1:36917         0.0.0.0:*               LISTEN      38/uwsgi            
                tcp        0      0 0.0.0.0:8000            0.0.0.0:*               LISTEN      38/uwsgi            
                tcp6       0      0 :::11211                :::*                    LISTEN      14/memcached
            
        upython_voice后端服务需进入upython_voice容器内检查，共有以下： 
                tcp        0      0 127.0.0.1:39573         0.0.0.0:*               LISTEN      114/uwsgi           
                tcp        0      0 0.0.0.0:1883            0.0.0.0:*               LISTEN      -                   
                tcp        0      0 0.0.0.0:8000            0.0.0.0:*               LISTEN      114/uwsgi           
                tcp        0      0 0.0.0.0:9001            0.0.0.0:*               LISTEN      -                   
                tcp        0      0 0.0.0.0:11211           0.0.0.0:*               LISTEN      79/memcached        
                tcp        0      0 0.0.0.0:8080            0.0.0.0:*               LISTEN      47/nginx: master pr 
                tcp        0      0 0.0.0.0:80              0.0.0.0:*               LISTEN      47/nginx: master pr 
                tcp6       0      0 :::1883                 :::*                    LISTEN      -                   
                tcp6       0      0 :::11211                :::*                    LISTEN      79/memcached        
                tcp6       0      0 :::80                   :::*                    LISTEN      47/nginx: master pr

###### 传统平台（✅ 已实现）：
        ujava后端服务分为容器内和容器外
            需进入ujava2容器内检查，共有以下两个基础服务进程：
                root           8       1  0 15:26 ?        00:00:00 nginx: master process /usr/local/nginx/sbin/nginx
                ubains-meeting-inner-api-1.0-SNAPSHOT.jar
            在宿主机路径：/var/www/java/external-meeting-api的进程：
                ubains-meeting-api-1.0-SNAPSHOT.jar
            异常修复：
             如果是宿主机上ubains-meeting-api-1.0-SNAPSHOT.jar进程没有启动的话，也需要进行远程修复：
                对外服务修复函数名称：fix_external_service_disconnect

                功能描述：上传当前目录下的issue_handler.sh脚本，将脚本上传到目标服务器，并且通过传入的修复函数，调用issue_handler对应的函数来修复。修复完成后需进行复检。
        
        upython后端服务在容器内：
            tcp        0      0 0.0.0.0:8081            0.0.0.0:*               LISTEN      101/nginx: master p 
            tcp        0      0 127.0.0.1:37817         0.0.0.0:*               LISTEN      124/uwsgi           
            tcp        0      0 0.0.0.0:8443            0.0.0.0:*               LISTEN      101/nginx: master p 
            tcp        0      0 0.0.0.0:8000            0.0.0.0:*               LISTEN      124/uwsgi           
            tcp        0      0 0.0.0.0:8002            0.0.0.0:*               LISTEN      14/httpd            
            tcp        0      0 0.0.0.0:11211           0.0.0.0:*               LISTEN      105/memcached       
            tcp6       0      0 :::11211                :::*                    LISTEN      105/memcached   

##### 5、DNS解析问题（✅ 已实现）：
    功能描述：
        检测目标服务器当前的 DNS 配置是否正常，能否进行域名解析。
        当解析异常时，参考 NTP 远程修复的方式，自动执行修复脚本（无需区分新统一平台或传统平台）。

    具体要求：
        1）通过常用命令（如 nslookup / dig / ping 域名等）验证 DNS 是否可用；
        2）当检测到解析失败或严重异常时：
            - 在日志中详细记录异常表现（如“无法解析域名”、“超时”、“无可用 DNS 服务器”等）；
            - 调用 Upload_the_repair_script，远程执行 issue_handler.sh 中的 DNS 修复函数；
        3）修复完成后，重新进行一次 DNS 解析测试，并将复检结果记录到日志和自检报告中：
            - 成功：标记为“DNS 解析修复成功”；
            - 失败：标记为“DNS 解析仍异常，需要人工排查”。

##### 6、服务器资源分析（✅ 已实现）：
    功能描述：
        综合检测目标服务器的资源与基础环境状态，包括：
        - 磁盘空间使用情况
        - 内存使用情况
        - CPU 使用情况
        - 防火墙开放端口情况
        - 服务器硬件架构与操作系统版本信息

    防火墙修复：
        1）修复函数名称：Upload_the_repair_script
            - 该函数仅负责上传并调用 issue_handler.sh 中的具体防火墙修复函数（如 fix_port_access）。

        2）检测与判定规则：
            - 若目标服务器未开启防火墙服务：
                - 判定为异常，记录到日志和报告中；
                - 自动调用防火墙修复脚本尝试开启并配置必要端口。
            - 若防火墙已开启，根据系统角色进行端口校验：
                - 会议预定系统：
                    - 必须开放端口：22、443、1883、8306
                - 运维集控系统：
                    - 必须开放端口：22、8443、1883、8306
                - 任一必需端口未开放时，判定为异常，需要执行修复脚本。

        3）修复执行与结果记录：
            - 由 Upload_the_repair_script 远程执行 issue_handler.sh 中的防火墙修复函数，自动添加缺失端口规则；
            - 修复完成后不强制要求再次自动复检，但需在日志中明确打印修复执行结果，
              包括：尝试执行的命令、成功/失败状态及可能的错误原因，便于后续人工确认。

##### 7、服务日志导出（✅ 已实现）：
    将目标服务器上的服务日志采集，需判断传统平台还是新统一平台
        传统平台：
            如果有ujava容器：
                1、将/var/www/java/api-java-meeting2.0/logs目录下的ubains-INFO-AND-ERROR.log日志文件导出来命名为：对内后端_ubains-INFO-AND-ERROR.log
                2、将/var/www/java/external-meeting-api/logs目录下的ubains-INFO-AND-ERROR.log日志文件导出来命名为：对外后端_ubains-INFO-AND-ERROR.log
                3、将nginx日志导出：
                    - 步骤1：通过docker cp将/usr/local/nginx/logs路径下的error.log日志文件拷贝到宿主机上
                    - 步骤2：再将宿主机上的这份error.log日志文件命名改为nginx_error.log导出到本地
            如果有upython容器：
                1、将/var/www/html/log目录下的error.log、uinfo.log和uwsgi.log日志文件导出来命名都增加前缀：运维集控_error.log、运维集控_uinfo.log和运维集控_uwsgi.log
                2、将nginx日志导出：
                    - 步骤1：通过docker cp将/usr/local/nginx/logs路径下的error.log日志文件拷贝到宿主机上
                    - 步骤2：再将宿主机上的这份error.log日志文件命名改为nginx_error.log导出到本地

        
        新统一平台：
            如果有ujava容器：
                1、将/data/services/api/auth/auth-sso-auth目录下的log.out日志文件导出来命名为auth_log.out
                2、将/data/services/api/auth/auth-sso-gatway目录下的log.out日志文件导出来命名为gatway_log.out
                3、将/data/services/api/auth/auth-sso-system目录下的log.out日志文件导出命名为system_log.out
                4、将/data/services/api/java-meeting/java-meeting2.0/logs目录下的ubains-INFO-AND-ERROR.log日志文件导出命名为对内2.0_ubains-INFO-AND-ERROR.log
                5、将/data/services/api/java-meeting/java-meeting3.0/logs目录下的ubains-INFO-AND-ERROR.log日志文件导出命名为对内3.0_ubains-INFO-AND-ERROR.log
                6、将/data/services/api/java-meeting/java-meeting-extapi/logs目录下的ubains-INFO-AND-ERROR.log日志文件导出命名为对外服务_ubains-INFO-AND-ERROR.log
                7、将/data/services/api/java-meeting/java-message-scheduling/logs目录下的ubains-INFO-AND-ERROR.log日志文件导出命名为信息调度_ubains-INFO-AND-ERROR.log
                8、将/data/services/api/java-meeting/java-mqtt/logs目录下的ubains-INFO-AND-ERROR.log日志文件导出命名为MQTT_ubains-INFO-AND-ERROR.log
                9、将/data/services/api/java-meeting/java-quartz/logs目录下的ubains-INFO-AND-ERROR.log日志文件导出命名为定时任务_ubains-INFO-AND-ERROR.log

##### 8、配置文件IP检测（✅ 已实现）
    检测目标服务器上的配置文件中的IP地址配置是否正确为目标服务器IP，需判断传统平台还是新统一平台
        传统平台：
            如果有ujava容器：
                1、检测/var/www/java/api-java-meeting2.0/config目录下的yml、properties、js格式的配置文件中的IP地址
                2、检测/var/www/java/external-meeting-api/config目录下的yml、properties、js格式的配置文件中的IP地址
                3、检测/var/www/java/ubains-web-2.0/static目录下的config.json配置文件的IP地址
                4、检测/var/www/java/ubains-web-admin/static目录下的config.json配置文件的IP地址
                5、检测/var/www/java/ubains-web-h5/static/h5目录下的config.js或config.json配置文件的IP地址
                6、检测/var/www/java/nginx-conf.d目录下的conf配置文件中的IP地址
                
            如果有upython容器：
                1、检测/var/www/html目录下的conf配置文件的IP地址
                2、检测/var/www/html/nginx-conf目录下的conf配置文件的IP地址
                3、检测/var/www/html/web-vue-rms/static文件夹下的config.json配置文件的IP地址
                4、检测/var/www/html/web-vue-h5/static/h5目录下的config.js或config.json配置文件的IP地址
        
        新统一平台：
            如果有ujava容器：
                1、检测/data/services/api/auth/auth-sso-auth/config目录下的yml、properties、js、json、conf格式文件中IP地址
                2、检测/data/services/api/auth/auth-sso-gatway/config目录下的yml、properties、js、json、conf格式文件中IP地址
                3、检测/data/services/api/auth/auth-sso-system/config目录下的yml、properties、js、json、conf格式文件中IP地址
                4、检测/data/services/api/java-meeting/java-meeting2.0/config目录下的yml、properties、js、json、conf格式文件中IP地址
                5、检测/data/services/api/java-meeting/java-meeting3.0/config目录下的yml、properties、js、json、conf格式文件中IP地址
                6、检测/data/services/api/java-meeting/java-meeting-extapi/config目录下的yml、properties、js、json、conf格式文件中IP地址
                7、检测/data/services/api/java-meeting/java-message-scheduling/config目录下的yml、properties、js、json、conf格式文件中IP地址
                8、检测/data/services/api/java-meeting/java-mqtt/config目录下的yml、properties、js、json、conf格式文件中IP地址
                9、检测/data/services/api/java-meeting/java-quartz/config目录下的yml、properties、js、json、conf格式文件中IP地址
            
            如果有upython容器：
                1、/data/services/api/python-cmdb目录下的yml、properties、js、json、conf格式文件中IP地址
            
            前端配置文件检测：
                1、检测/data/services/web/pc/pc-vue2-ai目录下的js、json、conf格式文件中IP地址
                2、检测/data/services/web/pc/pc-vue2-backstage目录下的js、json、conf格式文件中IP地址
                3、检测/data/services/web/pc/pc-vue2-editor目录下的js、json、conf格式文件中IP地址
                4、检测/data/services/web/pc/pc-vue2-main目录下的js、json、conf格式文件中IP地址
                5、检测/data/services/web/pc/pc-vue2-meetingControl目录下的js、json、conf格式文件中IP地址
                6、检测/data/services/web/pc/pc-vue2-meetngV2目录下的js、json、conf格式文件中IP地址
                7、检测/data/services/web/pc/pc-vue2-meetngV3目录下的js、json、conf格式文件中IP地址
                8、检测/data/services/web/pc/pc-vue2-moniter目录下的js、json、conf格式文件中IP地址
                9、检测/data/services/web/pc/pc-vue2-platform目录下的js、json、conf格式文件中IP地址
                10、检测/data/services/web/pc/pc-vue2-voice目录下的js、json、conf格式文件中IP地址
            
            中间件配置文件检测：
                1、检测/data/middleware/nginx/config目录下的conf格式文件中的IP地址

        注意：如果遇到有172.17.0.1、127.0.0.1的IP地址以及和目标服务器IP地址一致的需判断为正确！检测日志需要打印出配置文件的路径，不要进行修改IP的操作！将单个配置文件内的IP地址检测收集结果后再标注打印，并增加配置项地址。日志需要更简洁明了！合法地址可以不打印出来。

##### 9、服务器NTP服务检测（✅ 已实现）：
    功能描述：
        检测目标服务器上的时间同步服务是否正常，当前主要包括 ntp 和 chronyd 两种实现。
        需要确认：
        1）时间同步服务是否已安装并处于运行状态；
        2）目标服务器时间与北京时间是否保持一致（误差在可接受范围内）。

    具体要求：
        1）优先检测 chronyd / ntpd 等服务状态，判断是否处于 active / running。
        2）通过 date、timedatectl 或 ntpstat 等命令获取当前系统时间和同步状态。
        3）将目标服务器时间与北京时间进行对比：
            - 若时间差在约定范围内（例如 ±3 分钟），视为正常；
            - 若时间差超出范围，视为异常，在日志和自检报告中进行标记。
        4）检测过程中只做状态和时间差的检查，不对 ntp/chronyd 配置文件做任何修改操作。

    注意：
        - 此检测步骤需要在“服务日志导出”之前执行，避免因时间不准导致日志分析困难。
        - 本脚本仅负责检测，不自动修改 NTP 相关配置，必要的修复由人工或其他修复脚本完成。

##### 10、文件权限检测（✅ 已实现）：
    功能描述：
        检测目标服务器上与服务运行密切相关的关键文件权限，包括：
        - 数据库用户权限
        - nginx 运行用户及相关文件权限
        - 各服务启动脚本（run.sh / start.sh）权限
        - Redis / Emqx 等中间件配置文件权限
        - 系统 rc.local 启动项权限

        根据平台类型（传统平台 / 新统一平台）分别检查不同路径下的文件权限。

    具体检测范围：

        传统平台：
            如果有 ujava 容器：
                1）检测 /var/www/java/api-java-meeting2.0 目录下 run.sh 启动脚本权限
                2）检测 /var/www/java/external-meeting-api 目录下 run.sh 启动脚本权限
                3）检测 /var/www/java 目录下 start.sh 启动脚本权限
            如果有 upython 容器：
                1）检测 /var/www/html 目录下 start.sh 启动脚本权限
            如果有 cardtable 容器：
                1）检测 /var/www/wifi-local 目录下 config.ini、startDB.sh、wifi 的文件权限
            如果有 paperless 容器：
                1）检测 /var/www/paperless 目录下 run.sh 和 start.sh 文件权限
            公共部分：
                1）检测 /var/www/redis 目录下 redis-*.conf 文件权限
                2）检测 /var/www/emqx 或 /var/www/emqx/config 目录下 *.conf 文件权限

        新统一平台：
            如果有 ujava 容器：
                1）检测 /data/services/api/auth/auth-sso-auth 目录下 run.sh 文件权限
                2）检测 /data/services/api/auth/auth-sso-gatway 目录下 run.sh 文件权限
                3）检测 /data/services/api/auth/auth-sso-system 目录下 run.sh 文件权限
                4）检测 /data/services/api/java-meeting/java-meeting2.0 目录下 run.sh 文件权限
                5）检测 /data/services/api/java-meeting/java-meeting3.0 目录下 run.sh 文件权限
                6）检测 /data/services/api/java-meeting/java-meeting-extapi 目录下 run.sh 文件权限
                7）检测 /data/services/api/java-meeting/java-message-scheduling 目录下 run.sh 文件权限
                8）检测 /data/services/api/java-meeting/java-mqtt 目录下 run.sh 文件权限
                9）检测 /data/services/api/java-meeting/java-quartz 目录下 run.sh 文件权限
                10）检测 /data/services/api 目录下 start.sh 文件权限
                11）检测 /data/services/scripts 目录下所有 *.sh 脚本文件权限
            如果有 upython 容器：
                1）检测 /data/services/api/python-cmdb 目录下所有 *.sh 脚本文件权限
            如果有 upython_voice 容器：
                1）检测 /data/services/api/python-voice 目录下所有 *.sh 脚本文件权限
            如果有 paperless 容器：
                1）检测 /data/third_party/paperless 目录下 run.sh 和 start.sh 脚本文件权限
            如果有 cardtable 容器：
                1）检测 /data/third_party/wifi-local 目录下 config.ini、startDB.sh、wifi 的文件权限

        公共部分（两种平台通用）：
            1）检测 /etc/rc.d/rc.local 文件权限
            2）数据库用户权限：
                - 进入 umysql 容器内检查；
                - 数据库账号：root，密码：dNrprU&2S；
                - 重点关注 ubains 和 devops 数据库对应用户及权限配置是否符合预期。

    日志与执行顺序要求：
        1）此检测函数需要在“服务日志导出”函数之前执行，确保日志中能完整记录权限情况。
        2）main 主函数和日志记录函数中都需要补充对本检测函数的调用，并将各关键文件的权限信息打印到日志中。
        3）仅做检测与记录，不在该步骤自动修改任何文件权限；具体权限调整由人工或其他修复脚本处理。

##### 11、现场数据备份（✅ 已实现）：
    函数名称：DataBakup
    
    先判断目标服务器是新统一平台还是传统平台，再备份对应平台的服务包与配置文件等数据，最后在目标服务器上压缩成tar.gz格式文件导出到电脑上。
    
    传统平台：
        如果有ujava容器：
            1、将/var/www/java目录复制到/home/bakup目录下
        如果有upython容器：
            1、将/var/www/html目录复制到/home/bakup目录下
        如果有cardtable容器：
            1、将/var/www/wifi-local目录复制到/home/bakup目录下
        如果有paperless容器：
            1、将/var/www/paperless目录复制到/home/bakup目录下    
        共有：
            1、将/var/www/emqx和/var/www/redis目录复制到/home/bakup目录下
            2、数据库备份，账号为root，密码为dNrprU&2S，数据库容器是umysql容器，数据库是ubains和devops，数据库备份完成后也复制到/home/bakup目录下
        最后将/home/bakup目录压缩成tar.gz格式文件并导出，文件命名补充时间戳，导出完成后清理/home目录下的这个备份文件。

##### 12、容器信息收集（✅ 已实现）：
    函数名称：Test-ContainerInformation
    需求描述：
        查询当前服务器上所有容器信息（包含未运行与运行中的信息），可以通过docker inspect来获取MAC地址、端口映射信息、启动文件位置。
        信息打印排版：先打印运行中的容器信息，再打印未运行的容器信息。在容器信息打印之间增加分隔线。
    容器异常：
        Redis容器：
            1、日志获取：
                检测
                新统一平台：
                    路径：/data/middleware/redis/data/redis.log
                传统平台：
                    路径：/var/www/redis/data/redis.log
                将上述redis.log文件从目标服务器导出到本地自检结果目录中（例如logs/redis/子目录），并在自检日志中记录导出结果。
            2、异常判定：
                如果 uredis 容器未运行，并且没有其他名字中包含“redis”的运行中容器，则判定为 Redis 容器异常。
            3、远端修复操作：
                调用上传修复脚本函数 Upload_the_repair_script，将当前目录下的issue_handler.sh脚本上传到目标服务器，并执行其中的 redis_container_exception 修复函数。
                调用示例（逻辑示意）：
                    ./issue_handler.sh --action redis_container_exception --non-interactive --yes
            4、修复完成后的复检：
                修复脚本执行完成后，再次检查 uredis 容器状态：
                    - 如果 uredis 已处于运行状态，记录“Redis容器复检成功”到自检日志和md报告中；
                    - 如果 uredis 仍未运行，则记录“Redis容器复检失败，需要人工排查”到自检日志和md报告中。
        emqx容器：
            1、日志获取：
                检测
                新统一平台：
                    路径：/data/middleware/emqx/log/emqx.log.1
                传统平台：
                    路径：/var/www/emqx/log/emqx.log.1
                将上述log文件从目标服务器导出到本地自检结果目录中（例如logs/emqx/子目录），并在自检日志中记录导出结果。
            2、异常判定：
                如果 uemqx 容器未运行，并且没有其他名字中包含“emqx”的运行中容器，则判定为 Emqx 容器异常。
            3、远端修复操作：
                调用上传修复脚本函数 Upload_the_repair_script，将当前目录下的issue_handler.sh脚本上传到目标服务器，并执行其中的 emqx_container_exception 修复函数。
                调用示例（逻辑示意）：
                    ./issue_handler.sh --action emqx_container_exception --non-interactive --yes
            4、修复完成后的复检：
                修复脚本执行完成后，再次检查 uemqx 容器状态：
                    - 如果 uemqx 已处于运行状态，记录“Emqx容器复检成功”到自检日志和md报告中；
                    - 如果 uemqx 仍未运行，则记录“Emqx容器复检失败，需要人工排查”到自检日志和md报告中。

##### 13、定时任务查询（待实现）：
    函数名称：Test-ScheduledTask
    需求描述：通过crontab -l检查目标服务器上的定时任务.
    新统一平台：
        - */3 * * * * /data/services/scripts/ujava2-startup.sh
        - 0 13 * * * bash /usr/local/docker/UbainsmysqlBakUp.sh
    传统平台：
        公有：
            - 0 13 * * * bash /usr/local/docker/UbainsmysqlBakUp.sh
        ujava存在：
            -

##### 14、上传修复脚本（已实现NTP和防火墙修复）：
    函数名称：Upload_the_repair_script

    功能描述：
        该函数仅负责：
        1）将当前目录下的 issue_handler.sh 脚本上传到目标服务器指定目录；
        2）在远端赋予执行权限并进行必要的换行符处理（如 dos2unix）；
        3）根据传入的修复动作名称（action），在远端调用 issue_handler.sh 中对应的修复函数。

    使用方式：
        - 由各检测函数在发现异常后调用 Upload_the_repair_script，并通过参数指定需要执行的修复动作。
        - Upload_the_repair_script 内部会在远端执行类似如下命令：
              ./issue_handler.sh --action <修复函数名> [--platform <平台类型>] [--non-interactive --yes]

    典型调用示例：
        1）NTP 服务异常修复：
            检测到目标服务器 NTP 服务配置或状态异常时：
                调用 issue_handler.sh 中的 fix_ntp_config 函数：
                    ./issue_handler.sh --action fix_ntp_config

        2）防火墙端口异常修复：
            检测到目标服务器防火墙未开启或必要端口未开放（如 22/443/1883/8443 等）时：
                调用 issue_handler.sh 中的 fix_port_access 函数（通常以非交互方式执行）：
                    ./issue_handler.sh --action fix_port_access --non-interactive --yes

        3）对外后端服务未启动修复：
            检测到对外后端服务进程（ubains-meeting-api-1.0-SNAPSHOT.jar）未启动时：
                调用 issue_handler.sh 中的 fix_external_service_disconnect 函数：
                    ./issue_handler.sh --action fix_external_service_disconnect --non-interactive --yes

        4）Redis 容器启动异常修复：
            在容器信息收集中检测到 Redis 容器异常（uredis 未运行，且无其他 redis 容器）时：
                调用 issue_handler.sh 中的 redis_container_exception 函数（以非交互方式执行，自动清理 data 并重启）：
                    ./issue_handler.sh --action redis_container_exception --non-interactive --yes

        5）Emqx 容器启动异常修复（预留）：
            在容器信息收集中检测到 Emqx 容器异常（uemqx 未运行，且无其他 emqx 容器）时：
                预期调用 issue_handler.sh 中的 emqx_container_exception 函数（同样支持非交互方式）：
                    ./issue_handler.sh --action emqx_container_exception --non-interactive --yes

    说明：
        - Upload_the_repair_script 不直接实现具体修复逻辑，只负责：
              “上传脚本 → 远端准备 → 拼接命令行 → 触发执行”
        - 具体修复行为（如修改配置、重启服务、清理数据目录等）均在 issue_handler.sh 中的各修复函数内部实现。
        - 对于高风险操作（如 Redis data 目录清理），自检场景采用非交互模式（--non-interactive --yes），
          手工运维场景则可直接在服务器上交互式执行 issue_handler.sh，由运维人员确认后再进行删除或修改操作。

##### 15、安卓设备的自检（✅ 已实现）：
    功能描述：
        针对连接到服务器的安卓设备，执行一系列自检操作以确保设备状态正常。
        主要检测项包括：
        - 设备连接状态
        - 日志文件收集

    具体要求：
        1）设备连接状态检测：
            - 设备IP由手动输入，端口默认为5555.连接指令为：adb connect <device_ip>:<port>
            - 使用 adb 命令连接设备，并检查连接状态。
            - 若设备未连接或连接异常，记录错误信息并终止后续检测。

        2）日志文件收集：
            - 通过指令导出日志文件目录，并使用 adb 命令导出日志文件。
            - adb pull /sdcard/Android/data/com.ubains.local.gviewer/files/ 当前脚本所在目录下的 logs/android/ 子目录。
            - adb pull /sdcard/Android/data/com.ubains.local.gviewer/cache/ 当前脚本所在目录下的 logs/android/ 子目录。如果没有cache目录就记录打印后跳过这个目录导出操作。

        3）断开连接：
            - 收集完成后需要自动断开连接，adb disconnect <device_ip>:<port>

    报告输出：
        - 将安卓设备自检结果整合到整体自检报告中，明确标识各检测项的状态。
        - 对于异常项，提供简要说明和建议处理措施。

##### 16、服务自检报告输出（✅ 已实现）：
    功能描述：
        将本次服务自检过程中所有检测项的执行步骤、检测结果、异常说明及修复情况统一输出为报告文件，
        既包含完整日志记录，也生成便于阅读的 Markdown 自检报告。

    具体要求：
        1）完整日志输出：
            - 将脚本执行过程中的关键信息（开始/结束时间、目标服务器信息、各检测项结果等）
              持久化到日志文件（.log），便于后续排查。
            - 日志内容应包含每个检测函数的开始/结束标记、检测结论和异常详情。

        2）Markdown 自检报告输出：
            - 生成一份结构化的自检报告（.md），按检测顺序分章节展示各检测项的结果，
              包括：检测项名称、检测说明、检测结果（成功/失败/警告）、简要结论。
            - 每条检测结果前需增加明显的图标标识状态：
                - ✅ 表示检测通过 / 状态正常
                - ⚠️ 表示存在风险 / 需关注
                - ❌ 表示检测失败 / 状态异常
            - 对于异常项，需要在报告中简要说明异常原因，必要时附上建议处理方向。

        3）报告内容范围：
            - 至少包含以下模块的检测结果：
                - SSH 连接与平台识别
                - 系统识别与服务进程检测
                - DNS / NTP / 防火墙 / 资源使用情况
                - 配置文件 IP 检测、文件权限检测
                - 服务日志导出、现场数据备份
                - 容器信息收集及容器异常（Redis / Emqx 等）处理结果

        4）输出形式与存放位置：
            - 日志文件和 Markdown 报告文件建议按服务器 IP + 时间戳命名，方便区分多次自检结果。
            - 报告文件统一存放在脚本所在目录下的指定输出目录中（例如：logs/ 或 reports/ 子目录）。

        5）可读性要求：
            - 报告结构清晰，分级标题明确（如：一级为大模块，二级为具体检测项）。
            - 对终端用户（非开发人员）也能直观理解当前服务器健康状况以及需要关注的问题。