# filepath: e:\GithubData\自动化\ubains-module-test\AuxiliaryTool\ScriptTool\自动化服务监测\AutomatedServiceMonitoring.sh
#!/usr/bin/env bash
# filepath: e:\GithubData\自动化\ubains-module-test\AuxiliaryTool\ScriptTool\自动化服务监测\AutomatedServiceMonitoring.sh

########################################
# 自动化服务监测 Shell 脚本（单机版，单次执行）
########################################

set -u

#################### 全局配置 ####################
MYSQL_USER="root"
MYSQL_PASSWORD="dNrprU&2S"
LOG_FILE="./AutomatedServiceMonitoring.sh.log"
REPORT_DIR="./monitor_reports"
WORD_REPORT_DIR="./monitor_reports_word"
HOST_NAME="${HOST_NAME_OVERRIDE:-$(hostname 2>/dev/null || echo localhost)}"


# 邮件通知配置
MAIL_TO="czj@huazhaochina.com,pgy@huazhaochina.com,zxb@huazhaochina.com,wb@huazhaochina.com"
MAIL_SUBJECT_PREFIX="自动化服务监测报告"

# ✅ 邮件标题：支持自定义
# 1) 你可以直接改这个默认值
MAIL_SUBJECT_PREFIX="【内部服务器监测】"
# 2) 也可以在运行时通过环境变量覆盖，例如：
#    MAIL_SUBJECT_PREFIX="【产线】服务监测报告" ./AutomatedServiceMonitoring.sh
MAIL_SUBJECT_PREFIX="${MAIL_SUBJECT_PREFIX:-自动化服务监测报告}"

# SMTP 服务器配置（QQ 企业邮箱）
MAIL_SMTP_HOST="smtp.exmail.qq.com"
MAIL_SMTP_PORT="465"
MAIL_SMTP_SSL_SCHEME="smtps"  # s-m-t-p-s 协议
MAIL_SMTP_USER="czj@huazhaochina.com"
MAIL_SMTP_PASS="Ubains@123"

# 钉钉机器人配置（自定义机器人 -> 安全设置 -> 加签）
# 自定义机器人 -> 安全设置 -> 加签
DINGDING_ACCESS_TOKEN="7fbf40798cad98b1b5db55ff844ba376b1816e80c5777e6f47ae1d9165dacbb4"
DINGDING_SECRET="SEC610498ed6261ae2df1d071d0880aaa70abf5e67efe47f75a809c1f2314e0dbd6"

# 不需要 @ 人就都留空/false
DINGDING_AT_MOBILES=""
DINGDING_AT_ALL="false"

#################### 日志 ####################
log() {
    local level="$1"; shift
    local ts
    ts="$(date '+%Y-%m-%d %H:%M:%S')"
    local msg="[$ts] [$level] $*"
    echo "$msg"
    echo "$msg" >>"$LOG_FILE"
}

#################### 依赖安装 ####################
detect_os_and_pkg_mgr() {
    # 简单判断是基于 yum 还是 apt
    if command -v yum >/dev/null 2>&1; then
        echo "yum"
    elif command -v apt-get >/dev/null 2>&1; then
        echo "apt"
    else
        echo "unknown"
    fi
}

ensure_mailx_installed() {
    if command -v mail >/dev/null 2>&1 || command -v mailx >/dev/null 2>&1; then
        log INFO "[依赖检查] mail/mailx 已安装"
        return 0
    fi

    local pkg_mgr
    pkg_mgr="$(detect_os_and_pkg_mgr)"
    log INFO "[依赖安装] 检测到包管理器：${pkg_mgr}"

    if [[ "$pkg_mgr" == "yum" ]]; then
        log INFO "[依赖安装] 尝试使用 yum 安装 mailx"
        yum install -y mailx >>"$LOG_FILE" 2>&1 || {
            log ERROR "[依赖安装] 使用 yum 安装 mailx 失败，请手工检查。"
            return 1
        }
    elif [[ "$pkg_mgr" == "apt" ]]; then
        log INFO "[依赖安装] 尝试使用 apt-get 安装 mailutils"
        apt-get update >>"$LOG_FILE" 2>&1 || true
        apt-get install -y mailutils >>"$LOG_FILE" 2>&1 || {
            log ERROR "[依赖安装] 使用 apt-get 安装 mailutils 失败，请手工检查。"
            return 1
        }
    else
        log ERROR "[依赖安装] 未识别到可用的包管理器（yum/apt-get），无法自动安装 mailx。"
        return 1
    fi

    if command -v mail >/dev/null 2>&1 || command -v mailx >/dev/null 2>&1; then
        log INFO "[依赖安装] mail/mailx 安装完成"
        return 0
    else
        log ERROR "[依赖安装] mail/mailx 安装后仍不可用，请手工检查。"
        return 1
    fi
}

# ensure_pandoc_installed() {
#     if command -v pandoc >/dev/null 2>&1; then
#         log INFO "[依赖检查] pandoc 已安装"
#         return 0
#     fi

#     local pkg_mgr
#     pkg_mgr="$(detect_os_and_pkg_mgr)"
#     log INFO "[依赖安装] 检测到包管理器：${pkg_mgr}"

#     if [[ "$pkg_mgr" == "yum" ]]; then
#         log INFO "[依赖安装] 使用 yum 安装 pandoc（需要 epel 源）"
#         yum install -y epel-release >>"$LOG_FILE" 2>&1 || true
#         yum install -y pandoc >>"$LOG_FILE" 2>&1 || {
#             log ERROR "[依赖安装] 使用 yum 安装 pandoc 失败，请手工检查。"
#             return 1
#         }
#     elif [[ "$pkg_mgr" == "apt" ]]; then
#         log INFO "[依赖安装] 使用 apt-get 安装 pandoc"
#         apt-get update >>"$LOG_FILE" 2>&1 || true
#         apt-get install -y pandoc >>"$LOG_FILE" 2>&1 || {
#             log ERROR "[依赖安装] 使用 apt-get 安装 pandoc 失败，请手工检查。"
#             return 1
#         }
#     else
#         log ERROR "[依赖安装] 未识别到可用的包管理器（yum/apt-get），无法自动安装 pandoc。"
#         return 1
#     fi

#     if command -v pandoc >/dev/null 2>&1; then
#         log INFO "[依赖安装] pandoc 安装完成"
#         return 0
#     else
#         log ERROR "[依赖安装] pandoc 安装后仍不可用，请手工检查。"
#         return 1
#     fi
# }

ensure_mailx_smtp_config() {
    local cfg_file="/etc/mail.rc"

    # 如果已经存在，并且里面已经包含 smtp.exmail.qq.com，可以选择跳过
    if [[ -f "$cfg_file" ]] && grep -q "smtp.exmail.qq.com" "$cfg_file" 2>/dev/null; then
        log INFO "[邮件配置] 检测到已有 /etc/mail.rc 且包含 smtp.exmail.qq.com，跳过覆盖。"
        return 0
    fi

    log INFO "[邮件配置] 生成 /etc/mail.rc（使用 QQ 企业邮箱 SMTP）"

    cat >"$cfg_file" <<EOF
set from="${MAIL_SMTP_USER}"
set smtp="${MAIL_SMTP_SSL_SCHEME}://${MAIL_SMTP_HOST}:${MAIL_SMTP_PORT}"
set smtp-auth=login
set smtp-auth-user="${MAIL_SMTP_USER}"
set smtp-auth-password="${MAIL_SMTP_PASS}"
set ssl-verify=ignore
EOF

    # 可选：同步一份到 /etc/nail.rc
    cp "$cfg_file" /etc/nail.rc 2>/dev/null || true

    log INFO "[邮件配置] /etc/mail.rc 已生成：smtp=${MAIL_SMTP_HOST}:${MAIL_SMTP_PORT} user=${MAIL_SMTP_USER}"
    return 0
}

#################### 7. 钉钉发送（纯 Bash + openssl + curl） ####################

# 构造最终的钉钉 Webhook URL（access_token + timestamp + sign）
build_dingtalk_url() {
    local access_token="$1"
    local secret="$2"

    if [[ -z "$access_token" ]]; then
        echo ""
        return 1
    fi

    # 毫秒时间戳
    local timestamp
    timestamp="$(printf '%s000' "$(date +%s)")"

    # 如果没启用加签（secret 为空），只拼 access_token + timestamp
    if [[ -z "$secret" ]]; then
        echo "https://oapi.dingtalk.com/robot/send?access_token=${access_token}&timestamp=${timestamp}"
        return 0
    fi

    # string_to_sign = timestamp + "\n" + secret
    local string_to_sign="${timestamp}"$'\n'"${secret}"

    # HMAC-SHA256 + base64
    local sign_raw
    sign_raw="$(printf '%s' "$string_to_sign" \
        | openssl dgst -sha256 -hmac "$secret" -binary \
        | openssl base64)"

    # URL 编码 —— 严格对齐 Python 的 urllib.parse.quote_plus
    # 规则：
    # 1. 字母/数字/.-_/~ 保留
    # 2. 空格 -> +
    # 3. 其它字符（包括 +、/、= 等）都转成 %XX
    local sign_enc=""
    local i ch hex
    for ((i=0; i<${#sign_raw}; i++)); do
        ch="${sign_raw:$i:1}"
        case "$ch" in
            [a-zA-Z0-9.~_-])
                sign_enc+="$ch"
                ;;
            ' ')
                sign_enc+="+"
                ;;
            *)
                printf -v hex '%%%02X' "'$ch"
                sign_enc+="$hex"
                ;;
        esac
    done

    echo "https://oapi.dingtalk.com/robot/send?access_token=${access_token}&timestamp=${timestamp}&sign=${sign_enc}"
    return 0
}

# 发送 text 消息到钉钉
# 使用方式：先构造 DD_TEXT，然后执行：
#   DD_TEXT="$dd_text" send_dingtalk_markdown
send_dingtalk_markdown() {
    local access_token="${DINGDING_ACCESS_TOKEN:-}"
    local secret="${DINGDING_SECRET:-}"
    local at_mobiles="${DINGDING_AT_MOBILES:-}"
    local at_all="${DINGDING_AT_ALL:-false}"
    local content="${DD_TEXT:-}"

    if [[ -z "$access_token" ]]; then
        log ERROR "[钉钉发送] 未配置 DINGDING_ACCESS_TOKEN，跳过发送。"
        return 1
    fi
    if [[ -z "$content" ]]; then
        log ERROR "[钉钉发送] DD_TEXT 为空，跳过发送。"
        return 1
    fi

    local url
    url="$(build_dingtalk_url "$access_token" "$secret")" || {
        log ERROR "[钉钉发送] 构造 Webhook URL 失败，跳过发送。"
        return 1
    }

    # 组装 @ 信息
    local at_json=""
    if [[ -n "$at_mobiles" ]]; then
        local tmp arr mobile_items m
        tmp="$(echo "$at_mobiles" | tr ',' ' ')"
        # shellcheck disable=SC2206
        arr=($tmp)
        for m in "${arr[@]}"; do
            [[ -z "$m" ]] && continue
            if [[ -n "$mobile_items" ]]; then
                mobile_items="${mobile_items},\"${m}\""
            else
                mobile_items="\"${m}\""
            fi
        done
        at_json="\"at\": {\"atMobiles\": [${mobile_items}], \"isAtAll\": ${at_all} }"
    else
        at_json="\"at\": {\"isAtAll\": ${at_all} }"
    fi

    # 对正文做简单 JSON 转义（换行和双引号）
    local json_content
    json_content="${content//$'\\'/'\\\\'}"   # 反斜杠
    json_content="${json_content//$'"'/'\"'}" # 双引号
    json_content="${json_content//$'\n'/\\n}" # 换行 -> \n

    # 构造 text 消息体
    local payload
    payload="$(cat <<EOF
{
  "msgtype": "text",
  "text": {
    "content": "${json_content}"
  },
  ${at_json}
}
EOF
)"

    # 发送 HTTP 请求
    local resp
    resp="$(curl -sS -H 'Content-Type: application/json;charset=utf-8' -d "$payload" "$url" 2>>"$LOG_FILE" || true)"

    if echo "$resp" | grep -q '"errcode":0'; then
        log INFO "[钉钉发送] 已成功发送消息。响应：$resp"
        return 0
    else
        log ERROR "[钉钉发送] 发送失败，响应：$resp"
        return 1
    fi
}

#################### 1. 平台识别 ####################
detect_platform() {
    if [ -d "/data/services" ]; then
        PLATFORM_TYPE="new"
        BASE_PATH="/data/services"
    else
        PLATFORM_TYPE="legacy"
        BASE_PATH="/var/www"
    fi
}

#################### 2. 系统识别 ####################
detect_systems() {
    HAS_UJAVA=0
    HAS_UPYTHON=0
    HAS_UPYTHON_VOICE=0
    SYSTEMS=()

    local names
    names="$(docker ps --format '{{.Names}}' 2>/dev/null || true)"

    if echo "$names" | grep -q "ujava"; then
        HAS_UJAVA=1
        SYSTEMS+=("meeting")
    fi
    if echo "$names" | grep -q "upython"; then
        HAS_UPYTHON=1
        SYSTEMS+=("ops")
    fi
    if echo "$names" | grep -q "upython_voice"; then
        HAS_UPYTHON_VOICE=1
        SYSTEMS+=("transcription")
    fi
}

#################### 3.1 日志审计（只保留暴涨，不做 ERROR 分析） ####################
resolve_log_targets() {
    LOG_TARGET_SYS=()
    LOG_TARGET_PATH=()

    local has_meeting=0
    for s in "${SYSTEMS[@]}"; do
        if [[ "$s" == "meeting" ]]; then
            has_meeting=1
        fi
    done

    if [[ $has_meeting -eq 1 ]]; then
        if [[ "$PLATFORM_TYPE" == "new" ]]; then
            LOG_TARGET_SYS+=("meeting-2.0")
            LOG_TARGET_PATH+=("$BASE_PATH/api/java-meeting/java-meeting2.0/logs/ubains-INFO-AND-ERROR.log")

            LOG_TARGET_SYS+=("meeting-3.0")
            LOG_TARGET_PATH+=("$BASE_PATH/api/java-meeting/java-meeting3.0/logs/ubains-INFO-AND-ERROR.log")
        else
            LOG_TARGET_SYS+=("meeting-2.0")
            LOG_TARGET_PATH+=("/var/www/java/api-java-meeting2.0/logs/ubains-INFO-AND-ERROR.log")
        fi
    fi
}

declare -A BURST_LAST_TOTAL
declare -A BURST_LAST_TS
declare -A BURST_LAST_RESULT
declare -A BURST_LAST_DESC

make_log_key() {
    local sys_name="$1"
    local log_path="$2"
    echo "${sys_name}|${log_path}"
}

monitor_log_burst_once() {
    local sys_name="$1"
    local log_path="$2"

    local window_seconds=300
    local min_lines_threshold=1000
    local rate_threshold_per_sec=5

    local key
    key="$(make_log_key "$sys_name" "$log_path")"

    if [ ! -f "$log_path" ]; then
        log INFO "[日志暴涨审计] 主机=$HOST_NAME 系统=$sys_name 日志=$log_path 文件不存在"
        BURST_LAST_RESULT["$key"]="NO_FILE"
        BURST_LAST_DESC["$key"]="日志文件不存在"
        return
    fi

    local total_lines
    total_lines="$(wc -l < "$log_path" 2>/dev/null || echo 0)"
    total_lines=$(echo "$total_lines" | tr -d ' ')

    if ! [[ "$total_lines" =~ ^[0-9]+$ ]]; then
        log INFO "[日志暴涨审计] 主机=$HOST_NAME 系统=$sys_name 日志=$log_path 无法获取总行数"
        BURST_LAST_RESULT["$key"]="UNKNOWN"
        BURST_LAST_DESC["$key"]="无法获取总行数"
        return
    fi

    local now_ts
    now_ts="$(date +%s)"

    local last_total="${BURST_LAST_TOTAL[$key]-}"
    local last_ts="${BURST_LAST_TS[$key]-}"

    if [[ -z "${last_total:-}" || -z "${last_ts:-}" ]]; then
        BURST_LAST_TOTAL["$key"]="$total_lines"
        BURST_LAST_TS["$key"]="$now_ts"
        log INFO "[日志暴涨审计] 主机=$HOST_NAME 系统=$sys_name 日志=$log_path 初始化窗口，总行数=$total_lines"
        BURST_LAST_RESULT["$key"]="INIT"
        BURST_LAST_DESC["$key"]="初始化窗口，总行数=${total_lines}"
        return
    fi

    local elapsed=$(( now_ts - last_ts ))
    (( elapsed <= 0 )) && elapsed=1

    local delta_lines=$(( total_lines - last_total ))
    (( delta_lines < 0 )) && delta_lines=0

    BURST_LAST_TOTAL["$key"]="$total_lines"
    BURST_LAST_TS["$key"]="$now_ts"

    if (( elapsed < window_seconds )); then
        log INFO "[日志暴涨审计] 主机=$HOST_NAME 系统=$sys_name 日志=$log_path 累积中：窗口=${elapsed}s 未达 ${window_seconds}s，新增行数=${delta_lines}"
        BURST_LAST_RESULT["$key"]="COLLECTING"
        BURST_LAST_DESC["$key"]="窗口${elapsed}s/未达${window_seconds}s，新增行数=${delta_lines}"
        return
    fi

    local rate
    rate=$(awk -v d="$delta_lines" -v e="$elapsed" 'BEGIN{ if(e<=0){e=1}; printf "%.2f", d/e }')

    local start_ts_human end_ts_human
    start_ts_human="$(date -d @"$last_ts" '+%Y-%m-%d %H:%M:%S' 2>/dev/null || date '+%Y-%m-%d %H:%M:%S')"
    end_ts_human="$(date -d @"$now_ts"  '+%Y-%m-%d %H:%M:%S' 2>/dev/null || date '+%Y-%m-%d %H:%M:%S')"

    local desc="窗口=${elapsed}s 新增行数=${delta_lines} 速率=${rate}行/秒 时间段=[${start_ts_human} ~ ${end_ts_human}]"
    if (( delta_lines >= min_lines_threshold )) || awk -v r="$rate" -v th="$rate_threshold_per_sec" 'BEGIN{exit !(r>=th)}'; then
        log WARN "[日志打印暴涨] 主机=$HOST_NAME 系统=$sys_name 日志=$log_path ${desc}"
        BURST_LAST_RESULT["$key"]="BURST"
        BURST_LAST_DESC["$key"]="$desc"
    else
        log INFO "[日志暴涨审计] 主机=$HOST_NAME 系统=$sys_name 日志=$log_path ${desc}，未发现暴涨"
        BURST_LAST_RESULT["$key"]="OK"
        BURST_LAST_DESC["$key"]="$desc"
    fi
}

#################### 3.2 内存 ####################
MEM_SAMPLES=0
MEM_SUM_USED_MB=0
MEM_PEAK_USED_MB=0
MEM_PEAK_TS=0
MEM_LAST_USED_MB=0

monitor_mem_once() {
    local meminfo
    meminfo="$(cat /proc/meminfo 2>/dev/null)" || {
        log ERROR "[内存监测] $HOST_NAME => 获取 /proc/meminfo 失败"
        return
    }

    local total_kb avail_kb
    total_kb="$(echo "$meminfo" | awk '/^MemTotal:/ {print $2}')"
    avail_kb="$(echo "$meminfo" | awk '/^MemAvailable:/ {print $2}')"

    if [[ -z "$total_kb" || -z "$avail_kb" ]]; then
        log ERROR "[内存监测] $HOST_NAME => 解析失败"
        return
    fi

    local total_mb used_mb
    total_mb=$(awk -v t="$total_kb" 'BEGIN{printf "%.0f",t/1024}')
    used_mb=$(awk -v t="$total_kb" -v a="$avail_kb" 'BEGIN{u=(t-a)/1024; if(u<0)u=0; printf "%.0f",u}')

    MEM_LAST_USED_MB="$used_mb"
    MEM_SAMPLES=$((MEM_SAMPLES + 1))
    MEM_SUM_USED_MB=$((MEM_SUM_USED_MB + used_mb))
    if (( used_mb > MEM_PEAK_USED_MB )); then
        MEM_PEAK_USED_MB=$used_mb
        MEM_PEAK_TS="$(date +%s)"
    fi

    local avg_used=$(( MEM_SUM_USED_MB / MEM_SAMPLES ))
    local peak_human="N/A"
    if [[ "$MEM_PEAK_TS" != "0" && -n "$MEM_PEAK_TS" ]]; then
        peak_human="$(date -d @"$MEM_PEAK_TS" '+%Y-%m-%d %H:%M:%S' 2>/dev/null || date '+%Y-%m-%d %H:%M:%S')"
    fi

    log INFO "[内存监测] $HOST_NAME 当前使用=${used_mb}MB 平均=${avg_used}MB 峰值=${MEM_PEAK_USED_MB}MB@$peak_human"
}

#################### 3.3 MySQL ####################
MYSQL_SAMPLES=0
MYSQL_SUM_CONN=0
MYSQL_PEAK_CONN=0
MYSQL_PEAK_TS=0
MYSQL_LAST_TOTAL=""
MYSQL_LAST_TS=""
MYSQL_LAST_CONN=0
MYSQL_LAST_BURST_STATUS="UNKNOWN"
MYSQL_LAST_BURST_DESC=""

find_mysql_container() {
    docker ps --format '{{.Names}} {{.Image}}' 2>/dev/null | \
        awk '{
            name=$1; $1=""; image=$0;
            low=tolower(name " " image);
            if(index(low,"mysql")>0 || index(low,"mariadb")>0){
                print name; exit 0;
            }
        }'
}

get_mysql_threads_connected_via_container() {
    local container="$1"
    local auth="-u${MYSQL_USER} -p${MYSQL_PASSWORD}"

    local out
    out="$(docker exec -i "${container}" mysql -ss ${auth} -e "SHOW STATUS LIKE 'Threads_connected';" 2>/dev/null | tail -n1 | cut -f2)"
    if [[ "$out" =~ ^[0-9]+$ ]]; then
        echo "$out"
        return 0
    fi

    out="$(docker exec -i "${container}" mysqladmin ${auth} status 2>/dev/null)"
    local val
    val="$(echo "$out" | grep -oE 'Threads:[[:space:]]*[0-9]+' | awk '{print $2}')"
    if [[ "$val" =~ ^[0-9]+$ ]]; then
        echo "$val"
        return 0
    fi
    return 1
}

monitor_mysql_once() {
    local conn=""
    local container
    container="$(find_mysql_container || true)"

    if [[ -n "$container" ]]; then
        conn="$(get_mysql_threads_connected_via_container "$container" || true)"
        if ! [[ "$conn" =~ ^[0-9]+$ ]]; then
            log ERROR "[MySQL监测] $HOST_NAME => 在容器 $container 内获取连接数失败"
            conn=""
        fi
    else
        log INFO "[MySQL监测] $HOST_NAME => 未检测到 MySQL/MariaDB 容器，回退本机命令"
    fi

    if [[ -z "$conn" ]]; then
        local auth="-u${MYSQL_USER} -p${MYSQL_PASSWORD}"
        local out
        out="$(mysqladmin ${auth} status 2>/dev/null || true)"
        conn="$(echo "$out" | grep -oE 'Threads:[[:space:]]*[0-9]+' | awk '{print $2}')"
    fi

    if [[ -z "$conn" || ! "$conn" =~ ^[0-9]+$ ]]; then
        local auth="-u${MYSQL_USER} -p${MYSQL_PASSWORD}"
        local out2
        out2="$(mysql -ss ${auth} -e "SHOW STATUS LIKE 'Threads_connected';" 2>/dev/null | tail -n1 | cut -f2)"
        if [[ "$out2" =~ ^[0-9]+$ ]]; then
            conn="$out2"
        fi
    fi

    if [[ -z "$conn" || ! "$conn" =~ ^[0-9]+$ ]]; then
        log ERROR "[MySQL监测] $HOST_NAME => 获取连接数失败（请确认 Docker/MySQL 客户端与权限）"
        MYSQL_LAST_BURST_STATUS="ERROR"
        MYSQL_LAST_BURST_DESC="无法获取连接数"
        return
    fi

    MYSQL_LAST_CONN="$conn"

    local now_ts
    now_ts="$(date +%s)"

    MYSQL_SAMPLES=$((MYSQL_SAMPLES + 1))
    MYSQL_SUM_CONN=$((MYSQL_SUM_CONN + conn))
    if (( conn > MYSQL_PEAK_CONN )); then
        MYSQL_PEAK_CONN=$conn
        MYSQL_PEAK_TS="$now_ts"
    fi

    local avg_conn=$(( MYSQL_SUM_CONN / MYSQL_SAMPLES ))
    local peak_human="N/A"
    if [[ -n "$MYSQL_PEAK_TS" && "$MYSQL_PEAK_TS" != "0" ]]; then
        peak_human="$(date -d @"$MYSQL_PEAK_TS" '+%Y-%m-%d %H:%M:%S' 2>/dev/null || date '+%Y-%m-%d %H:%M:%S')"
    fi

    log INFO "[MySQL监测] $HOST_NAME 当前连接数=$conn 平均=${avg_conn} 峰值=${MYSQL_PEAK_CONN}@$peak_human"

    local window_seconds=300
    local min_burst_conn=200
    local rate_threshold_per_sec=1

    if [[ -z "${MYSQL_LAST_TOTAL:-}" || -z "${MYSQL_LAST_TS:-}" ]]; then
        MYSQL_LAST_TOTAL="$conn"
        MYSQL_LAST_TS="$now_ts"
        MYSQL_LAST_BURST_STATUS="INIT"
        MYSQL_LAST_BURST_DESC="初始化窗口，总连接数=${conn}"
        return
    fi

    local elapsed=$(( now_ts - MYSQL_LAST_TS ))
    (( elapsed <= 0 )) && elapsed=1
    local delta_conn=$(( conn - MYSQL_LAST_TOTAL ))
    (( delta_conn < 0 )) && delta_conn=0

    MYSQL_LAST_TOTAL="$conn"
    MYSQL_LAST_TS="$now_ts"

    if (( elapsed >= window_seconds )); then
        local rate
        rate=$(awk -v d="$delta_conn" -v e="$elapsed" 'BEGIN{ if(e<=0){e=1}; printf "%.2f", d/e }')
        local start_ts_human end_ts_human
        start_ts_human="$(date -d @"$((now_ts - elapsed))" '+%Y-%m-%d %H:%M:%S' 2>/dev/null || date '+%Y-%m-%d %H:%M:%S')"
        end_ts_human="$(date -d @"$now_ts"           '+%Y-%m-%d %H:%M:%S' 2>/dev/null || date '+%Y-%m-%d %H:%M:%S')"

        local desc="窗口=${elapsed}s 增量=${delta_conn} 速率=${rate}/s 时间段=[${start_ts_human} ~ ${end_ts_human}]"
        if (( delta_conn >= min_burst_conn )) || awk -v r="$rate" -v th="$rate_threshold_per_sec" 'BEGIN{exit !(r>=th)}'; then
            log WARN "[MySQL连接暴涨] $HOST_NAME ${desc}"
            MYSQL_LAST_BURST_STATUS="BURST"
            MYSQL_LAST_BURST_DESC="$desc"
        else
            log INFO "[MySQL暴涨审计] $HOST_NAME ${desc} 未发现暴涨"
            MYSQL_LAST_BURST_STATUS="OK"
            MYSQL_LAST_BURST_DESC="$desc"
        fi
    else
        MYSQL_LAST_BURST_STATUS="COLLECTING"
        MYSQL_LAST_BURST_DESC="窗口${elapsed}s/未达${window_seconds}s，当前连接数=${conn}"
    fi
}

#################### 3.5 容器信息检测 ####################

# 运行中容器信息
CONTAINER_RUNNING_LIST=""
# 未运行（包含退出、异常等状态）容器信息
CONTAINER_EXITED_LIST=""

collect_container_info() {
    # 如果 docker 不存在或不可用，直接记录信息后返回
    if ! command -v docker >/dev/null 2>&1; then
        log INFO "[容器检测] 本机未安装 docker 命令，跳过容器信息检测"
        CONTAINER_RUNNING_LIST="本机未检测到 docker 命令，无法获取容器信息。"
        CONTAINER_EXITED_LIST="本机未检测到 docker 命令，无法获取容器信息。"
        return
    fi

    # 运行中容器
    local running
    running="$(docker ps --format '{{.ID}}\t{{.Names}}\t{{.Image}}\t{{.Status}}\t{{.CreatedAt}}' 2>/dev/null || true)"
    if [[ -z "${running//[[:space:]]/}" ]]; then
        CONTAINER_RUNNING_LIST="当前无运行中的容器。"
    else
        CONTAINER_RUNNING_LIST="$running"
    fi

    # 未运行容器（包含 Exited、Created 等非 Up 状态）
    local exited
    exited="$(docker ps -a --filter 'status=exited' --format '{{.ID}}\t{{.Names}}\t{{.Image}}\t{{.Status}}\t{{.CreatedAt}}' 2>/dev/null || true)"
    if [[ -z "${exited//[[:space:]]/}" ]]; then
        # 如果没有 exited，再补充其它非 running 状态（防止所有都 paused/created 等）
        local not_running
        not_running="$(docker ps -a --format '{{.ID}}\t{{.Names}}\t{{.Image}}\t{{.Status}}\t{{.CreatedAt}}' | grep -v 'Up ' || true)"
        if [[ -z "${not_running//[[:space:]]/}" ]]; then
            CONTAINER_EXITED_LIST="当前无未运行的容器（没有 Exited/非 Up 状态的容器）。"
        else
            CONTAINER_EXITED_LIST="$not_running"
        fi
    else
        CONTAINER_EXITED_LIST="$exited"
    fi

    log INFO "[容器检测] 已采集容器信息：running=$(echo \"$CONTAINER_RUNNING_LIST\" | wc -l) 行，exited=$(echo \"$CONTAINER_EXITED_LIST\" | wc -l) 行"
}

# 判断 mailx 是否支持用 -a 添加自定义头（s-nail/mailx 常见）
mailx_supports_a_header() {
    if ! command -v mailx >/dev/null 2>&1; then
        return 1
    fi

    # 用 -V / -v 尝试识别 s-nail 关键字（不同发行版输出不同，做一个宽松判断）
    if mailx -V 2>&1 | grep -qiE 's-nail|heirloom'; then
        # s-nail 一般支持 -a header；heirloom 常把 -a 当附件（不可靠）
        if mailx -V 2>&1 | grep -qi 's-nail'; then
            return 0
        fi
        return 1
    fi

    # 兜底：看帮助里是否明确出现 “-a header”
    mailx -h 2>&1 | grep -qiE '(\-a[[:space:]]+header|\-a[[:space:]]+.*header)'
}

ensure_sendmail_installed() {
    if command -v sendmail >/dev/null 2>&1; then
        log INFO "[依赖检查] sendmail 已安装"
        return 0
    fi

    local pkg_mgr
    pkg_mgr="$(detect_os_and_pkg_mgr)"
    log INFO "[依赖安装] 尝试安装 sendmail/postfix，pkg_mgr=${pkg_mgr}"

    if [[ "$pkg_mgr" == "yum" ]]; then
        yum install -y postfix >>"$LOG_FILE" 2>&1 || return 1
        systemctl enable --now postfix >>"$LOG_FILE" 2>&1 || true
    elif [[ "$pkg_mgr" == "apt" ]]; then
        apt-get update >>"$LOG_FILE" 2>&1 || true
        apt-get install -y postfix >>"$LOG_FILE" 2>&1 || return 1
        systemctl enable --now postfix >>"$LOG_FILE" 2>&1 || true
    else
        log ERROR "[依赖安装] 未识别包管理器，无法自动安装 postfix"
        return 1
    fi

    command -v sendmail >/dev/null 2>&1 && log INFO "[依赖安装] sendmail 安装完成"
}

#################### 3.6 硬盘空间检测 ####################
DISK_SAMPLES=0
DISK_SUM_USED_PCT=0
DISK_PEAK_USED_PCT=0
DISK_PEAK_TS=0
DISK_LAST_USED_PCT=0

# 额外保存：df -P 原始输出文件（用于解析计算）
DISK_DF_RAW_FILE=""
DISK_DF_FILE=""

# ✅ 新增：避免 set -u 下“未绑定变量”
DISK_LAST_DF_TEXT=""

# 取根分区 / 的使用率（最稳定：不依赖 df 输出文件/复杂解析）
get_root_disk_used_pct() {
    if ! command -v df >/dev/null 2>&1; then
        return 1
    fi

    # df -P / 的输出一般为两行：表头 + 数据行，Use% 在第5列
    df -P / 2>/dev/null | awk 'NR==2 { gsub(/%/,"",$5); print $5 }'
}

# 返回当前磁盘最大使用率（整数），并把 df 文件保存到 DISK_DF_FILE / DISK_DF_RAW_FILE
get_disk_used_pct_max() {
    collect_disk_df_to_file || true

    # 读展示文件前 15 行用于日志展示
    if [[ -n "${DISK_DF_FILE:-}" && -f "${DISK_DF_FILE:-}" ]]; then
        DISK_LAST_DF_TEXT="$(head -n 15 "$DISK_DF_FILE" 2>/dev/null || true)"
    else
        DISK_LAST_DF_TEXT=""
    fi

    # 用 df -P 文件解析 Use%（第5列）
    if [[ -z "${DISK_DF_RAW_FILE:-}" || ! -f "${DISK_DF_RAW_FILE:-}" ]]; then
        return 1
    fi

    local max
    max="$(awk '
        # 跳过我们自己写的 3 行头（##/PATH/空行），再跳过 df 表头
        /^## / { next }
        /^PATH=/ { next }
        NF==0 { next }
        NR==1 { next }
        {
          u=$5
          gsub(/%/,"",u)
          if (u ~ /^[0-9]+$/) {
            if (u > m) m=u
          }
        }
        END{
          if (m=="") exit 1
          print m
        }' "$DISK_DF_RAW_FILE" 2>/dev/null || true)"

    [[ -n "$max" && "$max" =~ ^[0-9]+$ ]] || return 1
    echo "$max"
    return 0
}

monitor_disk_once() {
    local used_pct
    used_pct="$(get_root_disk_used_pct || true)"

    if [[ -z "$used_pct" || ! "$used_pct" =~ ^[0-9]+$ ]]; then
        log ERROR "[硬盘监测] $HOST_NAME => 获取根分区(/)使用率失败（df 不可用或解析失败）"
        return
    fi

    DISK_LAST_USED_PCT="$used_pct"
    DISK_SAMPLES=$((DISK_SAMPLES + 1))
    DISK_SUM_USED_PCT=$((DISK_SUM_USED_PCT + used_pct))

    if (( used_pct > DISK_PEAK_USED_PCT )); then
        DISK_PEAK_USED_PCT="$used_pct"
        DISK_PEAK_TS="$(date +%s)"
    fi

    local avg_used_pct=$(( DISK_SUM_USED_PCT / DISK_SAMPLES ))
    local peak_human="N/A"
    if [[ -n "${DISK_PEAK_TS}" && "${DISK_PEAK_TS}" != "0" ]]; then
        peak_human="$(date -d @"$DISK_PEAK_TS" '+%Y-%m-%d %H:%M:%S' 2>/dev/null || date '+%Y-%m-%d %H:%M:%S')"
    fi

    local warn_threshold=90
    if (( used_pct >= warn_threshold )); then
        log WARN "[硬盘监测] $HOST_NAME 根分区(/)使用率偏高：当前=${used_pct}% 平均=${avg_used_pct}% 峰值=${DISK_PEAK_USED_PCT}%@${peak_human}"
    else
        log INFO "[硬盘监测] $HOST_NAME 根分区(/)当前使用率=${used_pct}% 平均=${avg_used_pct}% 峰值=${DISK_PEAK_USED_PCT}%@${peak_human}"
    fi
}

# 简单把 Markdown 报告转成 HTML（够用：标题/列表/代码/表格）
md_to_html_simple() {
    local report_file="$1"

    # 用 awk 处理 Markdown 表格 + 普通行，其它用 sed 做基础替换
    # 注意：这是“可读性优先”的轻量转换器，不追求完整 Markdown 语法覆盖。
    awk '
    function html_escape(s,   t) {
        t=s
        gsub(/&/,"&amp;",t); gsub(/</,"&lt;",t); gsub(/>/,"&gt;",t)
        return t
    }
    function trim(s){ sub(/^[ \t\r\n]+/,"",s); sub(/[ \t\r\n]+$/,"",s); return s }

    BEGIN{
        in_table=0
        print "<html><head><meta charset=\"utf-8\"></head>"
        print "<body style=\"font-family:Segoe UI,Microsoft YaHei,Arial,sans-serif;color:#111;\">"
        print "<div style=\"max-width:980px;margin:0 auto;\">"
    }

    # 表格分隔行：| --- | --- |
    function is_table_sep(line) {
        return (line ~ /^\|[ \t]*[-: ]+[ \t]*\|/)
    }
    function is_table_row(line) {
        return (line ~ /^\|.*\|[ \t]*$/)
    }

    function start_table(header_line) {
        in_table=1
        print "<table border=\"1\" cellpadding=\"6\" cellspacing=\"0\" style=\"border-collapse:collapse;margin:8px 0;font-size:13px;\">"
        print "<thead><tr>"
        split(header_line, a, "|")
        for (i=2; i<=length(a)-1; i++){
            h=trim(a[i])
            print "<th style=\"background:#f3f4f6;\">" html_escape(h) "</th>"
        }
        print "</tr></thead><tbody>"
    }
    function table_row(line) {
        print "<tr>"
        split(line, a, "|")
        for (i=2; i<=length(a)-1; i++){
            c=trim(a[i])
            print "<td>" html_escape(c) "</td>"
        }
        print "</tr>"
    }
    function end_table() {
        if(in_table){
            print "</tbody></table>"
            in_table=0
        }
    }

    {
        line=$0

        # 空行
        if (line ~ /^[ \t]*$/) {
            end_table()
            print "<div style=\"height:8px;\"></div>"
            next
        }

        # 表格处理：header + separator + body
        if (!in_table && is_table_row(line)) {
            header=line
            getline sep
            if (is_table_sep(sep)) {
                start_table(header)
                # 读取 body 行（可能 0..n 行）
                while (getline body_line) {
                    if (!is_table_row(body_line)) { 
                        # 非表格行，回退给后续处理：awk 没回退机制，只能先处理并继续
                        end_table()
                        line=body_line
                        break
                    }
                    table_row(body_line)
                }
                # 这里 line 可能是表格后第一行（非表格），继续走下面普通行逻辑
                if (in_table==0 && line !~ /^\|.*\|[ \t]*$/) {
                    # fallthrough
                } else {
                    next
                }
            } else {
                # 不是标准表格，按普通行处理（sep 行也要输出）
                end_table()
                print "<div style=\"line-height:1.6;\">" html_escape(header) "</div>"
                print "<div style=\"line-height:1.6;\">" html_escape(sep) "</div>"
                next
            }
        }

        end_table()

        # 标题
        if (substr(line,1,2)=="# ") {
            print "<h1>" html_escape(substr(line,3)) "</h1>"
            next
        }
        if (substr(line,1,3)=="## ") {
            print "<h2>" html_escape(substr(line,4)) "</h2>"
            next
        }
        if (substr(line,1,4)=="### ") {
            print "<h3>" html_escape(substr(line,5)) "</h3>"
            next
        }

        # 列表项（简单）
        if (line ~ /^- /) {
            # 开启列表块（用一个很简化的方式：遇到 - 就开始 UL，直到遇到非 - 行或空行）
            print "<ul style=\"margin:6px 0 12px 18px;\">"
            do {
                item=substr(line,3)
                print "<li style=\"line-height:1.6;\">" html_escape(item) "</li>"
                if (getline nxt) {
                    if (nxt ~ /^- /) { line=nxt; continue }
                    else { line=nxt; break }
                } else { line=""; break }
            } while (1)
            print "</ul>"
            if (line=="") next
            # 继续处理 line（当前是列表后第一行）
        }

        # 普通段落
        print "<div style=\"line-height:1.6;white-space:pre-wrap;\">" html_escape(line) "</div>"
    }

    END{
        end_table()
        print "<hr/>"
        print "<div style=\"color:#6b7280;font-size:12px;\">说明：本邮件正文为自动化监测报告的 HTML 展示版；原始 Markdown 报告请查看落盘文件。</div>"
        print "</div></body></html>"
    }' "$report_file"
}

# ✅ 取本机“主IP”（优先走路由默认出口；取不到再 fallback 到 hostname -I）
get_primary_ip() {
    local ip=""
    if command -v ip >/dev/null 2>&1; then
        ip="$(ip route get 1 2>/dev/null | awk '{for(i=1;i<=NF;i++){if($i=="src"){print $(i+1); exit}}}')"
    fi
    if [[ -z "$ip" ]] && command -v hostname >/dev/null 2>&1; then
        ip="$(hostname -I 2>/dev/null | awk '{print $1}')"
    fi
    echo "${ip:-unknown-ip}"
}

#################### 6. 邮件发送 ####################
# 尝试发送邮件，把生成的 MD 报告作为正文发送
send_report_mail() {
    local report_md="$1"

    if [[ ! -f "$report_md" ]]; then
        log ERROR "[邮件发送] 报告文件不存在：$report_md"
        return 1
    fi

    if ! command -v mailx >/dev/null 2>&1 && ! command -v mail >/dev/null 2>&1; then
        log ERROR "[邮件发送] 未找到 mailx/mail，无法发送邮件"
        return 1
    fi

    # ✅ 标题改成：【内部】+服务器IP+时间
    local server_ip
    server_ip="$(get_primary_ip)"
    local subject="${MAIL_SUBJECT_PREFIX}${server_ip} - $(date '+%Y-%m-%d %H:%M:%S')"

    # 收件人：逗号转空格，兼容性更好
    local to="${MAIL_TO}"
    to="${to//,/ }"

    log INFO "[邮件发送] 使用 mailx(SMTP) 发送纯文本报告给：$to"

    # 用 mailx 发送纯文本（依赖 /etc/mail.rc 的 smtp 配置）
    # 注意：有的系统只有 mail 没有 mailx，因此做二选一
    if command -v mailx >/dev/null 2>&1; then
        mailx -s "$subject" $to < "$report_md" || {
            log ERROR "[邮件发送] mailx(SMTP) 发送失败"
            return 1
        }
    else
        mail -s "$subject" $to < "$report_md" || {
            log ERROR "[邮件发送] mail(SMTP) 发送失败"
            return 1
        }
    fi

    return 0
}

#################### 5. 报告输出（md） ####################
write_md_report() {
    mkdir -p "$REPORT_DIR" 2>/dev/null || true

    local ts file_ts report_file
    ts="$(date '+%Y-%m-%d %H:%M:%S')"
    file_ts="$(date '+%Y%m%d_%H%M%S')"
    report_file="${REPORT_DIR}/monitor_report_${HOST_NAME}_${file_ts}.md"

    local platform_text
    if [[ "$PLATFORM_TYPE" == "new" ]]; then
        platform_text="新统一平台 (/data/services)"
    else
        platform_text="传统平台 (/var/www)"
    fi

    local systems_text="无"
    ((${#SYSTEMS[@]} > 0)) && systems_text="${SYSTEMS[*]}"

    local mem_avg_used="N/A"
    (( MEM_SAMPLES > 0 )) && mem_avg_used=$(( MEM_SUM_USED_MB / MEM_SAMPLES ))

    local mem_peak_time="N/A"
    if [[ "$MEM_PEAK_TS" != "0" && -n "$MEM_PEAK_TS" ]]; then
        mem_peak_time="$(date -d @"$MEM_PEAK_TS" '+%Y-%m-%d %H:%M:%S' 2>/dev/null || date '+%Y-%m-%d %H:%M:%S')"
    fi

    local mysql_avg_conn="N/A"
    (( MYSQL_SAMPLES > 0 )) && mysql_avg_conn=$(( MYSQL_SUM_CONN / MYSQL_SAMPLES ))

    local mysql_peak_time="N/A"
    if [[ -n "$MYSQL_PEAK_TS" && "$MYSQL_PEAK_TS" != "0" ]]; then
        mysql_peak_time="$(date -d @"$MYSQL_PEAK_TS" '+%Y-%m-%d %H:%M:%S' 2>/dev/null || date '+%Y-%m-%d %H:%M:%S')"
    fi

    # 新增：硬盘统计
    local disk_avg_used="N/A"
    (( DISK_SAMPLES > 0 )) && disk_avg_used=$(( DISK_SUM_USED_PCT / DISK_SAMPLES ))

    local disk_peak_time="N/A"
    if [[ -n "${DISK_PEAK_TS:-}" && "${DISK_PEAK_TS:-0}" != "0" ]]; then
        disk_peak_time="$(date -d @"$DISK_PEAK_TS" '+%Y-%m-%d %H:%M:%S' 2>/dev/null || date '+%Y-%m-%d %H:%M:%S')"
    fi

    {
        echo "# 自动化服务监测报告"
        echo
        echo "- 生成时间：${ts}"
        echo "- 主机名：${HOST_NAME}"
        echo "- 平台类型：${platform_text}"
        echo "- 系统识别：ujava=${HAS_UJAVA}，upython=${HAS_UPYTHON}，upython_voice=${HAS_UPYTHON_VOICE}"
        echo "- 系统列表：${systems_text}"
        echo
        echo "## 一、日志审计概览（仅暴涨情况，不含 ERROR 详情）"
        echo
        if ((${#LOG_TARGET_SYS[@]} == 0)); then
            echo "- 当前未匹配到需要审计的日志目标（例如未识别到会议预定系统 ujava 容器）。"
        else
            for ((i=0; i<${#LOG_TARGET_SYS[@]}; i++)); do
                local sys_name="${LOG_TARGET_SYS[$i]}"
                local log_path="${LOG_TARGET_PATH[$i]}"
                local key
                key="$(make_log_key "$sys_name" "$log_path")"

                local burst_status="${BURST_LAST_RESULT[$key]-未采集}"
                local burst_desc="${BURST_LAST_DESC[$key]-无}"

                echo "### 日志：${sys_name}"
                echo
                echo "- 日志路径：\`${log_path}\`"
                echo "- 日志暴涨状态：**${burst_status}**"
                echo "- 日志暴涨详情：${burst_desc}"
                echo
            done
        fi

        echo "## 二、内存资源消耗"
        echo
        echo "- 当前内存使用：${MEM_LAST_USED_MB} MB"
        echo "- 内存使用平均值：${mem_avg_used} MB"
        echo "- 内存使用峰值：${MEM_PEAK_USED_MB} MB"
        echo "- 峰值发生时间：${mem_peak_time}"
        echo
        echo "## 三、MySQL 连接数监测"
        echo
        echo "- 当前 MySQL 连接数：${MYSQL_LAST_CONN}"
        echo "- MySQL 连接平均值：${mysql_avg_conn}"
        echo "- MySQL 连接峰值：${MYSQL_PEAK_CONN}"
        echo "- 峰值发生时间：${mysql_peak_time}"
        echo "- 最近暴涨判定状态：**${MYSQL_LAST_BURST_STATUS}**"
        echo "- 暴涨详情：${MYSQL_LAST_BURST_DESC}"
        echo

        # 新增：硬盘空间
        echo "## 四、硬盘空间检测"
        echo
        echo "- 当前硬盘使用率（根分区 / ）：${DISK_LAST_USED_PCT}%"
        echo "- 硬盘使用率平均值：${disk_avg_used}%"
        echo "- 硬盘使用率峰值：${DISK_PEAK_USED_PCT}%"
        echo "- 峰值发生时间：${disk_peak_time}"
        echo
        echo "> 说明：为保证稳定性，当前仅采集根分区(/)的使用率，不再采集/输出 df 详细列表。"
        echo

        # 原来的容器章节顺延编号
        echo "## 五、容器信息检测"
        echo
        echo "### 5.1 运行中的容器"
        echo
        if [[ -z "${CONTAINER_RUNNING_LIST//[[:space:]]/}" ]]; then
            echo "- 未采集到运行中的容器信息。"
        else
            echo "| 容器ID | 名称 | 镜像 | 状态 | 创建时间 |"
            echo "| ------ | ---- | ---- | ---- | -------- |"
            echo "$CONTAINER_RUNNING_LIST" | while IFS=$'\t' read -r cid cname cimg cstatus ctime; do
                [[ -z "${cid}${cname}${cimg}${cstatus}${ctime}" ]] && continue
                echo "| ${cid} | ${cname} | ${cimg} | ${cstatus} | ${ctime} |"
            done
        fi
        echo
        echo "### 5.2 未运行的容器（Exited/其它非 Up 状态）"
        echo
        if [[ -z "${CONTAINER_EXITED_LIST//[[:space:]]/}" ]]; then
            echo "- 未采集到未运行的容器信息。"
        else
            echo "| 容器ID | 名称 | 镜像 | 状态 | 创建时间 |"
            echo "| ------ | ---- | ---- | ---- | -------- |"
            echo "$CONTAINER_EXITED_LIST" | while IFS=$'\t' read -r cid cname cimg cstatus ctime; do
                [[ -z "${cid}${cname}${cimg}${cstatus}${ctime}" ]] && continue
                echo "| ${cid} | ${cname} | ${cimg} | ${cstatus} | ${ctime} |"
            done
        fi
        echo
        echo "> 说明：本报告由 \`AutomatedServiceMonitoring.sh\` 自动生成，仅反映本次执行时刻的监测结果（当前版本未启用 ERROR 上下文分析）。"
        echo
    } > "$report_file"

    echo "$report_file"
}

#################### 主流程：单次执行 ####################
main_run_once() {
    log INFO "[启动] 自动化服务监测 Shell 脚本（单次执行模式），目标服务器(本机)=${HOST_NAME}"

    # 0. 环境准备：只处理邮件依赖和配置
    ensure_mailx_installed || log ERROR "[启动] mailx 安装失败，后续邮件发送可能不可用。"
    ensure_mailx_smtp_config || log ERROR "[启动] mailx SMTP 配置生成失败，后续邮件发送可能不可用。"
    # 新增：确保 sendmail 可用（用于发送 HTML 邮件）
    ensure_sendmail_installed || log WARN "[启动] sendmail 安装失败，将回退纯文本邮件（排版不可优化）。"

    detect_platform
    detect_systems

    local platform_text
    if [[ "$PLATFORM_TYPE" == "new" ]]; then
        platform_text="新统一平台(/data/services)"
    else
        platform_text="传统平台(/var/www)"
    fi

    log INFO "[平台识别] $HOST_NAME => 平台类型=${platform_text} 基路径=${BASE_PATH}"
    log INFO "[系统识别] $HOST_NAME => ujava=${HAS_UJAVA} upython=${HAS_UPYTHON} upython_voice=${HAS_UPYTHON_VOICE} 系统=(${SYSTEMS[*]:-无})"
    log INFO "[心跳] $HOST_NAME: 平台=$([[ "$PLATFORM_TYPE" == "new" ]] && echo 新 || echo 旧) 基路径=${BASE_PATH} 系统=${SYSTEMS[*]:-无}"

    resolve_log_targets
    for ((i=0; i<${#LOG_TARGET_SYS[@]}; i++)); do
        local sys_name="${LOG_TARGET_SYS[$i]}"
        local log_path="${LOG_TARGET_PATH[$i]}"
        monitor_log_burst_once "$sys_name" "$log_path"
    done

    monitor_mem_once
    monitor_mysql_once
    collect_container_info

    # 新增：硬盘空间检测（3.6）
    monitor_disk_once

    # 生成报告，并获取报告文件路径（md）
    local report_file
    report_file="$(write_md_report)"

    # 6. 邮件发送（注意：这里要传 report_file，而不是未定义的 REPORT_MD_FILE）
    send_report_mail "$report_file" || {
        log ERROR "[主流程] 报告已生成，但邮件发送失败，请检查日志和邮件客户端配置。"
    }

    # 7. 发送钉钉通知（文本摘要）
#     local now_time
#     now_time="$(date '+%Y-%m-%d %H:%M:%S')"

#     # 汇总整体状态：有暴涨/错误就判为异常
#     local overall_status="正常"
#     local overall_emoji="✅"

#     # 日志暴涨是否异常
#     local any_log_bad=0
#     for key in "${!BURST_LAST_RESULT[@]}"; do
#         case "${BURST_LAST_RESULT[$key]}" in
#             BURST|ERROR)
#                 any_log_bad=1
#                 break
#                 ;;
#         esac
#     done

#     # MySQL 是否暴涨/错误
#     local mysql_bad=0
#     case "$MYSQL_LAST_BURST_STATUS" in
#         BURST|ERROR)
#             mysql_bad=1
#             ;;
#     esac

#     if (( any_log_bad == 1 || mysql_bad == 1 )); then
#         overall_status="异常"
#         overall_emoji="❌"
#     fi

#     local dd_text
#     dd_text="【监控】${HOST_NAME} - ${overall_status}${overall_emoji}
# 触发时间：${now_time}

# 监控概览：
# - 日志审计：${BURST_LAST_DESC[*]:-未采集}
# - 内存：当前 ${MEM_LAST_USED_MB} MB，峰值 ${MEM_PEAK_USED_MB} MB
# - MySQL：当前连接数 ${MYSQL_LAST_CONN}，峰值 ${MYSQL_PEAK_CONN}，暴涨状态：${MYSQL_LAST_BURST_STATUS}
# - 容器：运行中 $(echo \"$CONTAINER_RUNNING_LIST\" | wc -l) 个，未运行 $(echo \"$CONTAINER_EXITED_LIST\" | wc -l) 个

# 系统监控告警通知"

#     DD_TEXT="$dd_text" send_dingtalk_markdown || {
#         log ERROR "[主流程] 报告已生成，但钉钉发送失败，请检查 DINGDING_ACCESS_TOKEN / SECRET 配置。"
#     }

        log INFO "[结束] 本次监测已完成，报告已生成并尝试发送邮件与钉钉通知。"
}

#################### 脚本入口 ####################
main_run_once