# 常见问题处理脚本操作说明文档

## 概述

本文档旨在指导用户如何使用 [issue_handler.sh]脚本来处理Linux服务器上的常见问题。该脚本支持交互式操作和命令行参数两种使用方式，可以帮助用户快速解决诸如版本包更新、权限修复、配置文件修改等常见问题。

## 脚本功能

该脚本提供以下主要功能：

1. **更新版本包**：支持更新对内后端、对外后端、前台、后台、运维后端和运维前端等版本包
2. **修复文件权限问题**：自动修复常见文件权限问题，包括数据库用户权限、nginx用户权限等
3. **修复配置文件IP地址问题**：批量替换配置文件中的IP地址
4. **系统磁盘问题处理**：包括四个子功能：
   - 清理已删除但未释放的文件
   - 轮转过大的日志文件
   - 清理数据库system_log表中30天前的历史数据
   - 磁盘分区调整参考指南（高风险操作，仅提供手动处理步骤）
5. **日志导出与压缩**：导出系统日志并压缩为zip或tar.gz文件
6. **服务异常处理**：修复对外后端服务异常掉线问题
7. **NTP服务配置**：修复NTP服务配置或启动问题
8. **端口开放检查**：检查并开放必要端口
9. **DNS异常修复**：修复服务器DNS配置异常问题
10. **环境数据备份**：打包备份系统环境数据，包括配置文件、日志文件和系统信息
11. **定时清理任务**：支持通过cron定时清理已删除但未释放的文件

## 系统要求

- Linux操作系统（支持大多数主流发行版，如CentOS、Ubuntu、Debian等）
- Bash shell环境（大部分Linux系统默认包含）
- root或sudo权限（强烈建议以root权限运行以确保所有操作都能正常执行）
- 部分功能可能需要额外的系统工具，如lsof、zip等（脚本会自动检测并在需要时提示安装）

## 脚本安装与准备

1. 确保脚本具有执行权限：
   ```bash
   chmod +x issue_handler.sh
   ```

2. （可选）将脚本放置在系统PATH路径中，方便全局调用：
   ```bash
   sudo cp issue_handler.sh /usr/local/bin/
   ```

## 使用方式

### 1. 交互式模式（推荐，特别适合非技术人员）

这是最简单的使用方式，只需按照屏幕上的菜单提示逐步操作即可。

直接运行脚本进入交互式模式：
```bash
sudo ./issue_handler.sh
```

执行后会出现一个菜单界面，通过输入数字选择对应的功能。例如：
- 输入 `1` 可以更新版本包
- 输入 `4` 可以处理磁盘相关问题
- 输入 `0` 可以退出脚本

对于有子菜单的选项（如选项1和4），选择后会显示更详细的子菜单，继续输入对应的数字即可。

在整个操作过程中：
- 脚本会在关键步骤提示您确认操作，您可以选择 `y`（是）或 `N`（否）
- 所有操作都会有明确的成功或失败提示
- 操作完成后会显示操作结果摘要

### 2. 命令行模式（高级用户使用）

如果您熟悉命令行操作，也可以通过命令行参数直接执行特定功能：
```bash
sudo ./issue_handler.sh --action <action_name>
```

可用的 `<action_name>` 包括：
- `update_packages`：更新所有版本包
- `fix_permissions`：修复文件权限
- `fix_ip_configs`：修复IP配置
- `clean_deleted_files`：清理已删除文件
- `clean_deleted_files_cron`：定时任务版本的清理已删除文件（无交互）
- `rotate_logs`：轮转日志文件
- `export_logs`：导出日志文件
- `fix_external_service`：修复对外服务异常
- `fix_ntp`：修复NTP配置
- `fix_ports`：检查端口开放情况
- `fix_dns`：修复DNS配置

例如，要修复文件权限问题，可以执行：
```bash
sudo ./issue_handler.sh --action fix_permissions
```

要执行定时清理任务（无交互），可以执行：
```bash
sudo ./issue_handler.sh --action clean_deleted_files_cron
```

**注意**：命令行模式适合高级用户或自动化任务，普通用户建议使用交互式模式。

## 详细功能说明

### 更新版本包

#### 工作原理
脚本会优先检查脚本所在目录是否存在对应的更新包目录，如果存在则直接使用，否则提示用户输入更新包路径。

#### 操作步骤
1. 运行脚本并选择更新版本包相关选项
2. 脚本会自动检测更新包位置：
   - 首先检查脚本所在目录是否存在同名更新包目录
   - 如果不存在，提示用户输入更新包所在目录
3. 用户确认后，脚本会：
   - 备份原文件/目录内容
   - 执行更新操作
   - 提供操作结果反馈

#### 注意事项
- 更新包目录应包含需要更新的完整文件结构
- 脚本会自动备份原文件/目录内容，备份文件名带有时间戳
- 如更新失败，脚本会尝试恢复备份文件
- 对于目录类型的更新（如前端、后台包），脚本会：
  1. 在目标目录下创建一个备份目录，将index.html和static等文件移进到备份目录
  2. 将更新包中的文件复制到目标目录下

### 修复文件权限问题

#### 功能说明
自动修复系统中常见的文件权限问题，包括：
- 启动脚本权限（通常设置为755）
- 配置文件权限（通常设置为644）
- 数据库和nginx相关权限

#### 操作步骤
1. 选择对应的权限修复选项
2. 脚本会自动检测平台类型（新统一平台或标准版平台）
3. 根据平台类型修复对应的文件权限

### 修复配置文件IP地址问题

#### 功能说明
批量替换系统配置文件中的IP地址。

#### 操作步骤
1. 选择"修复配置文件IP不对问题"选项
2. 输入需要替换的旧IP地址
3. 输入新的IP地址
4. 脚本会自动查找并替换所有相关配置文件中的IP地址

### 系统磁盘问题处理

#### 功能说明
包括四个子功能：
1. 清理已删除但未释放的文件
2. 轮转过大的日志文件
3. 清理数据库system_log表中30天前的历史数据
4. 磁盘分区调整参考指南（高风险操作，仅提供手动处理步骤）

#### 操作步骤
1. 在主菜单中输入 `4` 并按回车进入系统磁盘问题处理菜单
2. 根据需要选择子功能：
   - `4.1` 清理已删除文件：自动检测并清理已删除但仍在被进程占用的文件
   - `4.2` 轮转日志文件：检查并轮转超过100MB的日志文件
   - `4.3` 清理数据库system_log表：清理数据库中30天前的历史数据
   - `4.4` 磁盘分区调整参考：显示磁盘分区调整的详细步骤和注意事项

3. 根据屏幕提示进行确认操作
4. 脚本会自动执行相关处理并显示操作结果摘要

#### 注意事项
- 功能4.4（磁盘分区调整）属于高风险操作，脚本仅提供参考指南，不自动执行
- 在执行清理数据库操作前，脚本会要求输入数据库密码并确认操作
- 所有操作都有详细日志记录，可在日志文件中查看完整过程

### 日志导出与压缩

#### 功能说明
导出系统中的重要日志文件并压缩为zip文件，便于传输和分析。

#### 操作步骤
1. 选择"导出现场日志文件并压缩"选项
2. 脚本会自动收集日志并生成带时间戳的zip文件

### 服务异常处理

#### 功能说明
修复对外后端服务异常掉线问题。

#### 操作步骤
1. 选择对应选项
2. 根据提示确认是否添加必要的配置项
3. 确认是否启动服务

### NTP服务配置

#### 功能说明
修复NTP服务配置或启动问题。

#### 操作步骤
1. 选择对应选项
2. 根据提示确认是否添加必要的配置项
3. 确认是否重启NTP服务

### 端口开放检查

#### 功能说明
检查系统必要端口是否开放。

#### 操作步骤
1. 选择对应选项
2. 脚本会显示需要开放的端口列表
3. 用户需手动检查并确保端口已正确开放

### DNS异常修复

#### 功能说明
修复服务器DNS配置异常问题。

#### 操作步骤
1. 选择对应选项
2. 脚本会检查DNS配置文件
3. 如未配置推荐的DNS服务器，会提示用户添加

### 环境数据备份

#### 功能说明
打包备份系统环境数据，包括配置文件、日志文件和系统信息。

#### 操作步骤
1. 选择"打包备份现场环境数据"选项（菜单选项10）
2. 脚本会自动检测平台类型
3. 根据平台类型备份相应的配置文件、日志文件和系统信息
4. 生成包含时间戳的tar.gz压缩包

### 定时清理任务

#### 功能说明
支持通过cron定时清理已删除但未释放的文件，适用于自动化运维场景。

#### 操作步骤
1. 通过命令行模式执行：
   ```bash
   sudo ./issue_handler.sh --action clean_deleted_files_cron
   ```
2. 脚本会自动检测并清理已删除但未释放的文件
3. 无交互过程，适合定时任务执行

## 安全机制

为了保护您的系统和数据安全，脚本内置了多种安全机制：

1. **权限检查**：脚本运行时会检查是否具有足够的权限执行操作，如果没有会给出明确提示

2. **文件备份**：在修改任何重要文件之前，脚本会自动创建备份文件，文件名包含操作时间和日期，如 `filename_backup_20231201_120000`

3. **操作确认**：对于可能影响系统运行的重要操作（如删除文件、重启服务等），脚本会询问您的确认，您可以选择继续或取消操作

4. **错误恢复**：如果某个操作失败，脚本会尝试恢复到操作之前的状态，最大程度保护您的数据

5. **路径验证**：在执行任何文件操作之前，脚本会验证目标路径的有效性，避免误操作

6. **日志记录**：所有操作都会详细记录到日志文件中，包括操作时间、操作内容、成功或失败状态等，便于后续查询和问题排查

7. **高风险操作保护**：对于特别危险的操作（如磁盘分区调整），脚本不会自动执行，仅提供详细的操作指南和注意事项供您参考

## 故障排除

如果您在使用过程中遇到问题，请参考以下解决方案：

### 常见问题

1. **脚本无执行权限**
   **问题表现**：运行脚本时提示 "Permission denied"
   **解决方法**：
   ```bash
   chmod +x issue_handler.sh
   ```

2. **操作被拒绝**
   **问题表现**：执行操作时提示权限不足或被拒绝
   **解决方法**：确保以root权限运行脚本
   ```bash
   sudo ./issue_handler.sh
   ```

3. **找不到lsof或zip命令**
   **问题表现**：执行某些功能时提示缺少相关命令
   **解决方法**：安装相应的工具包：
   ```bash
   # CentOS/RHEL/Fedora
   yum install lsof zip
   
   # Ubuntu/Debian
   apt-get install lsof zip
   ```

4. **数据库连接失败**
   **问题表现**：执行数据库清理操作时提示连接失败
   **解决方法**：
   - 确认数据库服务正在运行
   - 确认输入的数据库密码正确
   - 如果问题持续存在，请联系DBA或技术支持

5. **磁盘空间不足**
   **问题表现**：执行备份或导出操作时提示空间不足
   **解决方法**：
   - 清理不必要的文件释放空间
   - 选择性执行磁盘清理功能（选项4）
   - 联系系统管理员扩展磁盘空间

### 日志查看

脚本执行过程中会输出详细的操作日志，包括：
- [INFO]：一般信息，表示正常操作步骤
- [WARN]：警告信息，表示需要注意但不影响继续执行的情况
- [ERROR]：错误信息，表示操作失败或遇到问题
- [DEBUG]：调试信息，用于技术排查

日志文件位于脚本同级目录，文件名为`issue_handler.log`。

**非技术人员查看日志的方法**：
1. 使用文本编辑器打开 `issue_handler.log` 文件
2. 查看最后几行日志，特别是标记为 [ERROR] 的行
3. 如果需要技术支持，请将最近一段时间的日志内容复制给技术人员

### 需要技术支持时应该提供什么信息

当您需要寻求技术支持时，请尽量提供以下信息：
1. 您执行了什么操作（在菜单中选择了哪个选项）
2. 屏幕上显示了什么错误信息
3. 日志文件 `issue_handler.log` 中的相关内容
4. 您的系统环境（如操作系统版本等）

## 最佳实践

为了让您更好地使用该脚本，以下是一些建议：

### 对于非技术人员的特别建议

1. **首次使用必读**：
   - 请务必使用交互式模式（直接运行 `sudo ./issue_handler.sh`）
   - 仔细阅读屏幕上的每一个提示信息
   - 在不确定操作后果时，请咨询有经验的技术人员

2. **操作前的准备工作**：
   - 确保您具有root权限（可以使用 `sudo` 命令）
   - 确保脚本具有执行权限（可以运行 `chmod +x issue_handler.sh`）
   - 如果可能，在重要操作前手动备份关键数据

3. **操作过程中的注意事项**：
   - 当看到 `y/N` 提示时，输入 `y` 表示确认操作，输入 `N` 或直接按回车表示取消操作
   - 如果不小心选择了错误的选项，大多数操作都可以通过输入 `N` 来取消
   - 注意查看操作完成后的结果摘要，确认操作是否成功

4. **操作完成后的检查**：
   - 查看操作结果摘要，确认操作状态（成功、失败或取消）
   - 如果出现问题，可以查看日志文件 `issue_handler.log` 获取详细信息
   - 如果需要技术支持，提供日志文件中的相关信息会有助于问题解决

### 通用建议

1. **定期执行**：可以定期运行磁盘清理、日志轮转等功能，保持系统良好运行状态

2. **备份重要数据**：虽然脚本会自动备份操作涉及的文件，但对于业务数据仍建议单独备份

3. **关注日志输出**：仔细查看脚本执行过程中的日志信息，及时发现问题

4. **定时清理任务**：可以将`clean_deleted_files_cron`功能加入crontab，实现定时清理：
   ```bash
   # 每天凌晨3点执行清理已删除但未释放的文件
   0 3 * * * /bin/bash {脚本所在目录}/issue_handler.sh --action clean_deleted_files_cron
   ```

### 常见使用场景示例

1. **系统运行缓慢**：
   - 可能是磁盘空间不足导致的
   - 选择选项 `4` -> `4.1` 清理已删除文件
   - 选择选项 `4` -> `4.2` 轮转大日志文件

2. **网络连接异常**：
   - 选择选项 `9` 修复DNS配置
   - 选择选项 `7` 修复NTP服务（时间同步服务）

3. **服务无法访问**：
   - 选择选项 `8` 检查端口开放情况
   - 选择选项 `6` 修复对外服务异常

4. **需要上报问题给技术支持**：
   - 选择选项 `10` 打包备份现场环境数据
   - 将生成的压缩包提供给技术支持人员

## 联系支持

如在使用过程中遇到问题，请联系技术支持团队。