import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..')))
from 预定系统.Base.base import *

# 构建XLSX文件的绝对路径
current_dir = os.path.dirname(os.path.abspath(__file__))
# 获取当前脚本所在的目录
xlsx_file_path = os.path.join(current_dir, '..', '..', '..', '测试数据', '会议预定测试用例.xlsx')
# xlsx_file_path = os.path.join(预定系统_path, '测试数据', '兰州中石化项目测试用例.xlsx')

class ChangAnMessageApproval:
    tags = ['长安大学取消审批测试']
    """
        执行指令是：
            1.cd 预定系统
            2.hytest --report_title 长安大学取消审批测试报告 --report_url_prefix http://nat.ubainsyun.com:31133 --tag 长安大学取消审批测试
    """
    ddt_cases = read_xlsx_data(xlsx_file_path, sheet_name='会议审批',case_type="长安大学项目25-03-17")
    # 测试开始前调用clear_columns_in_xlsx函数，将测试用例中的测试结果和日志截图置空
    clear_columns_in_xlsx(xlsx_file_path, sheet_name='会议审批',columns_to_clear=['测试结果', '测试频次', '日志截图'])

    def teststeps(self):
        """
        执行测试步骤函数，主要用于执行读取的测试用例并进行会议模板模块功能测试操作
        """
        # 从全局存储中获取webdriver对象
        wd = GSTORE['wd']
        name = self.name
        # 创建审批会议
        meeting_message("审批会议室", "普通会议", "审批测试会议", "长安大学", wd)

        for step in self.para:
            # 赋值页面类型page
            page_type = step.get('page')
            # 赋值元素定位类型，并将字符串转为Enum类型
            locator_type = get_by_enum(step.get('locator_type'))
            # 赋值元素值
            locator_value = step.get('locator_value')
            # 赋值元素类型，例如：click点击、input输入框等
            element_type = step.get('element_type')
            # 赋值元素值，例如输入框的输入值
            element_value = step.get('element_value')
            # 赋值预期结果
            expected_result = step.get('expected_result')

            # 判断页面功能类型
            if page_type == "ApprovalInitiate":

                if element_type == "input":
                    safe_send_keys((locator_type, locator_value), element_value, wd)
                    sleep(1)

                elif element_type == "click":
                    safe_click((locator_type, locator_value), wd)
                    sleep(2)

                elif element_type == "getTips":
                    notify_text = get_notify_text(wd, (locator_type, locator_value), "Message_Template",
                                                  "Template_Edit", "长安审批测试")
                    INFO(f"提示信息为：{notify_text}")
                    if CHECK_POINT("编辑测试判断是否正确", expected_result in notify_text):
                        write_xlsx_data(xlsx_file_path, "会议审批", name,"失败", r"D:\GithubData\自动化\ubains-module-test\预定系统\reports\imgs\Exhibit_Inspect\Android\门口屏截屏.png")
                    else:
                        write_xlsx_data(xlsx_file_path, "会议审批", name,"通过", r"D:\GithubData\自动化\ubains-module-test\预定系统\reports\imgs\Exhibit_Inspect\Android\门口屏截屏.png")
                    SELENIUM_LOG_SCREEN(wd, "50")

                elif element_type == "function":
                    print(f"这是element_value的值：{element_value}")
                    # 退出登录，并调用用户登录函数
                    safe_click((By.XPATH, "//img[@title='退出登录']"), wd)
                    sleep(1)
                    wd.refresh()
                    user_login(element_value[0], element_value[1])
                    sleep(2)
                    # 调用审批会议状态设置函数
                    approval_status_control("审批测试会议", element_value[2], wd)
                    sleep(1)
                    # 退出登录
                    safe_click((By.XPATH, "//img[@title='退出登录']"), wd)
                    wd.refresh()
                    # 登录与退出操作频繁，到登录页后存在一个缓存界面，可以点击退出按钮
                    quit_element = wd.find_element(By.XPATH, "//div[@class='operat']//span//img")
                    if quit_element != "":
                        quit_element.click()
                    # 调用用户登录函数，登录普通用户
                    user_login("admin@PT", "Ubains@4321")
                    # 进入会议审批模块
                    safe_click((By.XPATH, "//span[contains(text(),'会议审批')]"), wd)
                    sleep(1)