import sys
import os

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..')))
from 预定系统.Base.app_base import *
from 预定系统.Base.base import *

class UnifiedPlatform:
    tags = ['展厅巡检','统一平台系统巡检']

    def teststeps(self):
        wd = GSTORE['wd']
        safe_click((By.XPATH, "//p[contains(text(),'新建会议')]"),wd)
        sleep(2)

        # 切换窗口2，转到创建会议界面
        print(f"这是当前窗口句柄{wd.window_handles}")
        wd.switch_to.window(wd.window_handles[1])
        print(f"这是跳转后的窗口句柄{wd.window_handles}")
        # 选择融合视讯会议
        INFO("选择融合视讯会议")
        # 勾选视讯会议默认选择smc会议
        safe_click((By.XPATH, "//span[contains(text(),'视讯会议')]"),wd)
        sleep(1)
        # 选择腾讯会议
        safe_click((By.XPATH, "//div[@aria-label='checkbox-group']//label[@class='el-checkbox']//span[@class='el-checkbox__inner']"),wd)
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "Unified_Platform", "选择视讯会议")

        # 选择会议室与参会人
        INFO("选择多会议室与参会人")
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议室名称']"), '展厅会议', wd)
        send_keyboard((By.XPATH, "//input[@placeholder='请输入会议室名称']"), wd)
        sleep(5)
        safe_click((By.XPATH, "//div[contains(@class,'el-table el-table--fit el-table--enable-row-transition')]//div[contains(@class,'el-table__fixed-header-wrapper')]//span[contains(@class,'el-checkbox__inner')]"),wd)
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议室名称']"), '展厅指挥', wd)
        send_keyboard((By.XPATH, "//input[contains(@placeholder,'请输入关键字搜索')]"), wd)
        sleep(5)
        safe_click((By.XPATH, "//div[contains(@class,'el-table el-table--fit el-table--enable-row-transition')]//div[contains(@class,'el-table__fixed-header-wrapper')]//span[contains(@class,'el-checkbox__inner')]"), wd)
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "Unified_Platform", "选择多会议室")

        # 选择参会人分配对应会议室
        safe_click((By.XPATH, "//div[contains(@class,'meeting_room')]//div[2]//div[2]//img[2]"),wd)
        sleep(1)
        safe_send_keys((By.XPATH, "//input[contains(@placeholder,'请输入关键字搜索')]"), '管理员', wd)
        safe_click((By.XPATH, "//body[1]/div[1]/div[2]/div[1]/div[1]/div[1]/div[5]/div[1]/div[1]/div[2]/img[2]"),wd)
        sleep(2)
        safe_click((By.XPATH, "//span[contains(text(),'完成')]"),wd)
        sleep(2)
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "Unified_Platform", "选择参会人")

        # 会议创建，并查看详情
        safe_click((By.XPATH, "//span[contains(text(),'确定创建')]"),wd)
        sleep(8)
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "Unified_Platform", "创建会议")

        # 存在视讯资源不足提示，继续点击【确定】按钮
        exception_text = elment_get_text((By.XPATH, "//p[contains(text(),'视讯资源不足，是否继续预约会议')]"), wd)
        if exception_text == '视讯资源不足，是否继续预约会议':
            safe_click((By.XPATH, "//button[contains(@class,'el-button el-button--default el-button--small el-button--primary')]"), wd)
            sleep(5)

        safe_click((By.XPATH, "//span[contains(text(),'查看详情')]"), wd)
        # 切换窗口2，转到会议详情界面
        # print(f"这是当前窗口句柄{wd.window_handles}")
        # wd.switch_to.window(wd.window_handles[1])
        # print(f"这是跳转后的窗口句柄{wd.window_handles}")
        sleep(10)
        INFO("请查看会议详情是否正确包含：多会议室、会议号、会议名称、会议时间")
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "Unified_Platform", "查看会议详情")

        # 进入会控界面
        safe_click((By.XPATH, "//span[contains(text(),'进入会控')]"),wd)
        sleep(10)
        # 切换窗口2，转到会控界面
        # wd.switch_to.window(wd.window_handles[1])
        # 进行多画面设置
        safe_click((By.XPATH, "//div[@class='frames framesActive el-popover__reference']//span[contains(text(),'一画面')]"),wd)
        sleep(5)
        safe_click((By.XPATH,"(//img[@class='img'])[705]"),wd)
        sleep(4)
        wd.refresh()
        sleep(2)
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "Unified_Platform", "进入会控界面")

        # 将左侧会场拖拽到右侧画面进行播放
        INFO("将左侧会场拖拽到右侧画面进行播放")
        # 拖拽指挥中心会场
        single_click_and_drag((By.CSS_SELECTOR, "body > div:nth-child(1) > div:nth-child(2) > div:nth-child(1) > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(1) > div:nth-child(2) > div:nth-child(1) > div:nth-child(2) > div:nth-child(2) > div:nth-child(1) > span:nth-child(2)"),
                              (By.CSS_SELECTOR, "body > div:nth-child(1) > div:nth-child(2) > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(2) > div:nth-child(1) > div:nth-child(1) > div:nth-child(1) > div:nth-child(1)")
                              , wd)
        sleep(4)
        # 拖拽华为会议室会场
        single_click_and_drag((By.CSS_SELECTOR, "body > div:nth-child(1) > div:nth-child(2) > div:nth-child(1) > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(1) > div:nth-child(2) > div:nth-child(1) > div:nth-child(2) > div:nth-child(1) > div:nth-child(1) > span:nth-child(2)"),
                              (By.CSS_SELECTOR, "body > div:nth-child(1) > div:nth-child(2) > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(2) > div:nth-child(1) > div:nth-child(1) > div:nth-child(1) > div:nth-child(4)")
                              , wd)
        sleep(4)
        # 拖拽腾讯视频连接器
        single_click_and_drag((By.CSS_SELECTOR, "body > div:nth-child(1) > div:nth-child(2) > div:nth-child(1) > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(2) > div:nth-child(2) > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(1) > span:nth-child(2)"),
                              (By.CSS_SELECTOR, "body > div:nth-child(1) > div:nth-child(2) > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(2) > div:nth-child(1) > div:nth-child(1) > div:nth-child(1) > div:nth-child(3)")
                               , wd)
        sleep(4)
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "Unified_Platform", "多画面设置")

        # 会控界面-设备控制
        INFO("关闭展厅会议室终端的摄像头")
        safe_click((By.XPATH, "(//img[@title='关闭摄像头'])[2]"),wd)
        sleep(1)
        safe_click((By.XPATH, "//span[contains(text(),'确定')]"),wd)
        sleep(2)
        INFO("开启展厅指挥中心终端的麦克风")
        safe_click((By.XPATH, "(//img[@title='取消静音'])[1]"),wd)
        sleep(2)
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "Unified_Platform", "终端设备控制")
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "Unified_Platform", "终端入会画面")

        # 创建多SMC会议，提示MCU资源不足
        print(f"这是当前窗口句柄{wd.window_handles}")
        wd.switch_to.window(wd.window_handles[0])
        print(f"这是跳转后的窗口句柄{wd.window_handles}")
        safe_click((By.XPATH, "//p[contains(text(),'新建会议')]"),wd)
        sleep(5)

        # 切换窗口至新建会议的窗口
        print(f"这是当前窗口句柄{wd.window_handles}")
        wd.switch_to.window(wd.window_handles[2])
        print(f"这是跳转后的窗口句柄{wd.window_handles}")
        # 选择会议室
        safe_click((By.XPATH, "//div[@class='meeting_area']//div[@class='el-table__fixed-header-wrapper']//div[1]//label[1]//span[1]//span[1]"),wd)
        # 选择smc会议
        safe_click((By.XPATH, "//span[contains(text(),'视讯会议')]"),wd)
        sleep(1)
        # 选择预约时间
        safe_click((By.XPATH, "//div[@class='btns']"), wd)
        sleep(2)

        safe_click((By.XPATH, "//span[contains(text(),'确定创建')]"),wd)
        sleep(10)
        exception_text = elment_get_text((By.XPATH, "//p[contains(text(),'视讯资源不足，是否继续预约会议')]"), wd)
        if exception_text == '视讯资源不足，是否继续预约会议':
            safe_click((By.XPATH,
                        "//button[contains(@class,'el-button el-button--default el-button--small el-button--primary')]"),
                       wd)
            sleep(5)

        safe_click((By.XPATH, "//span[contains(text(),'查看详情')]"),wd)
        sleep(5)
        # print(f"这是当前窗口句柄{wd.window_handles}")
        # wd.switch_to.window(wd.window_handles[2])
        # print(f"这是跳转后的窗口句柄{wd.window_handles}")
        sleep(5)

        # 获取会议详情截图信息
        INFO("请查看会议详情是否提示：”MCU资源不足“")
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "Unified_Platform", "创建多SMC会议提示MCU资源不足")