import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/会议室管理/区域管理模块/区域新增.csv')

class Area_Add_000x:
    tags = ['区域管理功能' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 区域新增测试报告 --report_url_prefix http://nat.ubainsyun.com:13233 --test 区域新增_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以区域新增功能。
            本函数根据点击【新增】按钮，增加区域，并检查新增后的提示信息是否与预期相符。
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出区域名称和检查文本
        name = self.name
        area_name, check_text = self.para

        # 步骤1：点击父级【添加】按钮
        STEP(1, f"点击父级【添加】按钮")
        safe_click((By.XPATH, "//span[contains(text(),'添 加')]"), wd)
        sleep(2)
        # 获取并检查父级区域新增提示信息
        notify_text = get_notify_text(wd, (By.XPATH, "//p[@class='el-message__content']"), "Area_Manage", "Area_Add",
                                      f"{name}_检查父级区域新增提示信息")
        INFO(f"获取到父级区域新增提示文本：{notify_text}")
        CHECK_POINT("新增提示文本是否与预期相符", notify_text == check_text)

        # 步骤2：检查区域新增的默认名称
        STEP(2, f"检查区域新增的默认名称")
        sleep(1)
        notify_text = elment_get_text((By.XPATH, "//span[contains(text(),'默认区域名称')]"), wd)
        INFO(f"获取到新增区域的名称：{notify_text}")
        CHECK_POINT("新增区域的默认名称是否与预期相符", area_name in notify_text)

        # 步骤3和4：对子级区域重复上述步骤
        for i in range(3, 5):
            STEP(i, f"点击子级【添加】按钮")
            safe_click((By.XPATH,
                        "//button[@class='el-button el-button--primary el-button--mini']//span[contains(text(),'添 加')]"),
                       wd)
            sleep(2)
            # 获取并检查子级区域新增提示信息
            notify_text = get_notify_text(wd, (By.XPATH, "//p[@class='el-message__content']"), "Area_Manage",
                                          "Area_Add",
                                          f"{name}_检查子级区域新增提示信息")
            INFO(f"获取到子级区域新增提示文本：{notify_text}")
            CHECK_POINT("新增提示文本是否与预期相符", notify_text == check_text)

            STEP(i + 1, f"检查子级区域新增的默认名称")
            notify_text = elment_get_text((By.XPATH,
                                           "//div[@role='group']//span[contains(text(),'默认区域名称')]"),
                                          wd)
            INFO(f"获取到新增区域的名称：{notify_text}")
            CHECK_POINT("新增区域的默认名称是否与预期相符", area_name in notify_text)

        if name == '区域新增_001':
            wd.refresh()