import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/会议室管理/会议室管理模块/会议室编辑.csv')

class Conference_Edit_000x:
    tags = ['会议室管理功能' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 会议室编辑测试报告 --report_url_prefix http://nat.ubainsyun.com:13233 --test 会议室编辑_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以会议室新增功能。
            本函数根据参数输入会议室名称、，并检查新增后的提示信息是否与预期相符。
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        conference_name, new_conference_name, conference_function, new_conference_function, conference_capacity, new_conference_capacity, max_book_day, open_department, check_text = self.para

        # 步骤1：搜索会议室
        STEP(1, f"搜索会议室：{conference_name}")
        # 日志记录：输入查询文本
        INFO(f"输入查询文本：{conference_name}")
        # 在搜索框中输入会议室名称
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), conference_name, wd)
        # 触发搜索操作
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
        sleep(1)

        # 步骤2：点击编辑按钮
        STEP(2, "点击编辑按钮")
        # 点击指定会议室的编辑按钮
        safe_click((By.XPATH, "//div[contains(@class,'cell el-tooltip')]//span[1]"), wd)
        sleep(1)

        # 步骤3：检查修改界面的标题
        STEP(3, "检查修改界面的标题")
        # 获取修改会议室界面的标题文本
        notify_text = elment_get_text((By.XPATH, "//span[contains(text(),'修改会议室')]"), wd)
        # 日志记录：检查修改界面的标题
        INFO(f"检查修改界面的标题：{notify_text}")
        # 检查点：验证修改会议室界面的标题是否正确
        CHECK_POINT("检查修改界面的标题是否正确", "修改会议室" in notify_text)

        # 步骤4：输入新会议室名称
        STEP(4, "输入新会议室名称")
        sleep(1)
        # 在会议室名称输入框中输入新的会议室名称
        safe_send_keys((By.XPATH, "//input[contains(@placeholder,'输入会议室名称')]"), new_conference_name, wd)
        sleep(1)

        # 步骤5：选择新会议室功能
        STEP(5, "选择新会议室功能")
        # 打开功能设置弹窗并选择新的会议室功能

        # 点击功能设置按钮，打开功能设置弹窗
        safe_click((By.XPATH, "//span[contains(text(),'设置(1)')]"), wd)

        # 暂停1秒，等待功能设置弹窗加载完成
        sleep(1)

        # 获取功能设置弹窗的标题文本，用于验证弹窗是否正确显示
        notify_text = elment_get_text((By.XPATH, "//span[contains(text(),'会议室功能')]"), wd)

        # 记录日志，检查功能设置弹窗的标题是否正确
        INFO(f"检查会议室功能设置弹窗标题是否为：{notify_text}")

        # 检查点：验证功能设置弹窗是否正确弹出
        CHECK_POINT("检查是否弹出功能设置弹窗", notify_text == "会议室功能")

        # 清除已有功能
        sleep(2)
        safe_click((By.XPATH,f"//span[contains(text(),'{conference_function}')]"), wd)
        safe_click((By.XPATH, "//button[contains(@class,'el-button el-button--primary el-transfer__button')]"),wd)

        # 步骤5：在功能设置中搜索特定的会议室功能
        STEP(5, f"搜索会议室功能：{new_conference_function}")
        sleep(1)
        # 在搜索框中输入会议室功能的关键字
        safe_send_keys((By.XPATH, "(//input[@placeholder='输入关键字'])[1]"), new_conference_function, wd)

        # 发送键盘事件，触发搜索操作
        send_keyboard((By.XPATH, "(//input[@placeholder='输入关键字'])[1]"), wd)

        # 暂停2秒，等待搜索结果加载完成，并选择功能
        sleep(2)
        safe_click((By.XPATH, f"//span[contains(text(),'{new_conference_function}')]"), wd)
        sleep(1)
        safe_click((By.XPATH, "//button[@class='el-button el-button--primary el-transfer__button']"),wd)
        safe_click((By.XPATH, "//div[contains(@aria-label,'会议室功能')]//div[contains(@class,'el-dialog__footer')]//button[contains(@type,'button')]"),wd)

        # 根据开放部门的不同设置进行不同的操作
        if open_department == "测试":
            STEP(6, f"开放部门设置为：{open_department}")
            # 取消默认选中的“全部开放”选项
            safe_click((By.XPATH,
                        "//span[contains(@class,'el-checkbox__input is-checked')]//span[contains(@class,'el-checkbox__inner')]"), wd)
            sleep(2)
            # 点击“单独设置”选项
            safe_click((By.XPATH, "//span[contains(text(),'单独设置')]"), wd)
            sleep(4)
            # 点击【全选】按钮
            safe_click((By.XPATH, "(//span[contains(text(),'全选')])[1]"), wd)
            sleep(1)
            # 点击【确定】按钮
            safe_click((By.XPATH, "//div[@aria-label='开放部门']//span[contains(text(),'确定')]"), wd)
            sleep(2)

        elif open_department == "全部开放":
            STEP(6, f"开放部门设置为：{open_department}")
            # 选择“全部开放”选项
            safe_click((By.XPATH, "//span[contains(text(),'全部开放')]"), wd)
            sleep(1)

        # 步骤7：输入新会议室容纳人数
        STEP(7, f"输入新会议室容纳人数：{new_conference_capacity}")
        # 在容纳人数输入框中输入新的容纳人数
        safe_send_keys((By.XPATH, "//input[contains(@placeholder,'2')]"), new_conference_capacity, wd)
        sleep(1)

        # 步骤8：输入最大预约天数
        STEP(8, f"输入最大预约天数：{max_book_day}")
        # 在最大预约天数输入框中输入新的预约天数
        safe_send_keys((By.XPATH, "//div[@class='reserve_input']//div[4]//input[1]"), max_book_day, wd)
        sleep(1)

        # 步骤9：点击保存按钮
        STEP(9, "点击保存按钮")
        # 点击保存按钮以保存所有更改
        safe_click((By.XPATH, "//span[contains(text(),'保 存')]"), wd)
        sleep(2)

        # 步骤10：检查修改结果
        STEP(10, "检查修改结果")
        # 获取修改结果的提示信息
        notify_text = get_notify_text(wd, (
            By.XPATH, "//p[contains(@class,'el-message__content')]"), "Conference_Manage", "Conference_Edit",
                                          f"{name}_会议室编辑提示信息")
        # 日志记录：修改结果
        INFO(f"修改结果为：{notify_text}")
        # 检查点：验证修改结果是否正确
        CHECK_POINT("检查修改结果是否正确", notify_text == check_text)

        # 步骤11：检查数据回显
        STEP(11, "检查数据回显")
        # 在搜索框中输入新的会议室名称以查找修改后的会议室
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), new_conference_name, wd)
        # 触发搜索操作
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
        sleep(2)

        # 获取会议室名称的回显文本
        conference_name_text = elment_get_text((By.XPATH, "//tbody/tr[@class='el-table__row']/td[2]/div[1]"), wd)
        # 获取会议室容纳人数的回显文本
        conference_capacity_text = elment_get_text((By.XPATH, f"//div[normalize-space()='{new_conference_capacity}']"),
                                                   wd)
        # 获取会议室功能的回显文本
        conference_function_text = elment_get_text((By.XPATH, f"//div[normalize-space()='{new_conference_function}']"),
                                                   wd)
        # 获取最大预约天数的回显文本
        conference_maxbook_text = elment_get_text((By.XPATH, f"//div[normalize-space()='{max_book_day}']"), wd)
        # 获取开放部门的回显文本
        conference_open_text = elment_get_text((By.CSS_SELECTOR,
                                                "body > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(2) > div:nth-child(1) > div:nth-child(1) > div:nth-child(3) > div:nth-child(1) > div:nth-child(3) > table:nth-child(1) > tbody:nth-child(2) > tr:nth-child(1) > td:nth-child(7) > div:nth-child(1)"),
                                               wd)

        # 日志记录：数据回显结果
        INFO(
            f"数据回显结果为：{conference_name_text},{conference_capacity_text},{conference_function_text},{conference_maxbook_text},{conference_open_text}")
        # 检查点：验证数据回显是否正确
        CHECK_POINT("检查数据回显是否正确",
                    new_conference_name in conference_name_text and new_conference_capacity in conference_capacity_text and new_conference_function in conference_function_text and max_book_day in conference_maxbook_text and open_department in conference_open_text)

        if name == '会议室编辑_003':
            wd.refresh()