import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建XLSX文件的绝对路径
xlsx_file_path = os.path.join(current_dir, '..', '..', '测试数据', '会议预定测试用例.xlsx')


class MeetingRoomList:
    tags = ['新-会议室列表', 'JSON测试']
    """
        执行指令是：
            1.cd 预定系统
            2.hytest --report_title 账号密码登录测试报告 --report_url_prefix http://nat.ubainsyun.com:31133 --tag 新-会议室列表
    """
    ddt_cases = read_xlsx_data(xlsx_file_path, sheet_name='会议室列表',case_type="标准版")
    # 测试开始前调用clear_columns_in_xlsx函数，将测试用例中的测试结果和日志截图置空
    clear_columns_in_xlsx(xlsx_file_path, sheet_name='会议室列表', columns_to_clear=['测试结果', '测试频次', '日志截图'])

    def teststeps(self):
        wd = GSTORE['wd']
        name = self.name

        for step in self.para:
            # 赋值页面类型page
            page_type = step.get('page')
            # 赋值元素定位类型，并将字符串转为Enum类型
            locator_type = get_by_enum(step.get('locator_type'))
            # 赋值元素值
            locator_value = step.get('locator_value')
            # 赋值元素类型，例如：click点击、input输入框等
            element_type = step.get('element_type')
            # 赋值元素值，例如输入框的输入值
            element_value = step.get('element_value')
            # 赋值预期结果
            expected_result = step.get('expected_result')

            if page_type == "MeetingList_MeetingRoomToken":
                if element_type == "input":
                    # 点击展开筛选界面
                    STEP(1, "搜索会议室")
                    safe_send_keys((locator_type, locator_value), element_value, wd)
                    send_keyboard((locator_type, locator_value), wd)
                    sleep(2)
                    # 点击【查询】按钮
                    safe_click((By.XPATH, "//span[contains(text(),'查询')]"), wd)
                    sleep(1)

                elif element_type == "click":
                    # 点击会议室，查看提示信息
                    STEP(2, "点击【会议预约】")
                    safe_click((locator_type, locator_value), wd)
                    sleep(2)
                    # 判断是否为已授权的会议室，如果是，则点击会议预定判断是否进入会议预定界面，否则，点击会议预定，查看提示信息
                    if "会议" in expected_result:
                        notify_text = elment_get_text((By.XPATH, "//div[@class='reserve_Title']"), wd)
                    else:
                        notify_text = get_notify_text(wd, (By.XPATH, "//p[@class='el-message__content']"),
                                                      "MeetingList", "RoomToken", f"未授权会议室点击【会议预定】")
                        INFO(f"提示信息为：{notify_text}")
                    # 判断提示信息是否正确
                    sleep(1)
                    CHECK_POINT("提示信息是否正确", expected_result in notify_text)
                    SELENIUM_LOG_SCREEN(wd, "50")