import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..')))
from 预定系统.Base.base import *
# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建XLSX文件的绝对路径
xlsx_file_path = os.path.join(current_dir, '..', '..', '测试数据', '会议预定测试用例.xlsx')

class MessageApproval:
    tags = ['新-会议审批测试', 'JSON测试']
    """
        执行指令是：
            1.cd 预定系统
            2.hytest --report_title 会议审批测试报告 --report_url_prefix http://nat.ubainsyun.com:31133 --tag 新-会议审批测试
    """
    ddt_cases = read_xlsx_data(xlsx_file_path, sheet_name='会议审批',case_type="标准版")
    # 测试开始前调用clear_columns_in_xlsx函数，将测试用例中的测试结果和日志截图置空
    # clear_columns_in_xlsx(xlsx_file_path, sheet_name='会议审批', columns_to_clear=['测试结果', '测试频次', '日志截图'])

    def teststeps(self):
        """
        执行测试步骤函数，主要用于执行读取的测试用例并进行会议模板模块功能测试操作
        """
        # 从全局存储中获取webdriver对象
        wd = GSTORE['wd']
        name = self.name
        # 创建审批会议
        meeting_message("审批会议室", "普通会议", "审批测试会议", "标准版", wd)

        for step in self.para:
            # 赋值页面类型page
            page_type = step.get('page')
            # 赋值元素定位类型，并将字符串转为Enum类型
            locator_type = get_by_enum(step.get('locator_type'))
            # 赋值元素值
            locator_value = step.get('locator_value')
            # 赋值元素类型，例如：click点击、input输入框等
            element_type = step.get('element_type')
            # 赋值元素值，例如输入框的输入值
            element_value = step.get('element_value')
            # 赋值预期结果
            expected_result = step.get('expected_result')

            # 判断页面功能类型
            if page_type == "ApprovalInitiate":
                # 这是编辑模板测试
                if element_type == "input":
                    safe_send_keys((locator_type, locator_value), element_value, wd)
                    sleep(1)

                elif element_type == "click":
                    safe_click((locator_type, locator_value), wd)
                    safe_click((locator_type, locator_value), wd)
                    sleep(2)

                elif element_type == "getTips":
                    notify_text = get_notify_text(wd, (locator_type, locator_value), "Message_Template",
                                                  "Template_Edit", "编辑模板")
                    INFO(f"提示信息为：{notify_text}")
                    CHECK_POINT("编辑测试判断是否正确", expected_result in notify_text)
                    SELENIUM_LOG_SCREEN(wd, "50")

                elif element_type == "getText":
                    notify_text = elment_get_text((locator_type, locator_value), wd)
                    INFO(f"获取文本信息为：{notify_text}")
                    CHECK_POINT("获取文本判断是否正确", expected_result in notify_text)
                    SELENIUM_LOG_SCREEN(wd, "50")

        # 取消审批会议数据
        safe_click((By.XPATH, "//span[contains(text(),'取消审批')]"), wd)
        sleep(1)
        safe_click((By.XPATH,
                    "//button[contains(@class,'el-button el-button--default el-button--small el-button--primary')]//span[contains(text(),'确定')]"),
                   wd)