import sys
import os

from hytest.common import SELENIUM_LOG_SCREEN

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..', '..')))
from 运维集控.项目测试.运维标准版.lib.base import *

class areafuntionMod01:
    name = '编辑区域-001-修改区域分组'
    def teststeps(self):
        wd = GSTORE['wd']

        STEP(1, '搜索对应的区域名称：测试区域0')
        areaname_search= WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//div[@class='company-search el-input el-input--suffix']//input[@placeholder='请输入区域名称']"))
        )
        areaname_search.clear()
        areaname_search.send_keys("测试区域0")
        areaname_search.send_keys(Keys.RETURN)

        STEP(2, '点击勾选区域')
        area_click= WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//th[contains(@class,'is-leaf el-table__cell')]//span[contains(@class,'el-checkbox__inner')]"))
        )
        sleep(1)
        area_click.click()

        STEP(3, '点击编辑按钮')
        area_mod = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//span[contains(text(),'编辑')]"))
        )
        area_mod.click()

        STEP(4, '修改区域分组')
        areagroup_input = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//div[contains(@class,'dialog_input')]//input[contains(@placeholder,'请选择分组')]"))
        )
        areagroup_input.clear()
        areagroup_input.send_keys("广州分组1")
        # 选择分组，并点击第一个
        areagroup_modify = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (
                By.XPATH, "//li[@class='el-cascader__suggestion-item']"))
        )
        areagroup_modify.click()

        STEP(5, '点击确认')
        commit = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//div[contains(@aria-label,'编辑')]//span[contains(text(),'确 定')]"))
        )
        commit.click()

        STEP(6, '验证是否修改成功')
        get_menu = WebDriverWait(wd, 10).until(
            EC.visibility_of_element_located(
                (By.CSS_SELECTOR, '.el-message__content'))
        )
        get_menu1 = get_menu.text
        CHECK_POINT('检查是否出现成功提示弹窗', get_menu1 == "操作成功!")

        # 截图并保存
        SELENIUM_LOG_SCREEN(wd, "50%")
        sleep(1)
        wd.refresh()

class areafuntionMod02:
    name = '编辑区域-002-修改区域类型'
    def teststeps(self):
        wd = GSTORE['wd']

        STEP(1, '搜索对应的区域名称')
        areaname_search= WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//div[@class='company-search el-input el-input--suffix']//input[@placeholder='请输入区域名称']"))
        )
        areaname_search.clear()
        areaname_search.send_keys("测试区域0")
        areaname_search.send_keys(Keys.RETURN)

        STEP(2, '勾选区域')
        area_select = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//th[contains(@class,'is-leaf el-table__cell')]//span[contains(@class,'el-checkbox__inner')]"))
        )
        area_select.click()

        STEP(3, '点击编辑按钮')
        area_mod = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//span[contains(text(),'编辑')]"))
        )
        area_mod.click()
        sleep(1)

        STEP(4, '修改区域类型')
        areatype_input = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//div[@class='dialog_input']//input[@placeholder='请选择区域类型']"))
        )
        areatype_input.click()
        areatype_input.send_keys("大会议室")
        # 选择类型，并点击第一个
        areatype_modify = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (
                By.XPATH, "//div[@x-placement='bottom-start']//ul[@class='el-scrollbar__view el-select-dropdown__list']"))
        )
        areatype_modify.click()

        STEP(5, '点击确认')
        commit = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//div[contains(@aria-label,'编辑')]//span[contains(text(),'确 定')]"))
        )
        commit.click()

        STEP(6, '验证是否修改成功')
        get_menu = WebDriverWait(wd, 10).until(
            EC.visibility_of_element_located(
                (By.CSS_SELECTOR, '.el-message__content'))
        )
        get_menu1 = get_menu.text
        CHECK_POINT('检查是否出现成功提示弹窗', get_menu1 == "操作成功!")

        # 截图并保存
        SELENIUM_LOG_SCREEN(wd, "50%")
        sleep(1)
        wd.refresh()

class areafuntionMod03:
    name = '编辑区域-003-修改区域名称'
    def teststeps(self):
        wd = GSTORE['wd']

        STEP(1, '搜索对应的区域名称')
        areaname_search= WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//div[@class='company-search el-input el-input--suffix']//input[@placeholder='请输入区域名称']"))
        )
        areaname_search.clear()
        areaname_search.send_keys("测试区域0")
        areaname_search.send_keys(Keys.RETURN)

        STEP(2, '勾选区域')
        area_select = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//th[contains(@class,'is-leaf el-table__cell')]//span[contains(@class,'el-checkbox__inner')]"))
        )
        area_select.click()

        STEP(3, '点击编辑按钮')
        area_mod = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//span[contains(text(),'编辑')]"))
        )
        area_mod.click()
        sleep(1)

        STEP(4, '修改区域名称')
        areaname_input = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//div[contains(@class,'dialog_input')]//input[contains(@placeholder,'请输入区域名称')]"))
        )
        areaname_input.clear()
        areaname_input.send_keys("测试区域100")

        STEP(5, '点击确认')
        commit = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//div[contains(@aria-label,'编辑')]//span[contains(text(),'确 定')]"))
        )
        commit.click()

        STEP(6, '验证是否修改成功')
        get_menu = WebDriverWait(wd, 10).until(
            EC.visibility_of_element_located(
                (By.CSS_SELECTOR, '.el-message__content'))
        )
        get_menu1 = get_menu.text
        CHECK_POINT('检查是否出现成功提示弹窗', get_menu1 == "操作成功!")

        # 截图并保存
        SELENIUM_LOG_SCREEN(wd, "50%")
        sleep(1)
        wd.refresh()