import sys
import os

from hytest.common import SELENIUM_LOG_SCREEN

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..', '..')))
from 运维集控.项目测试.运维标准版.lib.base import *

# 构建 CSV 文件的绝对路径
csv_path = os.path.abspath(
    os.path.join(os.path.dirname(__file__), '..', '..', 'testdata', '05区域功能', '新增区域功能.csv'))

class AreafuntionAdd:
    tag = ['新增区域功能']
    ddt_cases = read_csv_data(csv_path)
    def teststeps(self):
        wd = GSTORE['wd']

        #从self.para中解构出数据
        name = self.name
        funtion_name, sort, remark, info= self.para

        STEP(1, '点击新增按钮')
        areafuntion_add = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//div[@class='company-edmit-right']//span[contains(text(),'新增')]"))
        )
        areafuntion_add.click()
        sleep(1)

        STEP(2, f'填写功能名称:{funtion_name}')
        funtion_name_input = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//div[@class='el-input el-input--suffix']//input[@placeholder='请输入功能名称']"))
        )
        funtion_name_input.clear()
        funtion_name_input.send_keys(funtion_name)

        STEP(3, f'填写排序:{sort}')
        funtion_sort = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='排序']"))
        )
        funtion_sort.clear()
        funtion_sort.send_keys(sort)

        STEP(4, f'填写备注:{remark}')
        funtion_remark = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='备注']"))
        )
        funtion_remark.clear()
        funtion_remark.send_keys(remark)

        STEP(5, '点击确认')
        commit = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//div[@class='dialog-footer']//span[contains(text(),'确 定')]"))
        )
        commit.click()

        STEP(6, '验证是否新增成功')
        get_menu = WebDriverWait(wd, 10).until(
            EC.visibility_of_element_located(
                (By.CSS_SELECTOR, '.el-message__content'))
        )
        get_menu1 = get_menu.text
        CHECK_POINT('检查是否出现成功提示弹窗', get_menu1 == info)

        # 截图并保存
        SELENIUM_LOG_SCREEN(wd, "50%")
        sleep(1)
        wd.refresh()