
function getRegions() {
    const companyId = $('#company_id').val();
    $.ajax({
        url: '/get_regions',
        method: 'GET',
        data: { company_id: companyId },
        success: function(response) {
            const regionsSelect = $('#regions');
            regionsSelect.empty();
            response.forEach(region => {
                regionsSelect.append(`<option value="${region[0]}">${region[1]}</option>`);
            });
        },
        error: function(error) {
            console.error('Error fetching regions:', error);
        }
    });
}

function getDevices() {
    const selectedRegions = $('#regions').val();
    if (selectedRegions.length === 0) {
        alert('请选择至少一个会议室');
        return;
    }
    $.ajax({
        url: '/get_devices',
        method: 'GET',
        data: { region_ids: selectedRegions.join(',') },
        success: function(response) {
            const devicesSelect = $('#devices');
            devicesSelect.empty();
            response.forEach(device => {
                devicesSelect.append(`<option value="${device.device_id}">${device.device_name}</option>`);
            });
        },
        error: function(error) {
            console.error('Error fetching devices:', error);
        }
    });
}

function togglePower(on) {
    const selectedRegions = $('#regions').val();
    if (!selectedRegions || selectedRegions.length === 0) {
        alert('请先选择会议室');
        return;
    }
    const action = on ? '开启' : '关闭';
    $.ajax({
        url: '/toggle_power',
        method: 'POST',
        data: JSON.stringify({ regions: selectedRegions, on: on }),
        contentType: 'application/json',
        success: function(response) {
            alert(`已${action} ${selectedRegions.join(', ')} 的电源`);
        },
        error: function(error) {
            console.error('Error toggling power:', error);
        }
    });
}

function toggleStatus(online) {
    const selectedRegions = $('#regions').val();
    if (!selectedRegions || selectedRegions.length === 0) {
        alert('请先选择会议室');
        return;
    }
    const status = online ? '在线' : '离线';
    $.ajax({
        url: '/toggle_status',
        method: 'POST',
        data: JSON.stringify({ regions: selectedRegions, online: online }),
        contentType: 'application/json',
        success: function(response) {
            alert(`已将 ${selectedRegions.join(', ')} 设置为 ${status}`);
        },
        error: function(error) {
            console.error('Error toggling status:', error);
        }
    });
}
