from hytest import *
# 获取当前脚本的绝对路径
current_dir = os.path.dirname(os.path.abspath(__file__))
# 构建预定系统的绝对路径
base_path = os.path.abspath(os.path.join(current_dir, '..','..'))
# 添加路径
sys.path.append(base_path)
# 导入模块
try:
    from Mqtt_Universal_Tool.base.Mqtt_Send import *
except ModuleNotFoundError as e:
    print(f"ModuleNotFoundError: {e}")
    print("尝试使用绝对路径导入")
    from Mqtt_Universal_Tool.base.Mqtt_Send import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../TestData/ReservationSystem_MillimeterWaveRadar/MQTT毫米波调试.csv')

if __name__ == "__main__":
    # 读取配置文件
    configs = Mqtt.read_config_from_csv(csv_file_path)

    broker_address = "192.168.1.131"
    port = 1881
    num_repeats = 2000  # 重复执行的次数
    interval_between_repeats = 1  # 每次重复之间的间隔时间（秒）

    # 创建 MQTT 客户端实例-
    mqtt_client = Mqtt(broker_address, port)

    try:
        # 连接到 MQTT 服务器
        mqtt_client.connect()

        for repeat in range(num_repeats):
            logging.info(f"开始第 {repeat + 1} 次上报")

            # 遍历配置文件中的每一行数据
            for config in configs:
                # 构建消息内容
                topic = config["topic"]
                current_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
                message = Mqtt.build_message(config, current_time, topic)

                logging.info(message)
                # 发送消息
                mqtt_client.publish(topic, message)

                # 每次发送之间可以设置一个间隔时间
                time.sleep(interval_between_repeats)

            # 每次重复之间设置一个间隔时间
            time.sleep(interval_between_repeats)

    except Exception as e:
        logging.error(f"发送消息时发生错误: {e}")

    finally:
        # 断开与 MQTT 服务器的连接
        mqtt_client.disconnect()
