# 容器升级需求说明文档

## 规范获取
    代码规范：Docs/PRD/01规范文档/_PRD_规范文档_代码规范.md
    问题总结：Docs/PRD/01规范文档/_PRD_问题总结_记录文档.md
    方法总结：Docs/PRD/01规范文档/_PRD_方法总结_记录文档.md
    文档规范：Docs/PRD/01规范文档/_PRD_规范文档_文档规范.md
    测试规范：Docs/PRD/01规范文档/_PRD_规范文档_测试规范.md

## 📋 概述

本系统由三个核心 Shell 脚本组成，用于实现容器化服务的远程部署与升级管理：

1. **`remote_update.sh`**：远程升级控制脚本，负责从主服务器向目标服务器传输镜像和部署脚本，并触发远端部署流程，路径：E:\GithubData\自动化\ubains-module-test\辅助工具\脚本工具\远程容器更新\remote_update.sh
2. **`container_update.sh`**：容器部署执行脚本，支持交互式和命令行两种模式，可单独执行进行本地容器部署，路径：E:\GithubData\自动化\ubains-module-test\辅助工具\脚本工具\远程容器更新\container_update.sh
3. **`upload_to_nas.sh`**：镜像打包上传脚本，负责将容器镜像打包并上传至公司 NAS 网盘，路径：E:\GithubData\自动化\ubains-module-test\辅助工具\脚本工具\远程容器更新\upload_to_nas.sh

### 背景

目前系统支持多种容器服务（Java、Redis、EMQX、Python、Nacos、Nginx）的部署与升级，需要区分两种平台环境：

- **新统一平台**：使用 `/data/` 目录结构
- **传统平台**：使用 `/var/www/` 目录结构

**现有功能**：

- ✅ 远程升级指定服务器的容器版本 `[已实现]`
    1. java容器远程更新（传统平台和新统一平台已验证通过）
    2. uemqx容器（传统平台和新统一平台已验证通过）
    3. uredis容器（传统平台和新统一平台已验证通过）
    4. upython容器（）
    5. nacos容器（新统一平台已验证通过）
    6. nginx容器（新统一平台已验证通过）
    7. mysql容器（未验证）
- ✅ 自动校验目标服务器架构（仅支持 x86）`[已实现]`
- ✅ 自动递增容器编号避免命名冲突 `[已实现]`
- ✅ 支持多种容器类型的差异化部署 `[已实现]`
- ✅ 支持预设服务器和手动输入服务器信息（IP/端口/用户名/密码）`[已实现]`
- ✅ EMQX 文件同步（配置、数据、日志目录）`[已实现]`
- ✅ Nginx 文件同步（配置、HTML、证书目录）`[已实现]`
- ✅ 自动校验目标服务器是新统一平台目录还是传统平台目录，通过宿主机上的目录来判断，存在/data/services目录的是新统一平台，不存在的则是传统平台 `[已实现]`
- ✅ 自动校验目标服务器上的容器是否已更新 `[已实现]`
- ✅ 远程更新完成后需要将目标服务器上的镜像包清理 `[已实现]`
- ⏸️ Python 文件同步 `[功能保留，暂不启用]`

- ✅ 将主服务器上的容器镜像及部署脚本打包上传至网盘 `[已实现]`
- ✅ container_update.sh 支持单独执行（交互式模式）`[已实现]`

**待实现功能**：

- ❌ 最终将sh脚本改为电脑命令行工具上可执行的脚本格式 `[待最后开发]`

---

## 🎯 功能实现总览

> 最后更新时间：2025-12-07

### 远程升级功能 (`remote_update.sh`)

| 功能模块 | 描述 | 状态 |
|----------|------|------|
| 服务器选择 | 支持预设服务器列表和手动输入（IP/端口/用户名/密码） | ✅ 已实现 |
| 自定义端口 | 支持自定义 SSH 端口（默认 22） | ✅ 已实现 |
| 架构校验 | 校验目标服务器是否为 x86 架构 | ✅ 已实现 |
| 镜像传输 | 自动传输镜像文件和部署脚本 | ✅ 已实现 |
| 容器停止 | 自动停止远端旧容器 | ✅ 已实现 |
| 平台识别 | 自动检测目标服务器平台类型（检测 /data/services 目录） | ✅ 已实现 |
| 版本校验 | 自动校验远端容器镜像版本是否已更新 | ✅ 已实现 |
| EMQX 同步 | 同步 EMQX 配置、数据、日志目录 | ✅ 已实现 |
| Python 同步 | 同步 Python 代码和配置 | ⏸️ 暂停 |
| Nginx 同步 | 同步 Nginx 配置、HTML、证书 | ✅ 已实现 |
| 容器编号 | 自动递增容器编号 | ✅ 已实现 |
| 远端执行 | 调用远端部署脚本 | ✅ 已实现 |
| 镜像清理 | 部署完成后自动清理远端镜像包和部署脚本 | ✅ 已实现 |

### 容器部署功能 (`container_update.sh`)

| 容器类型 | 新平台 | 传统平台 | 备注 |
|----------|--------|----------|------|
| Java (ujava) | ✅ | ✅ | 完整端口映射和目录挂载 |
| Redis (uredis) | ✅ | ✅ | 支持配置迁移和端口释放 |
| EMQX (uemqx) | ✅ | ✅ | 多端口映射，完整目录挂载 |
| Python (upython) | ✅ | ✅ | 容器部署正常，暂不同步文件 |
| Nacos (unacos) | ✅ | ❌ | 仅支持新平台，单机模式 |
| Nginx (unginx) | ✅ | ❌ | 仅支持新平台，完整目录挂载 |

### 交互式部署功能 (`container_update.sh` 交互式模式)

| 步骤 | 功能描述 | 状态 |
|------|----------|------|
| 步骤1 | 询问更新哪个容器 | ✅ 已实现 |
| 步骤2 | 检查压缩包中是否存在所需镜像和配置文件 | ✅ 已实现 |
| 步骤3 | 判断当前服务器是传统平台还是新统一平台 | ✅ 已实现 |
| 步骤4 | 检查并停止正在运行的同类型容器（不删除） | ✅ 已实现 |
| 步骤5 | 备份原有配置文件 | ❌ 待开发 |
| 步骤6 | 更新配置文件并替换IP地址为当前服务器IP | ❌ 待开发 |
| 步骤7 | 执行容器部署操作 | ✅ 已实现 |
| 步骤8 | 验证容器部署是否成功 | ✅ 已实现 |
| 步骤9 | 记录操作日志到当前目录（日志审计） | ✅ 已实现 |

### 镜像上传功能 (`upload_to_nas.sh`)

| 功能模块 | 描述 | 状态 |
|----------|------|------|
| 目录打包 | 将指定目录压缩为 tar.gz 格式 | ✅ 已实现 |
| NAS 挂载 | 自动挂载公司 SMB 网盘 | ✅ 已实现 |
| 进度显示 | 打包和上传过程显示进度条 | ✅ 已实现 |
| 密码加密 | 网盘密码使用 base64 加密存储 | ✅ 已实现 |

### 新增脚本remote_update_win.ps1

> 参考脚本：E:\GithubData\自动化\ubains-module-test\辅助工具\脚本工具\远程容器更新\remote_update.sh
> 新增脚本：E:\GithubData\自动化\ubains-module-test\辅助工具\脚本工具\远程容器更新\remote_update_win.ps1
> 脚本要求：最好能够直接运行，不用安装依赖

| 功能模块 | 描述 | 状态 |
|----------|------|------|
| 服务器选择 | 支持预设服务器列表和手动输入（IP/端口/用户名/密码） | ✅ 已实现 |
| 自定义端口 | 支持自定义 SSH 端口（默认 22） | ✅ 已实现 |
| 架构校验 | 校验目标服务器是否为 x86 架构 | ✅ 已实现 |
| 镜像传输 | 自动传输镜像文件和部署脚本 | ✅ 已实现|
| 容器停止 | 自动停止远端旧容器 | ✅ 已实现 |
| 平台识别 | 自动检测目标服务器平台类型（检测 /data/services 目录） | ✅ 已实现 |
| 版本校验 | 自动校验远端容器镜像版本是否已更新 | ✅ 已实现 |
| EMQX 同步 | 同步 EMQX 配置、数据、日志目录 | ❌ 待开发 |
| Python 同步 | 同步 Python 代码和配置 | ⏸️ 暂停 |
| Nginx 同步 | 同步 Nginx 配置、HTML、证书 | ❌ 待开发 |
| 容器编号 | 自动递增容器编号 | ✅ 已实现 |
| 远端执行 | 调用远端部署脚本 | ✅ 已实现 |
| 日志审计 | 每一步骤的日志都需要记录到log文件中 | ✅ 已实现 |

### 待开发功能

| 功能 | 描述 | 状态 |
|------|------|------|
| 批量部署 | 一次升级多台服务器 | ❌ 待开发 |
| 版本管理 | 记录部署版本和时间 | ❌ 待开发 |

---