import csv

def create_AndroidMessageUp_csv():
    # 定义基础数据
    base_data = {
        "topic": "rebootResponseTopic",
        "appToken": "AND-2IK-0021",
        "companyNumber": "CN-2IK-UBAINS",
        "cnum": "",
        "conferenceId": "100",  # 初始值为字符串
        "macAddress": "20:59:20:00:28:01",
    }

    # 输出文件路径
    output_file = "MQTT模块/MQTT安卓上报_2000条.csv"

    # 生成2000条数据
    with open(output_file, mode="w", newline="", encoding="utf-8") as file:
        writer = csv.writer(file)

        # 写入表头
        writer.writerow([
            "topic", "clientId", "appToken", "companyNumber", "cnum",
            "conferenceId", "macAddress", "authCode", "clientId", "deviceId"
        ])

        for i in range(1, 2001):
            # 格式化编号
            index_str = f"{i:04d}"
            client_id = f"48134e6047a19a{i:04d}"
            device_id = f"aa44e258a4e1e{i:04d}"
            app_token = f"AND-2IK-{index_str}"
            auth_code = app_token

            # conferenceId 从100开始递增
            current_conference_id = str(int(base_data["conferenceId"]) + i)

            # 写入一行数据
            writer.writerow([
                base_data["topic"], client_id, app_token, base_data["companyNumber"],
                base_data["cnum"], current_conference_id, base_data["macAddress"],
                auth_code, client_id, device_id
            ])

    print(f"成功生成 {output_file} 文件，包含2000条数据。")


import csv

def create_Androidbroadcast_csv():
    # 基础配置
    base_topic = "/uams/android/broadcast"
    output_file = "MQTT模块/MQTT心跳上报_2000条.csv"

    # 生成2000条数据
    with open(output_file, mode="w", newline="", encoding="utf-8") as file:
        writer = csv.writer(file)

        # 写入表头（根据原始CSV结构）
        writer.writerow([
            "topic", "clientId", "appToken", "companyNumber", "cnum",
            "conferenceId", "macAddress", "authCode", "clientId", "deviceId"
        ])

        for i in range(1, 2001):
            # 格式化编号为4位数，如0001, 0002...
            index_str = f"{i:04d}"

            # clientId 和 deviceId 的格式
            client_id = f"48134e6047a19a{index_str}"
            device_id = f"aa44e258a4e1e{index_str}"

            # 按照指定格式写入空字段和动态字段
            writer.writerow([
                base_topic, "", "", "", "",
                "", "", "", client_id, device_id
            ])

    print(f"成功生成 {output_file} 文件，包含2000条数据。")


# if __name__ == "__main__":
    # create_AndroidMessageUp_csv()
    # create_Androidbroadcast_csv()