from time import sleep
import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/账号管理/用户管理模块/用户管理主流程.csv')

class Main_User_Manage_000x:
    # tags = ['用户管理功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 用户主流程测试报告 --report_url_prefix http://nat.ubainsyun.com:13233 --test 用户管理主流程_001
    """

    def teststeps(self):
        """
            执行测试步骤以用户管理的主流程功能。
            本函数根据参数添加用户，并使用新增的用户进行登录的提示信息是否与预期相符。
        """
        # login_url = 'https://192.168.5.235/#/login/logindf'
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        account, username, password, new_password, phone, email = self.para

        STEP(1, "点击【新增】按钮")
        safe_click((By.XPATH, "//span[contains(text(),'添 加')]"), wd)
        sleep(1)

        STEP(2, f"输入账号：{account}，用户名：{username}，密码：{password}，确认密码: {password}，手机号：{phone}，邮箱：{email}")
        safe_send_keys((By.XPATH, "//input[@id='accountChange']"), account, wd)

        # 输入确认用户名
        safe_send_keys((By.XPATH, "//input[@placeholder='用户名']"), username, wd)

        # 输入密码
        safe_send_keys(
            (By.XPATH, "//input[@placeholder='11位及以上的大小写字母和数字且连续3位及以上不重复和不连续组合']"),
            password, wd)

        # 输入确认密码
        safe_send_keys((By.XPATH, "//input[@placeholder='确认密码']"), password, wd)

        # 点击部门下拉框
        safe_click((By.XPATH, "//div[@class='el-input el-input--suffix']//input[@placeholder='请选择']"), wd)
        # 选择部门
        safe_click((By.XPATH, "/html[1]/body[1]/div[4]/div[1]/div[1]/div[1]/ul[1]/li[1]/label[1]/span[1]/span[1]"), wd)
        # 点击性别单选框
        safe_click((By.XPATH, "//span[contains(text(),'男')]"), wd)
        # 输入手机号和邮箱
        safe_send_keys((By.XPATH, "//input[@placeholder='手机']"), phone, wd)
        safe_send_keys((By.XPATH, "//input[@placeholder='邮箱']"), email, wd)

        sleep(2)
        # 屏幕截图
        SELENIUM_LOG_SCREEN(wd,"50%","User_Manage","User_Main","用户管理主流程-用户信息填入")
        STEP(3, "点击【确定】按钮")
        # 点击确定按钮
        safe_click((By.XPATH, "//div[@aria-label='添加用户']//span[contains(text(),'确定')]"), wd)

        sleep(2)
        notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"),'User_Manage', 'User_Main', '用户管理主流程-用户新增')
        # 检查点：验证提示信息是否与预期相符
        CHECK_POINT('弹出提示', notify_text == "添加成功")

        STEP(4,"管理员退出登录")
        safe_click((By.XPATH, "//img[@title='返回预定首页']"),wd)

        safe_click((By.XPATH, "//img[@title='退出登录']"),wd)

        STEP(5,f"{account}用户登录系统")
        INFO(f"登录账号：{account}，登录密码：{password}，登录验证码：'csba'")
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入账号或手机号或邮箱号']"),account,wd)
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入密码']"),password,wd)
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入图形验证码']"),"csba",wd)
        safe_click((By.XPATH, "//input[@value='登 录']"),wd)

        sleep(2)
        notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"),'User_Manage', 'User_Main', '用户管理主流程-用户首次登录')
        # 检查点：验证提示信息是否与预期相符
        INFO(f"首次登录提示：{notify_text}")
        CHECK_POINT('弹出提示', notify_text == "首次登录，请修改密码")

        STEP(6,f"{account}修改用户密码")
        INFO(f"修改密码为：{new_password}")
        safe_send_keys((By.XPATH, "//body[1]/div[2]/div[1]/div[2]/div[2]/div[2]/div[1]/input[1]"),password,wd)
        safe_send_keys((By.XPATH, "//input[@placeholder='11位及以上的大小写字母和数字且连续3位及以上不重复和不连续组合']"),new_password,wd)
        safe_send_keys((By.XPATH, "//input[@placeholder='请再次输入密码']"),new_password,wd)

        safe_click((By.XPATH, "//span[contains(text(),'确定')]"),wd)

        sleep(2)
        notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"),'User_Manage', 'User_Main', '用户管理主流程-用户密码修改')
        # 检查点：验证提示信息是否与预期相符
        INFO(f"首次登录修改密码提示：{notify_text}")
        CHECK_POINT('弹出提示', notify_text == "修改成功,请重新登录")

        STEP(7,f"{account}用户重新登录系统")
        INFO(f"登录账号：{account}，登录密码：{new_password}，登录验证码：'csba'")
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入账号或手机号或邮箱号']"),account,wd)
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入密码']"),new_password,wd)
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入图形验证码']"),'csba',wd)
        INFO("点击登录按钮")
        sleep(1)
        safe_click((By.XPATH, "//input[@value='登 录']"),wd)

        sleep(2)
        INFO("获取登录信息")
        notify_text = elment_get_text((By.XPATH, "//span[contains(text(),'欢迎 自动化测试公司')]"),wd)

        # 检查点：验证提示信息是否与预期相符
        INFO(f"登录系统提示：{notify_text}")
        CHECK_POINT('登录成功校验', notify_text == "欢迎 自动化测试公司")
        SELENIUM_LOG_SCREEN(wd,"50%","User_Manage","User_Main","用户管理主流程-用户登录")

        # 清除浏览器，再重新打开浏览器
        login_url = get_login_url_from_config("标准版预定系统")
        wd.get(login_url)
        # 最大化浏览器窗口
        wd.maximize_window()
        user_login("admin@ZDH", "Ubains@4321")
        enter_the_backend()

        INFO("打开账号管理下拉菜单")
        safe_click((By.XPATH, "//span[@class='aside_menu menu_account']"), wd)

        INFO("进入用户管理模块")
        safe_click((By.XPATH, "//li[contains(text(),'用户管理')]"), wd)