from time import sleep
import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..')))
from 预定系统.Base.base import *

DEFAULT_WAIT_TIME = 20
# 默认等待时间（秒），用于元素加载或操作之间的等待

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../测试数据/登录模块/账号密码登录.csv')

class Login_00x:
    tags = ['登录功能' , '后台管理功能','预定系统功能']
    """
        执行指令是：
            1.cd 预定系统
            2.hytest --report_title 账号密码登录测试报告 --report_url_prefix http://nat.ubainsyun.com:31133 --test 登录_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
        执行测试步骤以验证登录功能。
        本函数根据参数输入账号、密码和验证码，并检查登录后的提示信息是否与预期相符。
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        username, password, code, check_text = self.para

        # 步骤1：输入账号、密码和验证码
        STEP(1, f"输入账号: {username}, 密码: {password}, 验证码: {code}")
        # 如果用户名不为空，则清空用户名输入框并输入用户名
        safe_send_keys((By.XPATH, '//*[@id="app"]/div/div[3]/div[1]/div[2]/div/form/div[1]/div/input'), username,wd)

        # 如果密码不为空，则清空密码输入框并输入密码
        safe_send_keys((By.XPATH, '//*[@id="app"]/div/div[3]/div[1]/div[2]/div/form/div[2]/div/input'), password,wd)

        # 如果验证码不为空，则清空验证码输入框并输入验证码
        safe_send_keys((By.XPATH, '//*[@id="app"]/div/div[3]/div[1]/div[2]/div/form/div[3]/div[1]/div/input'), code,wd)

        # 步骤2：点击登录按钮
        STEP(2, "点击登录按钮")
        # 等待登录按钮可点击，并点击它
        safe_click((By.XPATH, '//*[@id="app"]/div/div[3]/div[1]/div[2]/div/form/div[4]/input'),wd)

        # 等待1秒以允许页面响应
        sleep(2)
        # 根据预期的检查文本类型，获取并记录提示信息
        if check_text == "admin@ZDH":
            sleep(2)
            notify_text = elment_get_text((By.XPATH, f"//span[normalize-space()='{username}']"),wd)
            SELENIUM_LOG_SCREEN(wd, '50%', 'Login', 'Login_Pwd', f"{name}_检查登录成功提示信息")
            INFO(f"Alert text: {notify_text}")
        else:
            try:
                notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"),'Login','Login_Pwd', f"{name}_检查登录失败提示信息")
                INFO(f"Alert text: {notify_text}")
            except Exception as e:
                INFO(f"Exception occurred: {e}")

        # 步骤3：校验提示信息
        STEP(3, f"校验提示信息: {check_text}")
        # 设置隐式等待时间
        wd.implicitly_wait(DEFAULT_WAIT_TIME)
        # 检查点：验证提示信息是否与预期相符
        CHECK_POINT('弹出提示', check_text in notify_text)

        # 执行步骤 4：刷新页面，以确保下一个测试从一个干净的状态开始
        STEP(4, "刷新页面")
        wd.refresh()