import logging
from time import sleep
import sys
import os

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..')))
from 预定系统.Base.app_base import *
from 预定系统.Base.base import *


# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/展厅巡检/会议补充预约.csv')

class ExhibitionMeetingControl:
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 会议预约测试报告 --report_url_prefix http://nat.ubainsyun.com:31133  --tag 展厅会议室中控屏测试
    """
    tags = ['展厅会议室中控屏测试','展厅巡检']
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
        执行测试步骤以自动化测试腾讯会议应用的登录和会议加入流程。
        该方法初始化应用驱动，等待应用加载，定位并点击会议按钮，加入会议，并截取会议画面。
        """
        # app_drive = None
        # try:
        #     # 初始化应用驱动，连接到指定的设备和应用
        #     app_drive = app_setup_driver("Android", "5.1.1", "UT-12", "com.ubains.gviewer.develop",
        #                                  "com.ubains.gviewer.activity.SplashActivity", "192.168.5.142:5555")
        #     app_drive.implicitly_wait(60)  # 设置缺省等待时间
        #     logging.info("等待登录页加载...")
        #     sleep(20)
        #
        #     # 点击左上角logo进入后台
        #     enter_back_button = app_drive.find_element(AppiumBy.XPATH,
        #                                                "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.Button[1]")
        #     logging.info("点击左上角logo进入后台")
        #     enter_back_button.click()
        #     sleep(10)
        #
        #     # 点击【系统关】按钮
        #     system_off_button = app_drive.find_element(AppiumBy.XPATH,
        #                                                "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.FrameLayout/android.widget.RelativeLayout[2]/android.widget.Button[9]")
        #     logging.info("点击【系统关】按钮")
        #     system_off_button.click()
        #     sleep(10)
        #
        #     # 点击【主页】按钮
        #     home_button = app_drive.find_element(AppiumBy.XPATH,
        #                                                "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.FrameLayout/android.widget.RelativeLayout[2]/android.widget.Button[1]")
        #     logging.info("点击【主页】按钮，返回主页界面")
        #     home_button.click()
        #     sleep(10)
        #
        #     # 点击【离开模式】按钮
        #     quit_button = app_drive.find_element(AppiumBy.XPATH,
        #                                                "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.FrameLayout/android.widget.RelativeLayout[3]/android.widget.Button[15]")
        #     logging.info("点击【离开模式】按钮")
        #     quit_button.click()
        #     sleep(10)
        #
        #     # 点击【确定】按钮
        #     safe_click_button = app_drive.find_element(AppiumBy.XPATH,
        #                                                "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.FrameLayout/android.widget.RelativeLayout[4]/android.widget.Button[1]")
        #     logging.info("点击【确定】按钮，展厅会议室环境设备已断电。")
        #     safe_click_button.click()
        #     sleep(10)
        #
        # except Exception as e:
        #     # 捕获并记录任何发生的错误
        #     logging.error(f"发生错误: {e}", exc_info=True)

        # 补充预定系统会议创建
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        name = self.name
        conference_name, message_name, book_type, check_text = self.para

        # 在会议室列表搜索会议室
        STEP(1, f"在会议室列表搜索：{conference_name}")
        # 展开筛选下拉框
        safe_click((By.XPATH, "//i[@class='el-collapse-item__arrow el-icon-arrow-right']"), wd)
        sleep(1)
        # 输入会议室名称，并点击【查询】按钮
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议室名称']"), conference_name, wd)
        safe_click((By.XPATH, "//button[@type='button']//span[contains(text(),'查询')]"), wd)
        sleep(1)

        # 点击【会议预定】按钮，进入会议预定界面
        STEP(2, "点击【会议预定】按钮")
        safe_click((By.XPATH, "//span[@class='MeetingCityList_t_btn']"), wd)
        sleep(1)

        # 在会议预定第一步界面进行数据填入
        STEP(3, "会议第一步数据填写")
        INFO(
            f"输入会议名称：{message_name}，选择会议类型：视讯融合会议，SMC3.0视频会议，腾讯会议，选择预约类型：{book_type}")
        # 输入会议名称
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议名称']"), message_name, wd)

        # 判断会议类型
        safe_click((By.XPATH,
                    "//div[@class='reserve_input']//span[@class='el-checkbox__label'][normalize-space()='SMC3.0视频会议']"),
                   wd)
        safe_click((By.XPATH,
                    f"//div[@class='reserve_input']//span[@class='el-checkbox__label'][normalize-space()='讯飞语音转录']"),
                   wd)
        safe_click((By.XPATH,
                    f"//div[@class='reserve_input']//span[@class='el-checkbox__label'][normalize-space()='腾讯会议']"),
                   wd)
        sleep(2)

        # 选择签到时间
        INFO("选择提前30分钟开始签到")
        safe_click((By.XPATH, "(//span[@class='el-switch__core'])[2]"), wd)
        safe_click((By.XPATH, "(//span[@class='el-switch__core'])[3]"), wd)
        sleep(1)
        safe_send_keys((By.XPATH, "//input[@id='input_checkin']"), "30", wd)

        # 调用函数根据当前时间进行选择
        current_time = get_current_time_formatted()
        INFO(f"获取当前的时间{current_time}")
        safe_click((By.XPATH, f"//div[normalize-space()='{current_time}']"), wd)
        sleep(2)
        # 选择会议结束时间
        safe_click((By.XPATH, "//div[normalize-space()='09:00']"), wd)
        sleep(1)

        # 在会议预定第二步界面进行数据填入
        STEP(4, "会议第二步数据填写")
        # 点击【下一步】进入会议预定第二步界面
        safe_click((By.XPATH, "//div[contains(text(),'下一步')]"), wd)
        sleep(1)

        # 根据参会人名称搜搜对应参会人
        ipn = ['赵嘉诚', 'CZJ', '马晓丽', '王兵', '陈林', '李立键', '丁海洪', '刘建胜', '潘松林', '卢培锽',
                '黄史恭', '罗一龙', '彭甘宇']
        for i in range(0, 13):
            safe_send_keys((By.XPATH, "//input[@placeholder='账号/用户名']"), ipn[i], wd)
            send_keyboard((By.XPATH, "//input[@placeholder='账号/用户名']"), wd)
            sleep(1)
            # 选择内部参会人
            safe_click((By.XPATH,
                        "//th[contains(@class,'is-leaf el-table__cell')]//span[contains(@class,'el-checkbox__inner')]"),
                        wd)
            # 获取已选的参会人名称
            # notify_text = elment_get_text((By.XPATH, f"//span[normalize-space()='{ipn[i]}']"), wd)
        INFO(f"已选择参会人：{ipn}")
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "Server_Monitoring", "选择内部参会人")

        # 点击【下一步】按钮
        safe_click((By.XPATH, "//div[contains(text(),'下一步')]"), wd)
        sleep(1)
        safe_click((By.XPATH, "//div[contains(text(),'下一步')]"), wd)

        # 进入会议预约第三步进行填写
        STEP(5, "会议第三步数据填写")
        # 取消短信提醒
        safe_click(
            (By.XPATH, "//div[@class='Sendout']//span[@class='el-checkbox__label'][contains(text(),'全选')]"), wd)
        sleep(2)
        safe_click(
            (By.XPATH, "//div[@class='Sendout']//span[@class='el-checkbox__label'][contains(text(),'全选')]"), wd)

        # 点击【确定】按钮
        STEP(6, "点击【确定】按钮")
        safe_click((By.XPATH, "//div[contains(text(),'确定')]"), wd)

        # 点击最后【确定】按钮，预定成功后会跳转至已预定界面
        STEP(7, "点击【确定】按钮")
        safe_click((By.XPATH, "//div[contains(@aria-label,'会议信息')]//span[contains(text(),'确定')]"), wd)
        sleep(3)
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "Server_Monitoring", "预定会议成功界面")