import logging
from time import sleep
import sys
import os

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..')))
from 预定系统.Base.app_base import *
from 预定系统.Base.base import *

# 配置日志记录
logging.basicConfig(level=logging.DEBUG, format='%(asctime)s - %(levelname)s - %(message)s')

class ExhibitionMeetingControl:
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 会议预约测试报告 --report_url_prefix http://nat.ubainsyun.com:31133 --tag 展厅会议室中控屏
    """
    tags = ['展厅会议室中控屏','展厅巡检','展厅讯飞转录流程测试']

    def teststeps(self):
        """
        执行测试步骤以自动化测试腾讯会议应用的登录和会议加入流程。
        该方法初始化应用驱动，等待应用加载，定位并点击会议按钮，加入会议，并截取会议画面。
        """
        app_drive = None
        wd = GSTORE['wd']
        try:
            # 初始化应用驱动，连接到指定的设备和应用
            app_drive = app_setup_driver("Android", "5.1.1", "UT-12", "com.ubains.gviewer",
                                         ".activity.SplashActivity", "192.168.5.142:5555")
            app_drive.implicitly_wait(60)  # 设置缺省等待时间
            INFO("等待登录页加载...")
            sleep(30)
            # # 进入后台设置界面
            # background_button = app_drive.find_element(AppiumBy.XPATH,
            #                                         "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.Button[1]")
            # background_button.click()
            # INFO("进入后台设置界面")
            # sleep(10)
            # # 点击【系统开】按钮
            # system_up_button = app_drive.find_element(AppiumBy.XPATH,
            #                                            "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.FrameLayout/android.widget.RelativeLayout[2]/android.widget.Button[10]")
            # system_up_button.click()
            # INFO("点击【系统开】按钮完成")
            # sleep(10)
            # # 返回主页界面
            # home_button = app_drive.find_element(AppiumBy.XPATH,
            #                                      "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.FrameLayout/android.widget.RelativeLayout[3]/android.widget.Button[4]")
            # home_button.click()
            # INFO("返回主页界面")
            # sleep(5)

            # 点击【进入系统】按钮
            enter_system_button = app_drive.find_element(AppiumBy.XPATH,
                                   '//android.widget.FrameLayout[@content-desc="10005"]/android.widget.Button')
            enter_system_button.click()
            sleep(10)

            INFO("进入系统")
            # 点击【确认】按钮
            INFO("点击【确认】按钮")
            confirm_button = app_drive.find_element(AppiumBy.XPATH,
                                                    '//android.widget.FrameLayout[@content-desc="10033"]/android.widget.Button')
            confirm_button.click()
            sleep(10)
            # 在当前界面截图
            get_screenshot_with_retry(wd, app_drive, "Exhibit_Inspect", "ExhibitionConferenceControlScreen",
                                      "【进入系统】界面")

            # 进入视频会议模式，使用摄像头跟踪功能
            INFO("进入视频会议模式")
            video_meeting_button = app_drive.find_element(AppiumBy.XPATH,
                                                          '//android.widget.FrameLayout[@content-desc="10017"]/android.widget.Button')
            video_meeting_button.click()
            sleep(10)
            # 在当前界面截图
            get_screenshot_with_retry(wd, app_drive, "Exhibit_Inspect","ExhibitionConferenceControlScreen", "进入【视频模式】界面")

            # 点击【入住式会议】按钮
            INFO("点击【入住式会议】按钮")
            enter_meeting_button = app_drive.find_element(AppiumBy.XPATH,
                                                          '//android.widget.FrameLayout[@content-desc="10042"]/android.widget.Button')
            enter_meeting_button.click()
            sleep(10)
            # 在当前界面截图
            get_screenshot_with_retry(wd, app_drive, "Exhibit_Inspect", "ExhibitionConferenceControlScreen",
                                      "进入【入住时会议】界面")

            # 点击【摄像头跟踪】按钮
            INFO("点击【摄像头跟踪】按钮")
            camera_tracking_button = app_drive.find_element(AppiumBy.XPATH,
                                                           '//android.widget.FrameLayout[@content-desc="10529"]/android.widget.Button')
            camera_tracking_button.click()
            sleep(10)
            # 在当前界面截图
            get_screenshot_with_retry(wd, app_drive, "Exhibit_Inspect", "ExhibitionConferenceControlScreen",
                                      "进入【摄像头跟踪】界面")

            #选择左屏进行摄像头跟踪
            INFO("选择左屏进行摄像头跟踪")
            left_screen_button = app_drive.find_element(AppiumBy.XPATH,
                                                          '//android.widget.FrameLayout[@content-desc="10100"]/android.widget.Button')
            left_screen_button.click()
            sleep(5)
            # 在当前界面截图
            get_screenshot_with_retry(wd, app_drive, "Exhibit_Inspect", "ExhibitionConferenceControlScreen",
                                      "左屏摄像头进行跟踪")

            # 返回上一级界面
            INFO("返回上一级界面")
            back_button = app_drive.find_element(AppiumBy.XPATH,
                                                 '//android.widget.FrameLayout[@content-desc="10105"]/android.widget.Button')
            back_button.click()
            sleep(5)

            # 点击无纸化
            INFO("点击无纸化")
            no_paper_button = app_drive.find_element(AppiumBy.XPATH,
                                                          '//android.widget.FrameLayout[@content-desc="10538"]/android.widget.Button')
            no_paper_button.click()
            sleep(5)
            # 在当前界面截图
            get_screenshot_with_retry(wd, app_drive, "Exhibit_Inspect", "ExhibitionConferenceControlScreen",
                                      "无纸化界面")

            # 点击【全部上升】按钮
            INFO("点击【全部上升】按钮")
            all_up_button = app_drive.find_element(AppiumBy.XPATH,
                                                    '//android.widget.FrameLayout[@content-desc="10150"]/android.widget.Button')
            all_up_button.click()
            sleep(5)
            # 在当前界面截图
            get_screenshot_with_retry(wd, app_drive, "Exhibit_Inspect", "ExhibitionConferenceControlScreen",
                                      "点击【全部上升】按钮")
#
            # 点击【返回】按钮
            INFO("点击【返回】按钮")
            back_button = app_drive.find_element(AppiumBy.XPATH,
                                                    '//android.widget.FrameLayout[@content-desc="10167"]/android.widget.Button')
            back_button.click()
            sleep(5)

            # 点击左上角logo进入后台
            # 等待元素可见，并在可见后执行长按操作。
            enter_back_button = app_drive.find_element(AppiumBy.XPATH,
                                                       '//android.widget.FrameLayout[@content-desc="10541"]/android.widget.Button')
            INFO("点击左上角logo进入后台")
            enter_back_button.click()
            sleep(3)
            # 在当前界面截图
            get_screenshot_with_retry(wd, app_drive, "Exhibit_Inspect", "ExhibitionConferenceControlScreen",
                                      "后台界面")

            INFO("尝试定位麦克风按钮")
            mic_on_button = app_drive.find_element(AppiumBy.XPATH,
                                                   "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.FrameLayout/android.widget.RelativeLayout[2]/android.widget.Button[2]")
            INFO("开启麦克风")
            mic_on_button.click()
            sleep(2)
            # 在当前界面截图
            get_screenshot_with_retry(wd, app_drive, "Exhibit_Inspect", "ExhibitionConferenceControlScreen",
                                      "开启桌面麦克风")

            # 云喇叭参数
            app_id = os.getenv("APP_ID", "a98a124c6c3252f6612fc544a0d0fa79")
            app_secret = os.getenv("APP_SECRET", "88bc1ec4eba624f47b2200a4ce8c3852")
            device_sn = os.getenv("DEVICE_SN", "W703BB44444")
            play_cloud_voice(app_id, app_secret, device_sn)
            sleep(20)
            # 关闭麦克风
            # mic_off_button = app_drive.find_element(AppiumBy.XPATH,
            #                                         "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.FrameLayout/android.widget.RelativeLayout[5]/android.widget.Button[3]")
            # INFO("关闭麦克风")
            # mic_off_button.click()

            # 进入“已预定列表”界面，结束这场会议
            safe_click((By.XPATH, "//span[contains(text(),'已预订会议')]"), wd)
            # 搜索会议
            safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字搜索']"), "展厅巡检", wd)
            sleep(1)
            send_keyboard((By.XPATH, "//input[@placeholder='输入关键字搜索']"), wd)

            # 点击【更多操作】
            safe_click((By.XPATH, "//span[contains(text(),'更多操作')]"), wd)
            sleep(3)
            # 点击【会议状态】按钮
            safe_click((By.XPATH, "//li[contains(text(),'会议状态')]"), wd)
            sleep(3)
            # 点击【结束会议】按钮，并点击【确定】按钮结束这场会议
            safe_click((By.XPATH, "//span[contains(text(),'提前结束')]"), wd)
            sleep(2)
            safe_click((By.XPATH, "//div[@slot='footer']//span[contains(text(),'确定')]"), wd)
            sleep(2)
            safe_click((By.XPATH, "//button[@class='el-button el-button--default el-button--small el-button--primary ']//span[contains(text(),'确定')]"), wd)


        except Exception as e:
            # 捕获并记录任何发生的错误
            logging.error(f"发生错误: {e}", exc_info=True)