import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/会议室管理/功能管理模块/功能编辑.csv')

class Function_Edit_000x:
    tags = ['会议室功能管理' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 功能编辑测试报告 --report_url_prefix http://nat.ubainsyun.com:13233 --test 功能编辑_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以用户新增功能。
            本函数根据参数输入账号、用户名、密码、确认密码、部门、性别、手机号和邮箱，并检查新增后的提示信息是否与预期相符。
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        function_name, new_function_name, new_function_detail, function_type, check_text = self.para

        STEP(1, f"输入功能名称：{function_name}，进行搜索")
        safe_send_keys((By.XPATH,"//input[@placeholder='输入关键字']"),function_name,wd)
        send_keyboard((By.XPATH,"//input[@placeholder='输入关键字']"),wd)
        sleep(1)
        notify_text = elment_get_text((By.XPATH,"//tbody/tr[@class='el-table__row']/td[2]/div[1]"),wd)
        INFO(f"搜索结果为：{notify_text}")
        CHECK_POINT("搜索结果与预期相符", notify_text == function_name)

        STEP(2, "点击【编辑】按钮")
        safe_click((By.XPATH,"//span[@class='el-tag el-tag--success el-tag--light']"),wd)
        notify_text = elment_get_text((By.XPATH,"//span[contains(text(),'修改功能')]"),wd)
        INFO(f"当前弹窗标题为：{notify_text}")
        CHECK_POINT("弹窗标题与预期相符", notify_text == "修改功能")

        STEP(3, "输入新的功能名称、功能描述")
        INFO(f"输入功能名称：{new_function_name}，输入功能描述：{new_function_detail}")
        safe_send_keys((By.XPATH, "//input[@placeholder='功能名称']"), new_function_name, wd)
        safe_send_keys((By.XPATH, "//input[@placeholder='功能描述']"), new_function_detail, wd)

        STEP(4, "选择功能类型")
        INFO(f"选择功能类型：{function_type}")
        safe_click((By.XPATH, "//div[@class='el-input el-input--suffix']//input[@placeholder='请选择']"), wd)
        sleep(1)
        # 判断功能类型，使用对应的定位方式
        if function_type == "普通" or function_type == "语音转录" or function_type == "腾讯会议" or function_type == "华为云会议":
            safe_click((By.XPATH, f"//span[contains(text(),'{function_type}')]"), wd)

        else:
            safe_click((By.XPATH, f"//span[normalize-space()='{function_type}']"), wd)

        STEP(4, "点击【确定】按钮")
        safe_click((By.XPATH, "//div[contains(@aria-label,'修改功能')]//span[contains(text(),'确定')]"), wd)
        sleep(2)

        STEP(5, "检查修改结果")
        notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"), "Function_Manage", "Function_Edit",
                                      f"{name}检查提示信息")
        INFO(f"修改结果为：{notify_text}")
        CHECK_POINT("修改结果检查", check_text in notify_text)

        if check_text != "修改成功":
            INFO("check_text不等于修改成功")
            # 返回功能列表
            safe_click((By.XPATH, "//div[@aria-label='修改功能']//i[@class='el-dialog__close el-icon el-icon-close']"),
                       wd)

        # 刷新页面元素
        if name == '功能编辑_022':
            wd.refresh()