import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/会议室管理/功能管理模块/功能新增.csv')

class Function_Add_000x:
    tags =['会议室功能管理' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 功能新增测试报告 --report_url_prefix http://nat.ubainsyun.com:13233 --test 功能新增_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以功能新增功能。
            本函数根据参数输入功能名称、功能描述和功能类型，并检查新增后的提示信息是否与预期相符。
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        function_name, function_detail, function_type, check_text = self.para

        STEP(1, "点击【添加】按钮")
        safe_click((By.XPATH,"//span[contains(text(),'添 加')]"),wd)
        notify_text = elment_get_text((By.XPATH,"//span[contains(text(),'添加功能')]"),wd)
        INFO(f"当前弹窗标题为：{notify_text}")
        CHECK_POINT("弹窗标题检查", notify_text == "添加功能")

        STEP(2, "输入功能名称、功能描述")
        INFO(f"输入功能名称：{function_name}，输入功能描述：{function_detail}")
        safe_send_keys((By.XPATH,"//input[@placeholder='功能名称']"),function_name,wd)
        safe_send_keys((By.XPATH,"//input[@placeholder='功能描述']"),function_detail,wd)

        STEP(3, "选择功能类型")
        INFO(f"选择功能类型：{function_type}")
        safe_click((By.XPATH,"//div[@class='el-input el-input--suffix']//input[@placeholder='请选择']"),wd)
        sleep(1)
        # 判断功能类型，使用对应的定位方式
        if function_type == "普通" or function_type == "语音转录" or function_type == "腾讯会议" or function_type == "华为云会议":
            safe_click((By.XPATH,f"//span[contains(text(),'{function_type}')]"),wd)

        else:
            safe_click((By.XPATH,f"//span[normalize-space()='{function_type}']"),wd)

        STEP(4, "点击【确定】按钮")
        safe_click((By.XPATH,"//div[@aria-label='添加功能']//span[contains(text(),'确定')]"),wd)
        sleep(2)

        STEP(5, "检查新增结果")
        notify_text = get_notify_text(wd,(By.XPATH,"//p[@class='el-message__content']"),"Function_Manage","Function_Add",f"{name}检查提示信息")
        INFO(f"新增结果为：{notify_text}")
        CHECK_POINT("新增结果检查", notify_text == check_text)

        if notify_text !=  "添加成功":
            # 返回功能列表
            safe_click((By.XPATH,"//div[@aria-label='添加功能']//i[@class='el-dialog__close el-icon el-icon-close']"),wd)

        # 刷新页面元素
        if name == '功能新增_021':
            wd.refresh()