import sys
import os
from 运维集控.项目测试.运维标准版.lib.base import *
from hytest.common import SELENIUM_LOG_SCREEN

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..', '..')))
# 构建 CSV 文件的绝对路径
csv_path = os.path.abspath(
    os.path.join(os.path.dirname(__file__), '..', '..', 'testdata', '02用户管理', '删除用户.csv'))

class Userdelete:
    tags = ['删除用户']
    #构建框架的数据集格式
    ddt_cases = read_csv_data(csv_path)

    def teststeps(self):
        wd = GSTORE['wd']

        #从self.para中解构出数据
        name = self.name
        account, user_name, new_passwd, comfire_passwd, authority, user_number, phone, email, remark, info= self.para

        STEP(1, f'搜索并勾选用户：{user_name}')
        user_query = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable((By.XPATH, "//input[@placeholder='请输入名称']"))
        )
        user_query.clear()
        user_query.send_keys(user_name)

        select_click= WebDriverWait(wd, 10).until(
            EC.presence_of_element_located((By.XPATH, "//th[contains(@class,'is-leaf el-table__cell')]//span[contains(@class,'el-checkbox__inner')]"))
        )
        select_click.click()

        STEP(2, '点击删除按钮')
        user_update = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable((By.XPATH, "//span[contains(text(),'删除')]"))
        )
        user_update.click()

        STEP(3, '点击确认')
        commit = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable((By.XPATH, "//button[contains(@class,'el-button el-button--default el-button--small el-button--primary')]//span[contains(text(),'确 定')]"))
        )
        commit.click()

        STEP(4, '验证是否删除成功')
        get_menu = WebDriverWait(wd, 10).until(
            EC.visibility_of_element_located((By.XPATH, "//p[@class='el-message__content']"))
        )
        get_menu1 = get_menu.text
        CHECK_POINT('检查是否出现成功提示弹窗', get_menu1 == "操作成功!")

        # 截图并保存
        SELENIUM_LOG_SCREEN(wd, "50%")
        wd.refresh()
