from hytest.common import SELENIUM_LOG_SCREEN

from 运维集控.项目测试.运维标准版.lib.base import *

#构建当前项目路径
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..', '..')))
# 构建 CSV 文件的绝对路径
csv_path = os.path.abspath(
    os.path.join(os.path.dirname(__file__), '..', '..', 'testdata', '02用户管理', '新增用户.csv'))

class UserAdd:
    tags = ['新增用户']
    #构建框架的数据集格式
    ddt_cases = read_csv_data(csv_path)

    def teststeps(self):
        wd = GSTORE['wd']

        #从self.para中解构出数据
        name = self.name
        account, user_name, new_passwd, comfire_passwd, authority, user_number, phone, email, remark, info= self.para

        STEP(1, '点击新增按钮')
        user_add = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//div[@class='company-edmit-right']//span[contains(text(),'新增')]"))
        )
        user_add.click()
        sleep(2)

        STEP(2, f'填写登录名: {account}')
        account_input = WebDriverWait(wd, 20).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='登录名以字母开头，长度在5-18之间，只能包含字母、数字和下划线、@']"))
        )
        account_input.clear()
        account_input.send_keys(account)

        STEP(3, f'填写用户名称: {user_name}')
        user_name_input = WebDriverWait(wd, 20).until(
            EC.presence_of_element_located(
                (By.XPATH, "//div[@class='el-input el-input--suffix']//input[@placeholder='请输入名称']"))
        )
        user_name_input.clear()
        user_name_input.send_keys(user_name)

        STEP(4, f'填写新的密码: {new_passwd}')
        new_passwd_input = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='必须包含字母（不区分大小写）、数字和特殊字符，至少8个字符']"))
        )
        new_passwd_input.clear()
        new_passwd_input.send_keys(new_passwd)

        STEP(5, f'填写确认密码: {comfire_passwd}')
        comfire_passwd_input = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='请确认密码']"))
        )
        comfire_passwd_input.clear()
        comfire_passwd_input.send_keys(comfire_passwd)

        STEP(6, f'选择权限: {authority}')
        authority_select = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//span[@class='el-radio__label'][contains(text(),'普通用户')]"))
        )
        authority_select.click()

        STEP(7, f'填写用户工号: {user_number}')
        user_number_input = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='请输入工号']"))
        )
        user_number_input.clear()
        user_number_input.send_keys(user_number)

        STEP(8, f'填写手机号: {phone}')
        phone_input = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='请输入手机号码']"))
        )
        phone_input.clear()
        phone_input.send_keys(phone)

        STEP(9, f'填写邮箱: {email}')
        email_input = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='请输入邮箱']"))
        )
        email_input.clear()
        email_input.send_keys(email)

        STEP(10, f'填写备注: {remark}')
        remark_input = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='备注']"))
        )
        remark_input.clear()
        remark_input.send_keys(remark)

        STEP(11, '点击“确认”按钮')
        commit = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//div[@aria-label='新增']//span[contains(text(),'确 定')]"))
        )
        commit.click()

        STEP(12, f'预期提示内容为：{info}')

        STEP(13, '获取页面实际提示内容')
        get_menu = WebDriverWait(wd, 10).until(
            EC.visibility_of_element_located(
                (By.XPATH, "//p[@class='el-message__content']"))
        )
        get_menu1 = get_menu.text

        CHECK_POINT('校验实际提示内容和预期提示内容是否一致', get_menu1 == info)
        # 截图并保存
        SELENIUM_LOG_SCREEN(wd, "50%")
        wd.refresh()