## 📝 业务操作流程

### 一、远程容器升级操作流程

### 三、本地容器部署操作流程（交互式模式）

#### 业务场景

技术人员拿到运维人员通过 `upload_to_nas.sh` 脚本上传到网盘的压缩文件后，在项目服务器上解压缩，解压缩后执行 `./container_update.sh` 命令进行容器更新操作。

**典型使用流程**：
1. 运维人员在主服务器执行 `upload_to_nas.sh` 打包上传镜像到网盘
2. 技术人员从网盘下载压缩包到项目服务器
3. 解压缩：`tar -xzf container-images_xxx.tar.gz`
4. 进入解压目录：`cd container-images_xxx`
5. 执行部署脚本：`./container_update.sh`

#### 交互式模式需求流程

| 步骤 | 功能描述 | 状态 |
|------|----------|------|
| 步骤1 | 询问更新哪个容器 | ✅ 已实现 |
| 步骤2 | 判断压缩包中是否存在该容器更新所需的镜像以及新增文件 | ✅ 已实现 |
| 步骤3 | 判断当前服务器是传统平台还是新统一平台 | ✅ 已实现 |
| 步骤4 | 判断当前服务器上是否存在容器在运行，如果有就先停止（不做删除操作） | ✅ 已实现 |
| 步骤5 | 备份原有配置文件 | ❌ 待开发 |
| 步骤6 | 更新新的配置文件到指定目录，并将新配置文件内的IP地址改为当前服务器的IP地址 | ❌ 待开发 |
| 步骤7 | 进行容器更新部署操作 | ✅ 已实现 |
| 步骤8 | 查看容器是否部署完成 | ✅ 已实现 |
| 步骤9 | 记录所有操作的日志信息保存到当前目录下为日志审计文件 | ✅ 已实现 |

#### 交互式模式（推荐）

直接运行脚本，无需参数：

```bash
./container_update.sh
```

##### 步骤 1：选择要更新的容器

```
[2025-12-08 10:00:00] [INFO] ==================================================================
[2025-12-08 10:00:00] [INFO] 容器部署工具 - 交互式模式
[2025-12-08 10:00:00] [INFO] ==================================================================
[2025-12-08 10:00:00] [INFO] 日志文件: /path/to/container_update_20251208_100000.log
[2025-12-08 10:00:00] [INFO] 脚本目录: /path/to/container-images
[2025-12-08 10:00:00] [INFO] ==================================================================

[2025-12-08 10:00:00] [INFO] ==================================================================
[2025-12-08 10:00:00] [INFO] 步骤 1/4：选择要更新的容器
[2025-12-08 10:00:00] [INFO] ==================================================================

[2025-12-08 10:00:00] [INFO] 可选择的容器类型：
  [1] ujava      - Java 服务容器
  [2] uemqx      - EMQX 消息队列容器
  [3] uredis     - Redis 缓存容器
  [4] upython    - Python 服务容器
  [5] unacos     - Nacos 注册中心容器
  [6] unginx     - Nginx 反向代理容器

请输入容器编号 (1-6): 1
[2025-12-08 10:00:02] [INFO] ✅ 已选择容器类型: ujava (Java 服务容器)
```

##### 步骤 2：检查所需镜像和配置文件

```
[2025-12-08 10:00:02] [INFO] ==================================================================
[2025-12-08 10:00:02] [INFO] 步骤 2/4：检查所需镜像和配置文件
[2025-12-08 10:00:02] [INFO] ==================================================================
[2025-12-08 10:00:02] [INFO] 检查 ujava 容器所需文件...
[2025-12-08 10:00:02] [INFO]   所需镜像文件: java1.8.0_472.tar.gz
[2025-12-08 10:00:02] [INFO] ✅ 找到镜像文件: /path/to/java1.8.0_472.tar.gz
[2025-12-08 10:00:02] [INFO]    文件大小: 1.2G
[2025-12-08 10:00:02] [INFO] ✅ 部署脚本存在: /path/to/container_update.sh
```

##### 步骤 3：检测服务器平台类型

```
[2025-12-08 10:00:03] [INFO] ==================================================================
[2025-12-08 10:00:03] [INFO] 步骤 3/4：检测服务器平台类型
[2025-12-08 10:00:03] [INFO] ==================================================================
[2025-12-08 10:00:03] [INFO] 自动检测平台类型...
[2025-12-08 10:00:03] [INFO]   检测依据: /data/services 目录是否存在
[2025-12-08 10:00:03] [INFO] ✅ 检测到 /data/services 目录存在
[2025-12-08 10:00:03] [INFO] ✅ 识别为: 新统一平台 (使用 /data/ 目录结构)

当前识别为 [新统一平台]，是否正确? (y/n) [默认 y]: y
[2025-12-08 10:00:04] [INFO] ✅ 平台类型确认: new
```

##### 步骤 4：检查并停止正在运行的容器

```
[2025-12-08 10:00:04] [INFO] ==================================================================
[2025-12-08 10:00:04] [INFO] 步骤 4/4：检查并停止正在运行的容器
[2025-12-08 10:00:04] [INFO] ==================================================================
[2025-12-08 10:00:04] [INFO] 检查是否存在 ujava 类型的容器在运行...
[2025-12-08 10:00:04] [INFO] 发现以下 ujava 类型的容器:
     - ujava1 (状态: exited)
     - ujava2 (状态: running)
[2025-12-08 10:00:04] [WARN] ⚠️ 检测到容器 ujava2 正在运行

是否停止该容器以便进行更新? (y/n) [默认 y]: y
[2025-12-08 10:00:05] [INFO] 正在停止容器 ujava2...
[2025-12-08 10:00:08] [INFO] ✅ 容器 ujava2 已停止
[2025-12-08 10:00:08] [INFO] ✅ 新容器将命名为: ujava3
```

##### 步骤 5：确认并执行部署

```
[2025-12-08 10:00:08] [INFO] ==================================================================
[2025-12-08 10:00:08] [INFO] 部署信息确认
[2025-12-08 10:00:08] [INFO] ==================================================================
[2025-12-08 10:00:08] [INFO]   容器类型: ujava (Java 服务容器)
[2025-12-08 10:00:08] [INFO]   新容器名: ujava3
[2025-12-08 10:00:08] [INFO]   平台类型: new
[2025-12-08 10:00:08] [INFO]   镜像文件: /path/to/java1.8.0_472.tar.gz
[2025-12-08 10:00:08] [INFO]   旧容器:   ujava2 (已停止)
[2025-12-08 10:00:08] [INFO] ==================================================================

确认开始部署? (y/n) [默认 y]: y
[2025-12-08 10:00:10] [INFO] ==================================================================
[2025-12-08 10:00:10] [INFO] 开始执行部署
[2025-12-08 10:00:10] [INFO] ==================================================================
[2025-12-08 10:00:10] [INFO] 开始部署 ujava (容器: ujava3, 平台: new)
```

##### 步骤 6：部署完成

```
[2025-12-08 10:01:00] [INFO] ==================================================================
[2025-12-08 10:01:00] [INFO] 部署流程结束
[2025-12-08 10:01:00] [INFO] ==================================================================
[2025-12-08 10:01:00] [INFO] 日志文件已保存到: /path/to/container_update_20251208_100000.log
```