## 📝 业务操作流程

### 一、远程容器升级操作流程

### 二、镜像打包上传网盘操作流程

以下是将容器镜像打包并上传至公司 NAS 网盘的完整操作步骤：

#### 步骤 1：启动打包上传脚本

在镜像目录下执行上传脚本：

```bash
cd /path/to/container-images
./upload_to_nas.sh
```

或指定要打包的目录：

```bash
./upload_to_nas.sh /data/temp/container-images
```

#### 步骤 2：等待目录打包

脚本会自动将目录压缩为 tar.gz 格式，并显示打包进度：

```
[2025-12-08 10:30:00] [INFO] ==================================================================
[2025-12-08 10:30:00] [INFO] 容器镜像打包上传工具
[2025-12-08 10:30:00] [INFO] ==================================================================
[2025-12-08 10:30:00] [INFO] 源目录: /data/temp/container-images
[2025-12-08 10:30:00] [INFO] 打包文件: /tmp/container-images_20251208_103000.tar.gz
[2025-12-08 10:30:00] [INFO] 目标网盘: \\192.168.9.9\home\容器镜像包
[2025-12-08 10:30:00] [INFO] ==================================================================
[2025-12-08 10:30:01] [INFO] [步骤 1/3] 打包目录...
[2025-12-08 10:30:01] [INFO] 开始打包目录: /data/temp/container-images
 1.2GiB 0:00:24 [50.0MiB/s] [================================>] 100%
[2025-12-08 10:30:25] [INFO] ✅ 打包完成，文件大小: 1.2G
```

#### 步骤 3：等待 NAS 挂载

脚本自动挂载公司 NAS 网盘：

```
[2025-12-08 10:30:26] [INFO] [步骤 2/3] 挂载 NAS...
[2025-12-08 10:30:26] [INFO] 正在挂载 NAS: //192.168.9.9/home
[2025-12-08 10:30:27] [INFO] ✅ NAS 挂载成功
```

#### 步骤 4：等待文件上传

上传过程会显示进度条：

```
[2025-12-08 10:30:28] [INFO] [步骤 3/3] 上传文件...
[2025-12-08 10:30:28] [INFO] 开始上传文件到 NAS...
[2025-12-08 10:30:28] [INFO] 源文件: /tmp/container-images_20251208_103000.tar.gz
[2025-12-08 10:30:28] [INFO] 目标: //192.168.9.9/home/容器镜像包/container-images_20251208_103000.tar.gz
 1.2GiB 0:01:30 [13.6MiB/s] [================================>] 100%
[2025-12-08 10:32:00] [INFO] ✅ 上传完成！
[2025-12-08 10:32:00] [INFO]    文件路径: \\192.168.9.9\home\容器镜像包\container-images_20251208_103000.tar.gz
[2025-12-08 10:32:00] [INFO]    文件大小: 1.2G
```

#### 步骤 5：确认上传结果

```
[2025-12-08 10:32:01] [INFO] 清理临时文件...
[2025-12-08 10:32:01] [INFO] ==================================================================
[2025-12-08 10:32:01] [INFO] 🎉 全部完成！
[2025-12-08 10:32:01] [INFO] ==================================================================
```

#### 网盘信息

| 配置项 | 值 |
|--------|-----|
| 服务器地址 | `\\192.168.9.9\home` |
| 账号 | 陈泽键 |
| 上传目录 | 容器镜像包/ |
| 协议 | SMB/CIFS |

#### 命令行选项

```bash
# 显示帮助
./upload_to_nas.sh -h

# 指定打包文件名
./upload_to_nas.sh -n java_container_v6 /data/temp/java

# 指定上传子目录
./upload_to_nas.sh -d 测试包 /data/temp/test
```

---