import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/会议室管理/功能管理模块/功能删除.csv')

class Function_Delete_000x:
    tags = ['会议室功能管理' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 功能删除测试报告 --report_url_prefix http://nat.ubainsyun.com:13233 --test 功能删除_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以用户新增功能。
            本函数根据参数输入账号、用户名、密码、确认密码、部门、性别、手机号和邮箱，并检查新增后的提示信息是否与预期相符。
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        function_name, del_type, check_text = self.para

        # 步骤1：查询功能名称
        STEP(1, f"查询功能名称：{function_name}")
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), function_name, wd)
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
        sleep(1)

        # 根据del_type执行不同的删除操作
        if del_type == "单个删除":
            # 步骤2：选择单个删除
            STEP(2, "选择单个删除")
            safe_click((By.XPATH, "(//i[contains(text(),'删除')])[1]"), wd)
            sleep(1)

            # 步骤3：检查弹窗内容
            STEP(3, "检查弹窗内容")
            notify_text = elment_get_text((By.XPATH, "//p[contains(text(),'是否要删除此功能?')]"), wd)
            INFO(f"弹窗内容：{notify_text}")
            CHECK_POINT("弹窗内容正确", notify_text == "是否要删除此功能?")

            # 步骤4：点击【确定】按钮
            STEP(4, "点击【确定】按钮")
            safe_click((By.XPATH,
                        "//button[contains(@class,'el-button el-button--default el-button--small el-button--primary')]//span[contains(text(),'确定')]"),
                       wd)
            sleep(2)

            # 步骤5：检查删除结果
            STEP(5, "检查删除结果")
            notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"), "Function_Manage", "Function_Del",
                                          f"{name}_检查提示信息")
            INFO(f"删除结果：{notify_text}")
            CHECK_POINT("删除结果正确", notify_text == check_text)

        elif del_type == "批量删除":
            # 步骤2：勾选全部功能
            STEP(2, "勾选全部功能")
            safe_click((By.XPATH,
                        "//th[contains(@class,'is-leaf el-table__cell')]//span[contains(@class,'el-checkbox__inner')]"),
                       wd)
            sleep(1)

            # 步骤3：点击【批量删除】按钮
            STEP(3, "点击【批量删除】按钮")
            safe_click((By.XPATH, "//span[contains(text(),'批量删除')]"), wd)
            sleep(1)

            # 步骤4：检查弹窗内容
            STEP(4, "检查弹窗内容")
            notify_text = elment_get_text((By.XPATH, "//p[contains(text(),'是否要删除此功能?')]"), wd)
            INFO(f"弹窗内容：{notify_text}")
            CHECK_POINT("弹窗内容正确", notify_text == "是否要删除此功能?")

            # 步骤5：点击【确定】按钮
            STEP(5, "点击【确定】按钮")
            safe_click((By.XPATH,
                        "//button[contains(@class,'el-button el-button--default el-button--small el-button--primary')]//span[contains(text(),'确定')]"),
                       wd)
            sleep(2)
            notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"), "Function_Manage", "Function_Del",
                                          f"{name}_检查提示信息")
            INFO(f"删除结果：{notify_text}")
            CHECK_POINT("删除结果正确", notify_text == check_text)

        elif del_type == "单个取消删除":
            # 步骤2：选择单个删除
            STEP(2, "选择单个删除")
            safe_click((By.XPATH, "//i[@class='el-icon-delete']"), wd)
            sleep(1)

            # 步骤3：检查弹窗内容
            STEP(3, "检查弹窗内容")
            notify_text = elment_get_text((By.XPATH, "//p[contains(text(),'是否要删除此功能?')]"), wd)
            INFO(f"弹窗内容：{notify_text}")
            CHECK_POINT("弹窗内容正确", notify_text == "是否要删除此功能?")

            # 步骤4：点击【取消】按钮
            STEP(4, "点击【取消】按钮")
            safe_click((By.XPATH, "//span[contains(text(),'取消')]"), wd)
            sleep(2)
            notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"), "Function_Manage", "Function_Del",
                                          f"{name}_检查提示信息")
            INFO(f"取消结果：{notify_text}")
            CHECK_POINT("取消结果正确", notify_text == check_text)

        elif del_type == "批量取消删除":
            # 步骤2：勾选全部功能
            STEP(2, "勾选全部功能")
            safe_click((By.XPATH,
                        "//th[contains(@class,'is-leaf el-table__cell')]//span[contains(@class,'el-checkbox__inner')]"),
                       wd)
            sleep(1)

            # 步骤3：点击【批量删除】按钮
            STEP(3, "点击【批量删除】按钮")
            safe_click((By.XPATH, "//span[contains(text(),'批量删除')]"), wd)
            sleep(1)

            # 步骤4：检查弹窗内容
            STEP(4, "检查弹窗内容")
            notify_text = elment_get_text((By.XPATH, "//p[contains(text(),'是否要删除此功能?')]"), wd)
            INFO(f"弹窗内容：{notify_text}")
            CHECK_POINT("弹窗内容正确", notify_text == "是否要删除此功能?")

            # 步骤5：点击【取消】按钮
            STEP(5, "点击【取消】按钮")
            safe_click((By.XPATH, "//span[contains(text(),'取消')]"), wd)
            sleep(2)
            notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"), "Function_Manage", "Function_Del",
                                          f"{name}_检查提示信息")
            INFO(f"取消结果：{notify_text}")
            CHECK_POINT("取消结果正确", notify_text == check_text)

        elif del_type == "不勾选数据":
            # 步骤2：点击【批量删除】按钮，但未勾选任何数据
            safe_click((By.XPATH, "//span[contains(text(),'批量删除')]"), wd)
            sleep(1)
            notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"), "Function_Manage", "Function_Del",
                                          f"{name}_检查提示信息")
            INFO(f"取消结果：{notify_text}")
            CHECK_POINT("取消结果正确", notify_text == check_text)

        # 刷新页面元素
        if name == '功能删除_013':
            wd.refresh()