import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../测试数据/会议审批/会议审批操作.csv')
# 定义时间格式
time_format = "%H:%M"

class MeetingApproval_Status_000x:
    tags = ['会议审批功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 审批会议操作测试报告 --test 审批会议操作_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以会议室删除功能。
            本函数根据参数输入会议室名称进行搜索并删除会议室，并检查删除后的提示信息是否与预期相符。
            字段含义：
              name:用例名称
              conference_name:会议室名称
              message_name:会议名称
              book_start_time:会议开始时间
              book_end_time:会议结束时间
              check_text:检查提示文本
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        name = self.name
        conference_name, message_name, book_start_time, book_end_time, approval_type, approval_opinion, check_text = self.para

        # 在会议室列表搜索会议室
        STEP(1, f"在会议室列表搜索：{conference_name}")
        # 展开筛选下拉框
        safe_click((By.XPATH, "//i[@class='el-collapse-item__arrow el-icon-arrow-right']"), wd)
        sleep(1)
        # 输入会议室名称，并点击【查询】按钮
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议室名称']"), conference_name, wd)
        safe_click((By.XPATH, "//button[@type='button']//span[contains(text(),'查询')]"), wd)
        sleep(1)
        INFO("检查搜索结果")
        # 获取搜索出的会议室名称
        notify_text = elment_get_text((By.XPATH, "//span[@class='MeetingCityList_name']"), wd)
        INFO(f"搜索结果为：{notify_text}")
        CHECK_POINT("搜索结果是否正确", conference_name in notify_text)

        # 点击【会议预定】按钮，进入会议预定界面
        STEP(2, "点击【会议预定】按钮")
        safe_click((By.XPATH, "//span[@class='MeetingCityList_t_btn']"), wd)
        sleep(1)
        INFO("检查页面标题是否正确")
        # 获取页面标题
        notify_text = elment_get_text((By.XPATH, "//div[@class='reserve_Title']"), wd)
        INFO(f"页面标题为：{notify_text}")
        CHECK_POINT("页面标题是否正确", "会议预定" in notify_text)
        sleep(1)

        # 在会议预定第一步界面进行数据填入
        STEP(3, "会议第一步数据填写")
        INFO(
            f"输入会议名称：{message_name}，选择会议开始时间：{book_start_time}，选择会议结束时间：{book_end_time}")
        # 输入会议名称
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议名称']"), message_name, wd)

        # 将字符串转换为时间对象
        start_time = datetime.strptime(book_start_time, time_format)
        end_time = datetime.strptime(book_end_time, time_format)

        # 如果需要将时间差转换为分钟数
        time_diff_minutes = (end_time - start_time).total_seconds() / 60
        INFO(f"时间差为：time_diff_minutes")

        # 判断如果开始时间与结束时间相等，则不重复点击
        if book_start_time == book_end_time:
            INFO(f"开始时间与结束时间相等，选择时间块：{book_start_time}")
            # 根据开始时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_start_time}'])[1]"), wd)
        elif book_start_time != book_end_time:
            INFO(f"开始时间与结束时间不相等，选择时间块：{book_start_time}，{book_end_time}")
            # 根据开始时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_start_time}'])[1]"), wd)
            # 根据结束时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_end_time}'])[1]"), wd)
        sleep(2)

        # 判断时间差是否大于最大预约时长1小时，即60分钟
        if time_diff_minutes > 60:
            INFO(f"时间差大于最大预约时长1小时，选择【超出预约时长】")
            notify_text = get_notify_text(wd, (By.XPATH, "//p[contains(@class,'el-message__content')]"),
                                          "Meeting_Approval", "Approval_Option", f"{name}_超出预约时长")
            INFO(f"提示信息为：{notify_text}")
            CHECK_POINT("超出预约时长提示是否正确", "最大预定时间 1 小时" in notify_text)
            sleep(2)

            # 不选时间点击【下一步】查看提示信息
            INFO("不选时间点击【下一步】查看提示信息")
            safe_click((By.XPATH, "//div[contains(text(),'下一步')]"), wd)
            sleep(1)
            notify_text = get_notify_text(wd, (By.XPATH, "//p[contains(@class,'el-message__content')]"),
                                          "Meeting_Approval", "Approval_Option", f"{name}请选择会议时间提示信息")
            INFO(f"提示信息为：{notify_text}")
            CHECK_POINT("未选时间提示是否正确", "请选择会议时间" in notify_text)
            sleep(1)

            # 重新选择时间，将字符串转换为时间对象
            time_obj = datetime.strptime(book_end_time, time_format)
            time_obj_minus_5_minutes = time_obj - timedelta(minutes=30)

            # 将时间对象转换回字符串
            book_end_time = time_obj_minus_5_minutes.strftime(time_format)
            INFO(f"重新选择结束时间为：{book_end_time}")
            # 根据开始时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_start_time}'])[1]"), wd)
            # 根据结束时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_end_time}'])[1]"), wd)
            sleep(2)

        STEP(4, "连续点击【下一步】按钮创建会议")
        INFO(f"点击【下一步】按钮创建会议")
        sleep(2)
        safe_click((By.XPATH, "//div[contains(text(),'下一步')]"), wd)
        # safe_click((By.XPATH, "//div[@class='header_Quick']"), wd)
        sleep(2)
        safe_click((By.XPATH, "//div[contains(text(),'下一步')]"), wd)
        sleep(2)

        INFO("点击【确定】按钮")
        safe_click((By.XPATH, "//div[contains(text(),'确定')]"), wd)

        safe_click((By.XPATH, "//div[@aria-label='会议信息']//span[contains(text(),'确定')]"), wd)
        sleep(2)
        notify_text = get_notify_text(wd, (By.XPATH, "//p[contains(@class,'el-message__content')]"),
                                      "Meeting_Approval", "Approval_Option", f"{name}预定成功提示信息")
        INFO(f"预定成功提示信息为：{notify_text}")
        CHECK_POINT("预定成功提示是否正确", notify_text == check_text)

        STEP(5,"检查审批会议是否创建成功")
        # 进入会议审批模块
        safe_click((By.XPATH, "//span[contains(text(),'会议审批')]"), wd)
        sleep(2)
        # 查询会议
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议名称搜索']"), message_name, wd)
        send_keyboard((By.XPATH, "//input[@placeholder='请输入会议名称搜索']"), wd)
        sleep(2)
        # 获取审批会议名称
        notify_text = elment_get_text((By.CSS_SELECTOR, "body > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(3) > div:nth-child(1) > div:nth-child(3) > div:nth-child(2) > div:nth-child(1) > div:nth-child(1) > div:nth-child(3) > table:nth-child(1) > tbody:nth-child(2) > tr:nth-child(1) > td:nth-child(2) > div:nth-child(1)"), wd)
        INFO(f"审批会议名称为：{notify_text}")
        SELENIUM_LOG_SCREEN(wd, "50%", "Meeting_Approval", "Approval_Option", f"{name}_审批会议名称")
        CHECK_POINT("审批会议名称是否正确", notify_text == message_name)

        STEP(5, "登录审批人账号，查看是否存在需审批会议")
        safe_click((By.XPATH,"//img[@title='退出登录']"),wd)
        sleep(2)
        # 登录审批人的账号
        user_login("admin@ZDH", "Ubains@4321")
        logging.info("登录审批人账号")
        sleep(2)
        # 进入会议审批模块
        safe_click((By.XPATH,"//ul[@class='meeting_list']//span[contains(text(),'会议审批')]"),wd)
        INFO("进入会议审批模块")
        logging.info("进入会议审批模块")
        sleep(2)
        # 查询会议
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议名称搜索']"), message_name, wd)
        send_keyboard((By.XPATH, "//input[@placeholder='请输入会议名称搜索']"), wd)
        INFO("查询会议")
        logging.info("查询会议")
        sleep(2)
        # 查看会议详细信息
        safe_click((By.XPATH, "//button[@type='button']//span[contains(text(),'详细信息')]"),wd)
        sleep(2)
        SELENIUM_LOG_SCREEN(wd, "50%", "Meeting_Approval", "Approval_Option", f"{name}_审批会议信息")
        safe_click((By.XPATH, "//div[@aria-label='详细信息']//span[contains(text(),'确定')]"), wd)
        logging.info("查看会议详细信息")

        # 点击【审批】按钮
        safe_click((By.XPATH, "//button[@type='button']//span[contains(text(),'审批')]"), wd)
        sleep(1)
        if approval_type == '通过':
            STEP(6, "审批通过")
            # 审批通过
            safe_send_keys((By.XPATH, "//textarea[@placeholder='请输入审批意见']"), approval_opinion, wd)
            INFO("点击审批通过")
            logging.info("审批通过")
            sleep(1)
            # 点击【同意】按钮
            safe_click((By.XPATH, "//span[contains(text(),'同意')]"), wd)
            sleep(2)
            # 获取审批结果
            notify_text = get_notify_text(wd, (By.XPATH, "//p[contains(@class,'el-message__content')]"),
                                          "Meeting_Approval", "Approval_Option", f"{name}审批通过提示信息")
            CHECK_POINT("审批通过提示是否正确", notify_text == "审批完成!")
            INFO(f"审批结果为：{notify_text}")
            logging.info("审批通过")

        else:
            STEP(6, "审批不通过")
            # 审批不通过，不输入审批意见
            safe_click((By.XPATH, "//span[contains(text(),'驳回')]"), wd)
            INFO("点击驳回操作")
            logging.info("点击驳回操作")
            sleep(1)
            notify_text = get_notify_text(wd, (By.XPATH, "//p[contains(@class,'el-message__content')]"),
                                          "Meeting_Approval", "Approval_Option", f"{name}审批意见为空提示信息")
            INFO(f"审批结果为：{notify_text}")
            CHECK_POINT("审批意见为空提示是否正确", notify_text == "请输入审批意见")
            sleep(2)

            # 审批不通过，输入审批意见
            safe_send_keys((By.XPATH, "//textarea[@placeholder='请输入审批意见']"), approval_opinion, wd)
            INFO(f"输入审批意见{approval_opinion}")
            logging.info("输入审批意见")
            sleep(1)
            # 点击【驳回】按钮
            safe_click((By.XPATH, "//span[contains(text(),'驳回')]"), wd)
            sleep(2)
            # 获取审批结果
            notify_text = get_notify_text(wd, (By.XPATH, "//p[contains(@class,'el-message__content')]"),
                                          "Meeting_Approval", "Approval_Option", f"{name}审批不通过提示信息")
            INFO(f"审批结果为：{notify_text}")
            CHECK_POINT("审批不通过提示是否正确", notify_text == "审批完成!")
            logging.info("审批驳回")

        STEP(7, "在我已审批模块查看是否存在审批操作后的会议数据")
        logging.info("查看是否存在审批操作后的会议数据")
        safe_click((By.XPATH, "//div[@id='tab-third']"), wd)
        sleep(1)
        # 查询会议
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议名称搜索']"), message_name, wd)
        send_keyboard((By.XPATH, "//input[@placeholder='请输入会议名称搜索']"), wd)
        INFO(f"查询会议{message_name}")
        logging.info(f"查询会议{message_name}")
        sleep(2)
        # 查看审批会议的名称
        notify_text = elment_get_text((By.CSS_SELECTOR, "body > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(3) > div:nth-child(1) > div:nth-child(3) > div:nth-child(2) > div:nth-child(3) > div:nth-child(1) > div:nth-child(3) > table:nth-child(1) > tbody:nth-child(2) > tr:nth-child(1) > td:nth-child(2) > div:nth-child(1)"), wd)
        INFO(f"审批会议名称为：{notify_text}")
        CHECK_POINT("审批会议名称是否正确", notify_text == message_name)

        # 查看审批会议的状态
        notify_text = elment_get_text((By.CSS_SELECTOR, "body > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(3) > div:nth-child(1) > div:nth-child(3) > div:nth-child(2) > div:nth-child(3) > div:nth-child(1) > div:nth-child(3) > table:nth-child(1) > tbody:nth-child(2) > tr:nth-child(1) > td:nth-child(7) > div:nth-child(1) > span:nth-child(1)"),wd)
        INFO(f"审批会议状态为：{notify_text}")
        logging.info(f"审批会议状态为：{notify_text}")
        CHECK_POINT("审批会议状态是否正确", notify_text == approval_type)
        SELENIUM_LOG_SCREEN(wd, "50%", "Meeting_Approval", "Approval_Option", f"{name}_审批会议名称")

        if approval_type == '通过':
            STEP(8, "在抄送我的模块查看是否存在审批通过的会议数据")
            safe_click((By.XPATH, "//div[@id='tab-fourth']"), wd)
            sleep(1)
            # 查询会议
            safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议名称搜索']"), message_name, wd)
            send_keyboard((By.XPATH, "//input[@placeholder='请输入会议名称搜索']"), wd)
            sleep(2)
            # 查看审批抄送的会议名称
            notify_text = elment_get_text((By.CSS_SELECTOR,
                                           "body > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(3) > div:nth-child(1) > div:nth-child(3) > div:nth-child(2) > div:nth-child(4) > div:nth-child(1) > div:nth-child(3) > table:nth-child(1) > tbody:nth-child(2) > tr:nth-child(1) > td:nth-child(2) > div:nth-child(1)"),
                                          wd)
            INFO(f"审批抄送的会议名称为：{notify_text}")
            CHECK_POINT("审批抄送的会议名称是否正确", notify_text == message_name)
            # 查看审批抄送会议的详细信息
            logging.info("查看审批抄送会议的详细信息")
            safe_click((By.CSS_SELECTOR, "body > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(3) > div:nth-child(1) > div:nth-child(3) > div:nth-child(2) > div:nth-child(4) > div:nth-child(1) > div:nth-child(3) > table:nth-child(1) > tbody:nth-child(2) > tr:nth-child(1) > td:nth-child(7) > div:nth-child(1) > button:nth-child(1) > span:nth-child(1)")
                       ,wd)
            SELENIUM_LOG_SCREEN(wd, "50%", "Meeting_Approval", "Approval_Option", f"{name}_审批抄送的会议详情")

        if name == '审批会议操作_001':
            # 退出当前账号，返回至普通用户账号
            INFO("退出当前账号，返回至普通用户账号")
            logging.info("退出当前账号，返回至普通用户账号")
            safe_click((By.XPATH, "//img[contains(@title,'退出登录')]"), wd)
            user_login("admin@user", "Ubains@4321")