import sys
import os

from hytest.common import SELENIUM_LOG_SCREEN

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..', '..')))
from 运维集控.项目测试.运维标准版.lib.base import *

class AreatypeMod:
    name = '编辑区域类型-001-修改区域类型信息'
    def teststeps(self):
        wd = GSTORE['wd']

        STEP(1, '搜索对应的区域类型')
        areatype_search= WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable((By.XPATH, "(//input[contains(@placeholder,'请输入区域类型')])[1]"))
        )
        areatype_search.clear()
        areatype_search.send_keys("会议室")

        STEP(2, '勾选区域类型')
        areatype_select = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable((By.XPATH, "(//span[contains(@class,'el-checkbox__inner')])[2]"))
        )
        areatype_select.click()

        STEP(3, '点击编辑按钮')
        areatype_mod = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable((By.XPATH, "//div[@class='company-edmit-right']//span[contains(text(),'编辑')]"))
        )
        areatype_mod.click()
        sleep(2)

        STEP(4, '修改区域类型内容')
        type_name = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located((By.XPATH, "//div[@class='el-input el-input--suffix']//input[@placeholder='请输入区域类型']"))
        )
        type_name.clear()
        type_name.send_keys("修改-会议室")

        STEP(5, '修改排序')
        type_sort = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located((By.XPATH, "//input[@placeholder='排序']"))
        )
        type_sort.clear()
        type_sort.send_keys("999")

        STEP(6, '修改备注信息')
        type_remark = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='备注']"))
        )
        type_remark.clear()
        type_remark.send_keys("修改类型备注测试")

        STEP(7, '点击确认')
        commit = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable((By.XPATH, "//div[@class='dialog-footer']//span[contains(text(),'确 定')]"))
        )
        commit.click()

        STEP(8, '验证是否修改成功')
        get_menu = WebDriverWait(wd, 10).until(
            EC.visibility_of_element_located((By.CSS_SELECTOR, '.el-message__content'))
        )
        get_menu1 = get_menu.text
        CHECK_POINT('检查是否出现成功提示弹窗', get_menu1 == "操作成功!")

        # 截图并保存
        SELENIUM_LOG_SCREEN(wd, "50%")
        sleep(1)
        wd.refresh()