import sys
import os

from hytest.common import SELENIUM_LOG_SCREEN

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..', '..')))
from 运维集控.项目测试.运维标准版.lib.base import *

class AreagroupMod:
    name = '编辑分组-001-修改分组信息'
    def teststeps(self):
        wd = GSTORE['wd']

        STEP(1, '勾选分组,点击“编辑”按钮')
        areagroup_select = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable((By.XPATH, "(//span[@class='el-checkbox__inner'])[2]"))
        )
        areagroup_select.click()

        areagroup_modify = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable((By.XPATH, "//span[contains(text(),'编辑')]"))
        )
        areagroup_modify.click()
        sleep(1)

        STEP(2, '修改分组名称')
        group_name = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located((By.XPATH, "//input[@placeholder='长度1-20个字符']"))
        )
        group_name.clear()
        group_name.send_keys("北京分组1-已修改")

        STEP(3, '修改分组地址')
        group_address = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located((By.XPATH, "//input[@placeholder='输入地址不能大于50个字符']"))
        )
        group_address.clear()
        group_address.send_keys("北京-已修改")

        STEP(4, '修改分组备注')
        group_remark = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='请输入备注']"))
        )
        group_remark.clear()
        group_remark.send_keys("修改北京分组")

        STEP(5, '点击确认')
        commit = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable((By.XPATH, "//div[@class='dialog-footer']//span[contains(text(),'确 定')]"))
        )
        commit.click()

        STEP(6, '验证是否修改成功')
        get_menu = WebDriverWait(wd, 10).until(
            EC.visibility_of_element_located((By.CSS_SELECTOR, '.el-message__content'))
        )
        get_menu1 = get_menu.text
        CHECK_POINT('检查是否出现成功提示弹窗', get_menu1 == "操作成功!")

        # 截图并保存
        SELENIUM_LOG_SCREEN(wd, "50%")
        sleep(1)
        wd.refresh()