from hytest.common import SELENIUM_LOG_SCREEN
from win32trace import flush

from 运维集控.项目测试.运维标准版.lib.base import *

# 获取当前文件所在目录
current_dir = os.path.dirname(os.path.abspath(__file__))
# 向上回溯合理层级，假设目标路径为当前文件的上级4级目录
target_dir = os.path.normpath(os.path.join(current_dir, '..', '..', '..', '..', '..'))
# 判断路径是否存在再添加，防止无效路径引发后续问题
if os.path.isdir(target_dir):
    if target_dir not in sys.path:
        sys.path.append(target_dir)
else:
    raise FileNotFoundError(f"目标路径 {target_dir} 不存在，请检查路径层级是否正确。")

# 构建 CSV 文件的绝对路径
csv_path = os.path.abspath(
    os.path.join(os.path.dirname(__file__), '..', '..', 'testdata', '01登录模块', '登录信息.csv'))

class User_Login:
    tags = ['用户登录','管理员登录']
    #构建框架的数据集格式
    ddt_cases = read_csv_data(csv_path)

    def teststeps(self):
        # 获取 WebDriver 实例
        wd = GSTORE['wd']

        #从self.para中解构出数据
        name = self.name
        username, password, captcha, info= self.para

        # 记录当前测试步骤：用户登录
        STEP(1, f'{username} 用户登录测试')
        # 使用从 CSV 读取的数据进行登录
        admin_login(username, password, captcha)

        #记录当前测试步骤：输出提示内容
        STEP(2, f'预期提示内容为：{info}')
        # 记录当前测试步骤：验证是否登录成功
        # 等待系统首页的特定元素（如图片）可见
        get_menu = WebDriverWait(wd, 10).until(
            EC.visibility_of_element_located((By.XPATH, "//p[@class='el-message__content']"))
        )
        get_text = get_menu.text
        STEP(3, f'实际获取登录提示内容：{get_text}')

        # 检查点：验证是否跟预定结果一致
        CHECK_POINT('校验提示内容是否跟预定结果一致', get_text == info)
        # 截图并保存
        SELENIUM_LOG_SCREEN(wd, "50%")
        wd.refresh()

