# -*- coding: utf-8 -*-
# cython: language_level=3
import json
import paho.mqtt.client as mqtt


# 创建MQTT客户端
client = mqtt.Client(protocol=mqtt.MQTTv311)

# 连接服务器
broker_address = "192.168.5.215"
port = 1883
client.connect(broker_address, port)

# 发布消息
topic = "/maintain/room/master/client/"
cliet_udid = '3d53149e-408f-56c6-99ef-29fae67f8efc'
device_udid = '03283caf-e6fd-5866-b39d-917fe16bb713'
message = {
    "action": "_updatestatus",
    "client_udid": cliet_udid,
    "data": [
        {
            "device_udid": device_udid,
            "power": 1,
            "online": 1,
            "run": "run test",
            "watt": 100,
            "bulbtime": 9
        }]
}
client.publish(topic, json.dumps(message), qos=0)

# 断开连接
client.disconnect()
