import sys
import os

# 获取当前脚本的绝对路径
current_dir = os.path.dirname(os.path.abspath(__file__))
# 构建统一平台的绝对路径
platform_path = os.path.abspath(os.path.join(current_dir, '..','..','..'))
# 添加路径
sys.path.append(platform_path)
# 导入模块
from 统一平台.base.bases import *

class Unified_Platform_0001:
    tags = ['统一平台','修改本地会议','重庆长安']
    def teststeps(self):
        wd = GSTORE['wd']
        safe_click((By.XPATH, "//p[contains(text(),'新建会议')]"),wd)
        wd.switch_to.window(wd.window_handles[1])
        # 选择会议室
        INFO("选择多会议室与参会人")
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议室名称']"), '测试会议室', wd)
        send_keyboard((By.XPATH, "//input[@placeholder='请输入会议室名称']"), wd)
        # 选择测试会议室的前三个
        safe_click((By.XPATH, "//body[1]/div[1]/div[2]/div[1]/div[2]/div[1]/div[2]/div[1]/div[1]/div[4]/div[2]/table[1]/tbody[1]/tr[1]/td[1]/div[1]/label[1]/span[1]/span[1]"),wd)
        safe_click((By.XPATH, "//body[1]/div[1]/div[2]/div[1]/div[2]/div[1]/div[2]/div[1]/div[1]/div[4]/div[2]/table[1]/tbody[1]/tr[2]/td[1]/div[1]/label[1]/span[1]/span[1]"), wd)
        safe_click((By.XPATH, "//body[1]/div[1]/div[2]/div[1]/div[2]/div[1]/div[2]/div[1]/div[1]/div[4]/div[2]/table[1]/tbody[1]/tr[3]/td[1]/div[1]/label[1]/span[1]/span[1]"), wd)

        # 选择参会人分配到第一个会议室
        safe_click((By.XPATH, "(//img)[7]"),wd)
        safe_send_keys((By.XPATH, "//input[contains(@placeholder,'请输入关键字搜索')]"), 'pgy', wd)
        send_keyboard((By.XPATH, "//input[contains(@placeholder,'请输入关键字搜索')]"), wd)
        # 全选搜索的参会人
        safe_click((By.XPATH, "//div[contains(@class,'meeting_user')]//div[contains(@class,'el-table__fixed-header-wrapper')]//span[contains(@class,'el-checkbox__inner')]"),wd)
        safe_click((By.XPATH, "//span[contains(text(),'完成')]"),wd)

        # 选择参会人分配到第二个会议室
        safe_click((By.XPATH, "(//img)[9]"),wd)
        safe_send_keys((By.XPATH, "//input[contains(@placeholder,'请输入关键字搜索')]"), '测试', wd)
        send_keyboard((By.XPATH, "//input[contains(@placeholder,'请输入关键字搜索')]"), wd)
        # 全选搜索的参会人
        safe_click((By.XPATH, "//div[contains(@class,'meeting_user')]//div[contains(@class,'el-table__fixed-header-wrapper')]//span[contains(@class,'el-checkbox__inner')]"),wd)
        safe_click((By.XPATH, "//span[contains(text(),'完成')]"),wd)

        # 会议创建，并查看详情
        safe_click((By.XPATH, "//span[contains(text(),'确定创建')]"),wd)
        safe_click((By.XPATH, "//span[contains(text(),'查看详情')]"), wd)
        # 切换窗口2，转到会议详情界面
        # wd.switch_to.window(wd.window_handles[1])
        INFO("查看会议详情是否正确包含：多会议室、参会人、会议名称、会议时间等信息")
        SELENIUM_LOG_SCREEN(wd, "75%")

class Unified_Platform_0002:
    tags = ['统一平台','修改-视讯会议']
    def teststeps(self):
        wd = GSTORE['wd']
        safe_click((By.XPATH, "(//img[@class='el-tooltip item'])[3]"),wd)
        # 选择会议室
        INFO("选择多会议室与参会人")
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议室名称']"), '测试会议室', wd)
        send_keyboard((By.XPATH, "//input[@placeholder='请输入会议室名称']"), wd)
        # 选择测试会议室的前三个
        safe_click((By.XPATH, "//body[1]/div[1]/div[2]/div[1]/div[2]/div[1]/div[2]/div[1]/div[1]/div[4]/div[2]/table[1]/tbody[1]/tr[1]/td[1]/div[1]/label[1]/span[1]/span[1]"),wd)
        safe_click((By.XPATH, "//body[1]/div[1]/div[2]/div[1]/div[2]/div[1]/div[2]/div[1]/div[1]/div[4]/div[2]/table[1]/tbody[1]/tr[2]/td[1]/div[1]/label[1]/span[1]/span[1]"), wd)
        safe_click((By.XPATH, "//body[1]/div[1]/div[2]/div[1]/div[2]/div[1]/div[2]/div[1]/div[1]/div[4]/div[2]/table[1]/tbody[1]/tr[3]/td[1]/div[1]/label[1]/span[1]/span[1]"), wd)

        # 选择参会人分配到第一个会议室
        safe_click((By.XPATH, "(//img)[7]"),wd)
        safe_send_keys((By.XPATH, "//input[contains(@placeholder,'请输入关键字搜索')]"), 'test', wd)
        send_keyboard((By.XPATH, "//input[contains(@placeholder,'请输入关键字搜索')]"), wd)
        # 全选搜索的参会人
        safe_click((By.XPATH, "//div[contains(@class,'meeting_user')]//div[contains(@class,'el-table__fixed-header-wrapper')]//span[contains(@class,'el-checkbox__inner')]"),wd)
        safe_click((By.XPATH, "//span[contains(text(),'完成')]"),wd)

        # 选择参会人分配到第二个会议室
        safe_click((By.XPATH, "(//img)[9]"),wd)
        safe_send_keys((By.XPATH, "//input[contains(@placeholder,'请输入关键字搜索')]"), 'admin', wd)
        send_keyboard((By.XPATH, "//input[contains(@placeholder,'请输入关键字搜索')]"), wd)
        # 全选搜索的参会人
        safe_click((By.XPATH, "//div[contains(@class,'meeting_user')]//div[contains(@class,'el-table__fixed-header-wrapper')]//span[contains(@class,'el-checkbox__inner')]"),wd)
        safe_click((By.XPATH, "//span[contains(text(),'完成')]"),wd)

        # 会议创建，并查看详情
        safe_click((By.XPATH, "//span[contains(text(),'确定创建')]"),wd)
        safe_click((By.XPATH, "//span[contains(text(),'查看详情')]"), wd)
        # 切换窗口2，转到会议详情界面
        # wd.switch_to.window(wd.window_handles[1])
        INFO("查看会议详情是否正确包含：多会议室、参会人、会议名称、会议时间等信息")
        SELENIUM_LOG_SCREEN(wd, "75%")