# 服务自检需求说明文档

## 📋 概述

本脚本主要用于在自动化运行期间的服务器监测，用于检测在自动化运行期间的服务器时间的服务信息。

### 背景

目前针对系统服务进行自检，需要区分两种平台环境：

- **新统一平台**：使用 `/data/` 目录结构
- **传统平台**：使用 `/var/www/` 目录结构

## 🎯 功能实现总览

### 服务监测 (`AutomatedServiceMonitoring.sh`)
    脚本路径：E:\GithubData\自动化\ubains-module-test\AuxiliaryTool\ScriptTool\自动化服务监测\AutomatedServiceMonitoring.sh

#### 检测需求

##### 1、平台识别（✅ 已实现）：
    自动检测目标服务器平台类型（检测 /data/services 目录，如果没有则是传统平台）

##### 2、系统识别（✅ 已实现）：
    自动检测目标服务器的系统类型（检测容器分为三种：ujava、upython、upython_voice，如果有ujava则有会议预定系统、python对应运维集控系统、upython_voice对应转录系统）

##### 3、服务监测（未完成）：
    3.1、日志审计（✅ 已实现）：
        - 根据平台类型持续审计日志信息在某个时间段是否存在暴涨的情况：
            每次采样获取日志总行数 total_lines 和采样时间 now_ts。
            与上次采样 last_total、last_ts 比较，得到 elapsed 和 delta_lines。
            只有当 elapsed ≥ window_seconds（默认 300 秒）时进行判定：
            若 delta_lines ≥ min_lines_threshold（默认 1000 行），判定为暴涨。
            或 delta_lines/elapsed ≥ rate_threshold_per_sec（默认 5 行/秒），判定为暴涨。
            记录暴涨时间段为 [上次采样时间 ~ 本次采样时间]，分别用服务器 date -d @epoch 转成人类可读时间。

        - 记录所有ERROR日志信息上下50行的时间段

        新平台：
            预定系统：
                1、2.0对内后端日志：
                    路径：/data/services/api/java-meeting/java-meeting2.0
                    日志打印：tail -f logs/ubains-INFO-AND-ERROR.log
                2、3.0对内后端日志：
                    路径：/data/services/api/java-meeting/java-meeting3.0
                    日志打印：tail -f logs/ubains-INFO-AND-ERROR.log

        传统平台：
            预定系统：
                1、2.0对内后端日志：
                    路径：/var/www/java/api-java-meeting2.0
                    日志打印：tail -f logs/ubains-INFO-AND-ERROR.log

    3.2、内存资源消耗（✅ 已实现）：
        根据平台类型持续监测服务器内存占用情况，记录峰值与峰值时的时间点，以及记录平均值。
    3.3、mysql连接数（✅ 已实现）：
        根据平台类型持续监测mysql连接数在某个时间段是否存在暴涨，或是异常一直没断开的连接数。
        先检查mysql容器名称，然后通过进入mysql容器内部进行查询，mysql账号为root，密码为dNrprU&2S
    3.4、emqx连接数（未实现）：
        根据平台类型持续监测EMQX连接数量峰值、平均值，以及是否存在暴涨情况，或是判断一直没断开的异常连接。
    3.5、容器信息检测（✅ 已实现）：
        针对当前服务器上存在的运行和未运行的容器进行查询检测，分别记录运行的容器信息和未运行的容器信息，需要列出容器信息。

##### 4、监测日志审计（✅ 已实现）：
    需要丰富日志体系，日志需要用中文打印
##### 5、监测报告输出（✅ 已实现）：
    1、将本次监测的所有检测项信息输出成markdown格式报告，内容排版需要优美，markdown格式报告发送于钉钉。
    2、将本次监测的所有检测项信息输出成word格式报告，内容排版优美，word格式报告发送于邮件。

##### 6、对接邮件发送（✅ 已实现）：
    需要能实现将当前的监测后输出的md文件报告，以邮件的形式发送给czj@huazhaochina.com

##### 7、对接钉钉发送：
    需要能实现将当前的监测后输出的报告，调用钉钉发送给群消息。
    参考代码：E:\GithubData\自动化\ubains-module-test\新统一平台\Base\base.py中的dingding_send_message函数来实现