# SSL 证书生成（自签名，包含 SAN）

目标：生成一套可用于 Nginx 的自签名证书（`server.key` + `server.crt`），支持现代浏览器（包含 SAN），并提供自动化脚本以便快速部署与（可选）替换 Nginx 配置。

注意：OpenSSL 支持的最大有效期有限，常见做法是设置为 100 年（`-days 36500`），接近“长期有效”。自签名 CA 仅在受信任的环境（内网/测试）使用。

## 先决条件
- 服务器需安装 `openssl`。
- 若希望脚本自动写入并重载 nginx，需具备相应的文件访问/重载权限（或 root 权限）。

## 要点
- 必须包含 `subjectAltName`（SAN），否则现代浏览器会拒绝或显示不安全警告。
- 脚本会尝试自动检测主机 IPv4 并填充到 SAN 的 IP 项中；也可通过 `--ip` 指定。

---

## 一、san.cnf 示例（带 SAN）
以下模板会被脚本生成；你也可以手动创建并修改：

```ini
[req]
default_bits = 2048
prompt = no
default_md = sha256
distinguished_name = dn
req_extensions = v3_req

[dn]
CN = ubains.com
O = UBAINS
OU = DevOps
C = CN
ST = Guangdong
L = Shenzhen
emailAddress = admin@ubains.com

[v3_req]
basicConstraints = CA:TRUE
keyUsage = critical, digitalSignature, keyEncipherment, keyCertSign
extendedKeyUsage = serverAuth
subjectAltName = @alt_names

[alt_names]
DNS.1 = ubains.com
DNS.2 = localhost
IP.1 = 192.168.1.100   ; 脚本会自动替换为服务器实际 IP
```

---

## 二、推荐方式：使用仓库中的脚本（自动化）

脚本路径：`辅助工具/脚本工具/服务器ssl证书生成/generate_ssl.sh`

示例：

```bash
# 在当前目录生成 cert/key（自动检测 IP）
bash generate_ssl.sh --domain ubains.com --out /etc/ssl/ubains

# 指定输出目录并直接修改 nginx 配置（会备份原文件并尝试重载）
bash generate_ssl.sh --domain ubains.com --out /etc/ssl/ubains --nginx-conf /etc/nginx/conf.d/unified443.conf --yes
```

脚本要点：
- 自动检测本机 IPv4 并填充到 SAN 中（可用 `--ip` 覆盖）。
- 默认证书有效期 100 年（`-days 36500`），可用 `--days` 修改。
- 会生成 `san.cnf`、`server.key`、`server.crt` 到 `--out` 指定目录。
- 若不指定 `--nginx-conf`，脚本会自动检测 PRD 常见配置路径并提示是否一键替换（支持 `--yes` 跳过提示）。

自动检测的候选 nginx 配置路径（来自 PRD）：

- `/data/middleware/nginx/config/unified443.conf`  （统一平台）
- `/var/www/java/nginx-conf.d/meeting443.conf`      （预定系统）
- `/var/www/html/nginx-conf/moblie8081.conf`        （运维系统）
- `/var/www/html/nginx-conf/rms8443.conf`           （运维系统）

脚本在替换配置前会备份原文件（`*.bak.TIMESTAMP`）。替换后尝试 `nginx -t` 与重载，若失败会提示手动操作或使用 systemctl/docker 重启。

---

## 三、Nginx 配置示例

在你的 `server {}` 块中，确保有：

```nginx
ssl_certificate      /path/to/server.crt;
ssl_certificate_key  /path/to/server.key;
```

PRD 中常见的重载命令示例：

- 统一平台（示例）:
  - 配置文件：`/data/middleware/nginx/config/unified443.conf`
  - 重启：`docker restart nginx`
- 预定系统（示例）:
  - 配置文件：`/var/www/java/nginx-conf.d/meeting443.conf`
  - 重载：`docker exec -it ujava2 bash; /usr/local/nginx/sbin/nginx -s reload`
- 运维系统（示例）:
  - 配置文件：`/var/www/html/nginx-conf/moblie8081.conf` 或 `rms8443.conf`
  - 重载：`docker exec -it upython bash; /usr/local/nginx/sbin/nginx -s reload`

如果在系统上运行 nginx，可使用：

```bash
nginx -t && nginx -s reload
# 或
systemctl reload nginx
```

---

## 四、在操作系统 / 浏览器 中导入证书（建立信任）

- Windows
  1. 双击 `server.crt` → 点击 “安装证书” → 选择 “本地计算机”。
  2. 放入 “受信任的根证书颁发机构” 存储。
  3. 完成后重启浏览器。

- macOS
  1. 双击 `server.crt` 打开“钥匙串访问”。
  2. 在 `System` 钥匙串中找到证书，设置为 `Always Trust`（始终信任）。

- Linux (Ubuntu/Debian)
```bash
sudo cp server.crt /usr/local/share/ca-certificates/ubains-ca.crt
sudo update-ca-certificates
```

- Firefox（独立证书库）
  - 设置 → 隐私与安全 → 证书 → “查看证书” → “证书机构” → “导入” → 选择 `server.crt`，勾选 “信任此 CA 以标识网站”。

---

## 五、测试步骤

1. 确认域名解析：若域名不在 DNS 中，请在浏览器所在机器的 `/etc/hosts`（Windows: `C:\Windows\System32\drivers\etc\hosts`）中添加 `IP domain` 映射。
2. 关闭并完全重启浏览器（确保信任链刷新）。
3. 访问 `https://<domain>` 或 `https://<ip>`，应看到锁图标且无证书错误。

---

## 六、注意与故障排查

- 自签名 CA 仅对受信任的客户端有效；生产环境请使用受信任的公有 CA（如 Let’s Encrypt、商业 CA）。
- 若浏览器仍报错：
  - 检查证书是否包含 SAN（`openssl x509 -in server.crt -text -noout`）。
  - 确认证书已导入到“受信任的根证书颁发机构”。
  - 检查 nginx 是否使用了正确的证书路径并重载成功（`nginx -t`）。
- 常见权限问题：私钥权限应为 600（`chmod 600 server.key`）。

---

## 七、变更记录

- 2025-12-26：整合并优化文档，新增自动化脚本 `generate_ssl.sh` 说明与 nginx 自动检测/替换说明。

---

## 八、配置文件 → 重载/重启 命令

说明：为了确保替换配置后能按各系统要求正确重载 nginx，建议在文档或脚本中维护显式的“配置文件路径 → 重载命令”映射。脚本实现自动检测并尝试多种重载方式。

默认建议映射（可直接放入脚本变量或单独配置文件）：

- 统一平台
  - 配置路径：`/data/middleware/nginx/config/unified443.conf`
  - 推荐命令：`docker restart nginx`

- 预定系统
  - 配置路径：`/var/www/java/nginx-conf.d/meeting443.conf`
  - 推荐命令：`docker exec -it ujava2 /usr/local/nginx/sbin/nginx -s reload`

- 运维系统
  - 配置路径：`/var/www/html/nginx-conf/moblie8081.conf`和`/var/www/html/nginx-conf/rms8443.conf`
  - 推荐命令：`docker exec -it upython /usr/local/nginx/sbin/nginx -s reload`
- 