统信系统漏洞修复 PRD
=======================

**操作系统版本：** UOS Server 20 1070e  
**文档目的：** 提供自动化脚本修复系统安全漏洞并支持复测验证

---

## 漏洞修复清单

### 问题一：OpenSSH 安全配置加固

#### 修复步骤：
1. **编辑 SSH 配置文件**
   ```bash
   cp -p /etc/ssh/sshd_config /etc/ssh/sshd_config_bak
   ```
   
   编辑配置文件 `/etc/ssh/sshd_config`，修改以下参数：
   ```
   X11Forwarding no
   MaxAuthTries 4
   IgnoreRhosts yes
   HostbasedAuthentication no
   PermitEmptyPasswords no
   PermitRootLogin no
   Protocol 2
   ```

2. **重启 SSH 服务**
   ```bash
   systemctl restart sshd
   # 或者使用
   # /etc/init.d/sshd restart
   ```

#### 检测方法：
- 检查 `/etc/ssh/sshd_config` 文件中对应参数的值
- 验证 SSH 服务是否正常运行：`systemctl status sshd`

---

### 问题二：命令行界面超时设置

#### 修复步骤：
1. **备份配置文件**
   ```bash
   cp -p /etc/profile /etc/profile_bak
   ```

2. **配置超时参数**
   在 `/etc/profile` 文件中添加或修改以下内容：
   ```bash
   TMOUT=300
   export TMOUT
   ```

3. **使配置立即生效**
   ```bash
   source /etc/profile
   ```

#### 检测方法：
- 检查 `/etc/profile` 文件中是否存在 `TMOUT=300` 和 `export TMOUT`
- 验证环境变量：`echo $TMOUT`

---

### 问题三：PAM 认证模块配置（限制 su 切换 root）

#### 修复步骤：
1. **编辑 PAM 配置文件**
   编辑 `/etc/pam.d/su` 文件，在文件开头添加以下内容：
   ```
   auth            sufficient      pam_rootok.so
   auth            required        pam_wheel.so    group=wheel
   ```

2. **将用户添加到 wheel 组**
   ```bash
   usermod -G wheel username  # 将 username 替换为实际用户名
   ```

#### 检测方法：
- 检查 `/etc/pam.d/su` 文件中是否包含上述两行配置
- 验证 wheel 组成员：`groups username`

---

### 问题四：禁用 Telnet，启用 SSH 协议

#### 修复步骤：
1. **禁用 Telnet 服务**
   ```bash
   cp -p /etc/xinetd.d/telnet /etc/xinetd.d/telnet_bak
   # 编辑 /etc/xinetd.d/telnet 文件，将 disable 设置为 yes
   sed -i 's/disable.*/disable = yes/' /etc/xinetd.d/telnet
   service xinetd restart
   ```

2. **确保 SSH 服务已启动**
   ```bash
   systemctl start sshd
   systemctl enable sshd
   ```

#### 检测方法：
- 检查 `/etc/xinetd.d/telnet` 文件中的 `disable` 参数是否为 `yes`
- 验证 xinetd 服务状态：`systemctl status xinetd`
- 验证 SSH 服务状态：`systemctl status sshd`

---

### 问题五：禁用 Root 用户远程登录

此问题已在问题一中通过设置 `PermitRootLogin no` 解决。

#### 检测方法：
- 检查 `/etc/ssh/sshd_config` 文件中 `PermitRootLogin` 是否设置为 `no`

---

### 问题六：登录日志记录配置

#### 修复步骤：
1. **编辑 rsyslog 配置文件**
   编辑 `/etc/rsyslog.conf` 文件，添加以下配置：
   ```
   authpriv.* /var/log/secure
   # 或者
   # authpriv.info /var/log/secure
   ```

2. **创建并设置日志文件权限**
   ```bash
   touch /var/log/secure
   chmod 600 /var/log/secure
   ```

3. **重启 syslog 服务**
   ```bash
   systemctl restart rsyslog
   # 或者
   # /etc/init.d/rsyslog restart
   ```

#### 检测方法：
- 检查 `/etc/rsyslog.conf` 文件中是否包含 authpriv 配置
- 验证 `/var/log/secure` 文件是否存在且权限为 600：`ls -la /var/log/secure`

---

### 问题七：用户目录默认访问权限设置

#### 修复步骤：
1. **备份配置文件**
   ```bash
   cp /etc/profile /etc/profile.bak
   ```

2. **设置默认 umask 值**
   编辑 `/etc/profile` 文件，在文件末尾添加：
   ```
   umask 027
   ```

3. **使配置生效**
   ```bash
   source /etc/profile
   ```

#### 检测方法：
- 检查 `/etc/profile` 文件中是否包含 `umask 027`
- 验证当前 umask 值：`umask`

---

### 问题八：设置口令过期前警告天数

#### 修复步骤：
1. **备份配置文件**
   ```bash
   cp -p /etc/login.defs /etc/login.defs_bak
   ```

2. **修改密码过期警告天数**
   编辑 `/etc/login.defs` 文件，设置：
   ```
   PASS_WARN_AGE 7
   ```

#### 检测方法：
- 检查 `/etc/login.defs` 文件中 `PASS_WARN_AGE` 的值

---

### 问题九：密码复杂度策略配置

#### 修复步骤：
1. **备份配置文件**
   ```bash
   cp /etc/pam.d/system-auth /etc/pam.d/system-auth.bak
   ```

2. **编辑 PAM 配置文件**
   编辑 `/etc/pam.d/system-auth` 文件，找到如下行：
   ```
   password requisite pam_cracklib.so
   ```
   
   修改为：
   ```
   password requisite pam_cracklib.so try_first_pass retry=3 minlen=8 dcredit=-1 ucredit=-1 ocredit=-1 lcredit=-1
   ```
   
   此配置要求密码长度不小于8位，至少包含1位数字、大写字母、小写字母和特殊字符。

#### 检测方法：
- 检查 `/etc/pam.d/system-auth` 文件中是否包含上述复杂度规则
- 验证参数是否完整：`minlen=8 dcredit=-1 ucredit=-1 ocredit=-1 lcredit=-1`

---

### 问题十：设置口令更改最小间隔天数

#### 修复步骤：
1. **备份配置文件**
   ```bash
   cp -p /etc/login.defs /etc/login.defs_bak
   ```

2. **修改密码最短使用期限**
   编辑 `/etc/login.defs` 文件，设置：
   ```
   PASS_MIN_DAYS 7
   ```

#### 检测方法：
- 检查 `/etc/login.defs` 文件中 `PASS_MIN_DAYS` 的值

---

### 问题十一：设置口令生存周期

#### 修复步骤：
1. **备份配置文件**
   ```bash
   cp -p /etc/login.defs /etc/login.defs_bak
   ```

2. **修改密码最长使用期限**
   编辑 `/etc/login.defs` 文件，设置：
   ```
   PASS_MAX_DAYS 90
   ```

#### 检测方法：
- 检查 `/etc/login.defs` 文件中 `PASS_MAX_DAYS` 的值

---

### 问题十二：重要目录及文件权限设置

#### 修复步骤：
1. **设置关键系统文件权限**
   ```bash
   chmod 644 /etc/passwd
   chmod 400 /etc/shadow
   chmod 644 /etc/group
   ```

#### 检测方法：
- 检查各文件权限：`ls -la /etc/passwd /etc/shadow /etc/group`
- 验证权限是否为：`/etc/passwd` (644), `/etc/shadow` (400), `/etc/group` (644)

---

### 问题十三：账户认证失败次数限制

#### 修复步骤：
1. **备份配置文件**
   ```bash
   cp -p /etc/pam.d/system-auth /etc/pam.d/system-auth_bak
   ```

2. **编辑 PAM 配置文件**
   编辑 `/etc/pam.d/system-auth` 文件，添加以下内容：
   ```
   auth required pam_tally2.so deny=5 unlock_time=180 onerr=fail no_magic_root
   account required pam_tally2.so
   ```
   
   此配置表示认证失败5次后锁定账户180秒。

#### 检测方法：
- 检查 `/etc/pam.d/system-auth` 文件中是否包含上述配置
- 验证参数是否完整：`deny=5 unlock_time=180`

---

### 问题十四：历史命令数量限制

#### 修复步骤：
1. **编辑配置文件**
   编辑 `/etc/profile` 文件，添加以下内容：
   ```
   HISTFILESIZE=5    # 历史文件中保存的最大命令数
   HISTSIZE=5        # 命令行中显示的历史命令数
   ```

2. **使配置生效**
   ```bash
   source /etc/profile
   ```

#### 检测方法：
- 检查 `/etc/profile` 文件中是否包含 `HISTFILESIZE=5` 和 `HISTSIZE=5`
- 验证变量值：`echo $HISTFILESIZE` 和 `echo $HISTSIZE`

---

### 问题十五：密码重复使用次数限制

#### 修复步骤：
1. **备份配置文件**
   ```bash
   cp -p /etc/pam.d/system-auth /etc/pam.d/system-auth_bak
   ```

2. **创建旧密码存储文件**
   ```bash
   touch /etc/security/opasswd
   chown root:root /etc/security/opasswd
   chmod 600 /etc/security/opasswd
   ```

3. **编辑 PAM 配置文件**
   编辑 `/etc/pam.d/system-auth` 文件，找到如下行：
   ```
   password sufficient pam_unix.so
   ```
   
   修改为：
   ```
   password sufficient pam_unix.so remember=5
   ```
   
   此配置表示不能使用最近5次使用的密码。

#### 检测方法：
- 检查 `/etc/pam.d/system-auth` 文件中是否包含 `remember=5` 参数
- 验证 `/etc/security/opasswd` 文件是否存在且权限正确

---

### 问题十六：禁用 Ctrl+Alt+Delete 组合键

#### 修复步骤：
1. **禁用系统级的 Ctrl+Alt+Delete 服务**
   ```bash
   systemctl mask ctrl-alt-del.target
   ```
   
   或者直接删除链接文件：
   ```bash
   rm -f /usr/lib/systemd/system/ctrl-alt-del.target
   ```

#### 检测方法：
- 检查服务状态：`systemctl is-enabled ctrl-alt-del.target` (应返回 "masked")

---

## 自动化脚本工具

### 检测脚本 (security_check.sh)

提供一个自动化检测脚本，可检查系统当前安全配置状态：

- 检查所有16个安全配置项的状态
- 输出详细日志到临时文件
- 提供彩色输出便于阅读
- 生成汇总报告，显示通过率和达标情况
- 打印每个检测项的实际配置内容，便于第三方验证

### 修复脚本 (security_fix.sh)

提供一个自动化修复脚本，可修复安全漏洞：

- 修复所有16个安全配置项
- 每次修改前自动创建备份文件
- 提供交互式菜单，可以选择完整修复或选择性修复
- 使用彩色输出区分不同类型的信息
- 包含确认机制防止误操作
- 修复完成后自动重启相关服务

---

## 总结

该文档涵盖了系统安全的各个方面，包括：
- SSH 安全配置
- 用户权限控制
- 密码策略设置
- 日志记录
- 命令历史限制
- 认证失败处理

建议在执行以上所有配置后重启系统以确保所有设置生效。

通过自动化脚本可以简化检测和修复过程，提高工作效率和准确性。