import sys
import os

from 预定配套件.Base.app_base import find_element_with_retry

# 获取当前脚本的绝对路径
current_dir = os.path.dirname(os.path.abspath(__file__))
# 构建预定系统的绝对路径
预定配套件_path = os.path.abspath(os.path.join(current_dir, '..', '..', '..','..'))
# 添加路径
sys.path.append(预定配套件_path)
# 导入模块
from 预定配套件.Base.base import *
from 预定配套件.Base.app_base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建XLSX文件的绝对路径
xlsx_file_path = os.path.join(current_dir, '..', '..', '..', '测试数据', '门口屏5.0测试用例.xlsx')

class DoorScreenDeployment:
    tags = ['门口屏首页功能']
    """
        执行指令是：
            1.cd .\预定配套件\中控门口屏\
            2.hytest --report_title 门口屏首页功能测试报告 --report_url_prefix http://nat.ubainsyun.com:31133 --tag 门口屏首页功能
    """
    ddt_cases = read_xlsx_data(xlsx_file_path, sheet_name='第二主界面',case_type="标准版")
    # 测试开始前调用clear_columns_in_xlsx函数，将测试用例中的测试结果和日志截图置空
    clear_columns_in_xlsx(xlsx_file_path, sheet_name='第二主界面', columns_to_clear=['测试结果', '测试频次', '日志截图'])

    def teststeps(self):
        """
        执行测试步骤函数，主要用于执行读取的测试用例并进行会议预定界面操作
        """
        # 从全局存储中获取webdriver对象
        wd = GSTORE['wd']
        name = self.name
        sleep(1)

        # 初始化应用驱动，连接到指定的设备和应用
        app_drive = app_setup_driver("Android", "11", "DoorScreen", "com.ubains.local.gviewer",
                                     "com.ubains.ub.gview.SplashActivity", "192.168.1.128:5555")
        app_drive.implicitly_wait(60)  # 设置缺省等待时间

        # 使用显式等待来等待元素出现
        logging.info("等待首页加载...")

        for step in self.para:
            # 赋值页面类型page
            page_type = step.get('page')
            # 赋值元素定位类型，并将字符串转为Enum类型
            locator_type = app_get_by_enum(step.get('locator_type'))
            # 赋值元素值
            locator_value = step.get('locator_value')
            # 赋值元素类型，例如：click点击、input输入框等
            element_type = step.get('element_type')
            # 赋值元素值，例如输入框的输入值
            element_value = step.get('element_value')
            # 赋值预期结果
            expented_result = step.get('expented_result')
            # 赋值灯带时间
            sleep_time = step.get('sleep_time')

            # 判断页面功能类型
            if page_type == "Deployment":

                if element_type == "input":
                    INFO(f"输入框输入定位类型：{element_type}")
                    # 调用app输入函数
                    input_text_with_retry(app_drive,locator_type, locator_value,element_value)
                    sleep(sleep_time)

                elif element_type == "click":
                    # 调用app点击函数
                    click_element_with_retry(app_drive, locator_type, locator_value)
                    sleep(sleep_time)

                elif element_type == "getText":
                    # 调用app获取文本函数
                    element_text = get_text_with_retry(app_drive, locator_type, locator_value)
                    INFO(f"APP获取到的文本信息：{element_text}")
                    sleep(sleep_time)