import requests
import json
import time
from hashlib import sha1
from urllib.parse import urlencode
import logging

# 配置日志
logging.basicConfig(level=logging.INFO, format='%(asctime)s - %(levelname)s - %(message)s')

def reservation_paged_list():
    """
    获取预约分页列表的数据。

    本函数通过发送POST请求到指定的URL，获取预约分页列表的数据。
    它首先构造请求所需的URL、数据参数和签名，然后发送请求并处理响应。
    """
    # 定义API的URL
    url = "https://pmsapi.demo.dasiot.cn/v4/api/reservation/reservationPagedList"

    # 获取当前时间戳，用于请求签名
    timestamp = int(time.time() * 1000)

    # 定义请求体的数据参数
    data_map = {
        "pageIndex": 1,
        "pageSize": 1000
    }

    # 创建签名所用的字典，包含数据参数和时间戳
    sign_map = data_map.copy()
    sign_map["timestamp"] = timestamp

    # 拼接sign参数
    data_str = urlencode(sign_map).lower()
    string_sign_temp = f"{data_str}&key=2cc2e7-b027-41bb-af4b-f6"

    # 对stringSignTemp进行SHA-1运算并转为大写，生成最终的签名
    sign = sha1(string_sign_temp.encode()).hexdigest().upper()

    # 定义请求头，包含时间戳和签名
    headers = {
        "timestamp": str(timestamp),
        "sign": sign
    }

    # 记录日志，包括签名、请求路径、请求头和请求体参数
    logging.info(f"获取sign：{sign}")
    logging.info(f"分页查询预约列表请求路径：{url}")
    logging.info(f"分页查询预约列表请求头：{headers}")
    logging.info(f"分页查询预约列表请求体参数：{data_map}")

    try:
        # 发送POST请求
        response = requests.post(url, json=data_map, headers=headers)

        # 检查响应状态码，如果状态码表示请求有错误，则抛出异常
        response.raise_for_status()

        # 获取响应体内容
        body_str = response.text

        # 记录响应日志
        logging.info(f"分页查询预约列表返回参数：{body_str}")
    except requests.exceptions.RequestException as e:
        # 如果请求失败，记录错误日志
        logging.error(f"请求失败：{e}")

if __name__ == "__main__":
    reservation_paged_list()