from time import sleep
from hytest import *
import sys
import os


# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/账号管理/部门管理模块/部门查询.csv')

class Department_Query_000x:
    tags = ['部门管理功能' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 部门查询测试报告 --test 部门查询_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以部门管理主流程功能。
            本函数根据参数输入部门名称，并检查新增后的提示信息是否与预期相符。
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        department_name, new_department_name, query_type, check_query_text = self.para

        STEP(1, "增加测试数据")
        # 点击添加按钮以开始新增部门流程
        safe_click((By.XPATH, "(//span[contains(text(),'添 加')])[1]"), wd)
        sleep(1)
        # 获取新增后的通知文本并与预期比较
        notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"),"Department_Manage", "Department_Query", f"{name}部门新增")
        INFO(f"部门新增提示：{notify_text}")
        CHECK_POINT(f"新增部门提示文本", notify_text == "添加成功")

        STEP(2, f"选择：{department_name}，点击编辑按钮")
        sleep(2)
        # 点击编辑按钮以开始编辑部门流程
        safe_click((By.XPATH, "(//span[contains(text(),'编 辑')])[3]"), wd)
        notify_text = elment_get_text((By.XPATH, "//span[@class='el-dialog__title'][contains(text(),'编 辑')]"), wd)
        CHECK_POINT("部门编辑页标题", notify_text == "编 辑")

        STEP(3, f"输入部门名称：{new_department_name}")
        # 输入新的部门名称
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字搜索']"), new_department_name, wd)
        safe_click((By.XPATH, "//div[@aria-label='编 辑']//span[contains(text(),'确定')]"), wd)
        sleep(1)

        STEP(4, "检查部门编辑提示信息")
        sleep(2)
        # 获取编辑后的通知文本并与预期比较
        notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"),"Department_Manage", "Department_Query", f"{name}部门编辑")
        INFO(f"部门编辑提示：{notify_text}")
        CHECK_POINT("检查部门编辑提示", notify_text == "修改成功")

        STEP(5, f"输入原部门名称：{department_name}进行查询")
        # 输入原部门名称以进行查询
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), department_name, wd)
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
        sleep(1)

        STEP(6, "检查部门查询结果")
        notify_text = elment_get_text((By.XPATH, "//span[@class='el-tree__empty-text']"), wd)
        INFO(f"部门查询结果：{notify_text}")
        CHECK_POINT("部门查询提示", notify_text == "暂无数据")

        if query_type == "精确查询":
            STEP(7, f"输入新部门名称：{check_query_text}，进行精确查询")
            safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), check_query_text, wd)
            send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
            SELENIUM_LOG_SCREEN(wd, "50%", "Department_Manage", "Department_Query", f"{name}_部门精确查询")
            sleep(1)

        elif query_type == "模糊查询":
            STEP(7, f"输入新部门名称：{check_query_text}，进行模糊查询")
            safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), check_query_text, wd)
            send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
            SELENIUM_LOG_SCREEN(wd, "50%", "Department_Manage", "Department_Query", f"{name}_部门模糊查询")
            sleep(1)

        STEP(8, "检查部门查询结果")
        notify_text = elment_get_text((By.XPATH, f"//span[@title='{new_department_name}']"), wd)
        INFO(f"部门查询结果：{notify_text}")
        CHECK_POINT("部门查询结果", check_query_text in notify_text)

        STEP(9, "删除部门数据")
        # 点击删除按钮以开始删除部门流程
        safe_click((By.XPATH, "(//span[contains(text(),'删除')])[4]"), wd)
        safe_click((By.XPATH, "(//span[contains(text(),'确定')])[4]"), wd)
        sleep(2)
        # 获取删除后的通知文本并与预期比较
        notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"),"Department_Manage", "Department_Query", f"{name}删除部门数据")
        CHECK_POINT("部门删除提示", notify_text == "删除成功")
        INFO(f"检查CPU使用率：{get_cpu_usage()}")

        if name == '部门查询_006':
            wd.refresh()