from time import sleep
from hytest import *
import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/账号管理/部门管理模块/部门删除.csv')

class Department_Add_000x:
    tags = ['部门管理功能' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 部门删除测试报告 --test 部门删除_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以部门管理主流程功能。
            本函数根据参数输入部门名称，并检查新增后的提示信息是否与预期相符。
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        department_delete_type, check_add_text, check_del_text = self.para

        if department_delete_type == "单个删除":
            sleep(2)
            # 步骤1: 点击部门新增按钮
            STEP(1, "点击部门新增按钮")
            # 安全点击操作，找到新增按钮并点击
            safe_click((By.XPATH, "//button[@class='el-button el-button--primary el-button--medium']"), wd)
            sleep(1)
            STEP(2, "检查父级部门新增提示文本信息")
            # 获取新增后的通知文本
            notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"),"Department_Manage", "Department_Delete", f"{name}部门新增")
            # 检查新增提示文本是否与预期相符
            INFO(f"父级部门新增提示文本:{notify_text}")
            CHECK_POINT("父级部门新增提示文本", notify_text == check_add_text)
            sleep(2)

            STEP(3, "点击部门删除按钮")
            safe_click((By.XPATH, "(//span[contains(text(),'删除')])[4]"),wd)
            safe_click((By.XPATH, "(//span[contains(text(),'确定')])[4]"),wd)
            sleep(2)
            notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"),"Department_Manage", "Department_Delete", f"{name}部门单个删除")
            INFO(f"单个部门删除提示文本:{notify_text}")
            CHECK_POINT("单个部门删除提示文本", notify_text == check_del_text)
            sleep(2)

        elif department_delete_type == "批量删除":
            sleep(2)
            # 步骤1: 点击部门新增按钮
            STEP(1, "点击部门新增按钮")
            # 安全点击操作，找到新增按钮并点击
            INFO("点击部门新增按钮,新增多个部门")
            for i in range(3):
                safe_click(
                    (By.XPATH, "(//span[contains(text(),'添 加')])[1]"),
                    wd)
                sleep(2)
                notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"),"Department_Manage", "Department_Delete", f"{name}第{i+1}个部门新增")
                CHECK_POINT(f"新增第{i+1}个部门提示文本", notify_text == check_add_text)

            STEP(2, "检查勾选多个部门")
            safe_click((By.XPATH, "(//span[@class='el-checkbox__inner'])[3]"),wd)
            safe_click((By.XPATH, "(//span[@class='el-checkbox__inner'])[4]"),wd)
            safe_click((By.XPATH, "(//span[@class='el-checkbox__inner'])[5]"),wd)
            sleep(1)
            STEP(3, "点击批量删除按钮")
            safe_click((By.XPATH, "(//span[contains(text(),'批量删除')])[1]"),wd)
            safe_click((By.XPATH, "(//span[contains(text(),'确定')])[4]"),wd)
            sleep(2)
            notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"),"Department_Manage", "Department_Delete", f"{name}部门批量删除")
            INFO(f"批量部门删除提示文本:{notify_text}")
            CHECK_POINT("批量部门删除提示文本", notify_text == check_del_text)

        elif department_delete_type == "不勾选部门进行批量删除":
            sleep(2)
            STEP(1, "点击批量删除按钮")
            safe_click((By.XPATH, "//button[@type='button']//span[contains(text(),'批量删除')]"), wd)
            sleep(2)
            STEP(2, "检查提示信息")
            notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"),"Department_Manage", "Department_Delete", f"{name}部门不勾选批量删除")
            CHECK_POINT("不勾选部门进行批量删除提示文本", notify_text == check_del_text)

        if name == '部门删除_003':
            wd.refresh()